/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.comforts.common.block;

import com.mojang.datafixers.util.Either;
import java.util.List;
import net.fabricmc.fabric.api.entity.event.v1.EntitySleepEvents;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1588;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1750;
import net.minecraft.class_1767;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2244;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2383;
import net.minecraft.class_243;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2742;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_3481;
import net.minecraft.class_3494;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3614;
import net.minecraft.class_3737;
import net.minecraft.class_3902;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4838;
import net.minecraft.class_4970;
import top.theillusivec4.comforts.mixin.AccessorPlayerEntity;

public abstract class AbstractComfortsBlock
extends class_2244
implements class_3737 {
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    protected final class_1767 color;
    private final BedType type;

    public AbstractComfortsBlock(BedType type, class_1767 color) {
        super(color, class_4970.class_2251.method_9637((class_3614)class_3614.field_15931).method_9626(class_2498.field_11543).method_9632(0.1f));
        this.type = type;
        this.color = color;
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)field_9967, (Comparable)class_2742.field_12557)).method_11657((class_2769)field_9968, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (world.field_9236) {
            return class_1269.field_21466;
        }
        if (state.method_11654((class_2769)field_9967) != class_2742.field_12560 && !(state = world.method_8320(pos = pos.method_10093((class_2350)state.method_11654((class_2769)field_11177)))).method_27852((class_2248)this)) {
            return class_1269.field_21466;
        }
        if (!AbstractComfortsBlock.method_27352((class_1937)world)) {
            world.method_8650(pos, false);
            class_2338 blockPos = pos.method_10093(((class_2350)state.method_11654((class_2769)field_11177)).method_10153());
            if (world.method_8320(blockPos).method_27852((class_2248)this)) {
                world.method_8650(blockPos, false);
            }
            world.method_8454(null, class_1282.method_5523(), null, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 5.0f, true, class_1927.class_4179.field_18687);
            return class_1269.field_5812;
        }
        if (((Boolean)state.method_11654((class_2769)field_9968)).booleanValue()) {
            if (!this.isFree(world, pos)) {
                player.method_7353((class_2561)new class_2588("block.comforts." + this.type.name + ".occupied"), true);
            }
            return class_1269.field_5812;
        }
        if (player instanceof class_3222) {
            this.trySleep((class_3222)player, pos).ifLeft(sleepFailureReason -> {
                if (sleepFailureReason != null) {
                    class_2588 text;
                    switch (sleepFailureReason) {
                        case field_7529: {
                            class_2588 class_25882;
                            if (this.type == BedType.HAMMOCK) {
                                class_25882 = new class_2588("block.comforts." + this.type.name + ".no_sleep");
                                break;
                            }
                            class_25882 = new class_2588("block.minecraft.bed.no_sleep");
                            break;
                        }
                        case field_7530: {
                            class_2588 class_25882 = new class_2588("block.comforts." + this.type.name + ".too_far_away");
                            break;
                        }
                        default: {
                            class_2588 class_25882 = text = sleepFailureReason.method_19206();
                        }
                    }
                    if (text != null) {
                        player.method_7353((class_2561)text, true);
                    }
                }
            });
        }
        return class_1269.field_5812;
    }

    private static class_2350 getDirectionTowardsOtherPart(class_2742 part, class_2350 direction) {
        return part == class_2742.field_12557 ? direction : direction.method_10153();
    }

    public void method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        class_2338 blockPos;
        class_2680 blockState;
        class_2742 bedPart;
        if (!world.field_9236 && player.method_7337() && (bedPart = (class_2742)state.method_11654((class_2769)field_9967)) == class_2742.field_12557 && (blockState = world.method_8320(blockPos = pos.method_10093(AbstractComfortsBlock.getDirectionTowardsOtherPart(bedPart, (class_2350)state.method_11654((class_2769)field_11177))))).method_26204() == this && blockState.method_11654((class_2769)field_9967) == class_2742.field_12560) {
            if (((Boolean)blockState.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
                world.method_8652(blockPos, class_2246.field_10382.method_9564(), 35);
            } else {
                world.method_8652(blockPos, class_2246.field_10124.method_9564(), 35);
            }
            world.method_8444(player, 2001, blockPos, class_2248.method_9507((class_2680)blockState));
        }
        world.method_8444(player, 2001, pos, AbstractComfortsBlock.method_9507((class_2680)state));
        if (state.method_26164((class_3494)class_3481.field_23800)) {
            class_4838.method_24733((class_1657)player, (boolean)false);
        }
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 newState, class_1936 world, class_2338 pos, class_2338 posFrom) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
        }
        return super.method_9559(state, direction, newState, world, pos, posFrom);
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_3610 fluidState = ctx.method_8045().method_8316(ctx.method_8037());
        class_2680 state = super.method_9605(ctx);
        return state == null ? null : (class_2680)state.method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{WATERLOGGED});
        super.method_9515(builder);
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public Either<class_1657.class_1658, class_3902> trySleep(class_3222 player, class_2338 pos) {
        class_1657.class_1658 result = ((EntitySleepEvents.AllowSleeping)EntitySleepEvents.ALLOW_SLEEPING.invoker()).allowSleep((class_1657)player, pos);
        if (result != null) {
            return Either.left((Object)result);
        }
        class_2350 direction = (class_2350)player.field_6002.method_8320(pos).method_11654((class_2769)class_2383.field_11177);
        if (!player.method_6113() && player.method_5805()) {
            boolean canSleep;
            if (!player.field_6002.method_8597().method_28537()) {
                return Either.left((Object)class_1657.class_1658.field_7528);
            }
            if (!AbstractComfortsBlock.isBedTooFarAway(player, pos, direction)) {
                return Either.left((Object)class_1657.class_1658.field_7530);
            }
            if (AbstractComfortsBlock.isBedObstructed(player, pos, direction)) {
                return Either.left((Object)class_1657.class_1658.field_18592);
            }
            class_1269 sleep = ((EntitySleepEvents.AllowSleepTime)EntitySleepEvents.ALLOW_SLEEP_TIME.invoker()).allowSleepTime((class_1657)player, pos, !player.field_6002.method_8530());
            boolean bl = sleep == class_1269.field_5811 ? !player.field_6002.method_8530() : (canSleep = sleep.method_23665());
            if (!canSleep) {
                return Either.left((Object)class_1657.class_1658.field_7529);
            }
            if (!player.method_7337()) {
                double d = 8.0;
                double e = 5.0;
                class_243 vec3d = class_243.method_24955((class_2382)pos);
                List list = player.field_6002.method_8390(class_1588.class, new class_238(vec3d.method_10216() - d, vec3d.method_10214() - e, vec3d.method_10215() - d, vec3d.method_10216() + d, vec3d.method_10214() + e, vec3d.method_10215() + d), hostileEntity -> hostileEntity.method_7076((class_1657)player));
                if (!list.isEmpty()) {
                    return Either.left((Object)class_1657.class_1658.field_7532);
                }
            }
            player.method_18403(pos);
            ((AccessorPlayerEntity)player).setSleepTimer(0);
            player.method_7281(class_3468.field_15381);
            class_174.field_1212.method_9027(player);
            ((class_3218)player.field_6002).method_8448();
            return Either.right((Object)class_3902.field_17274);
        }
        return Either.left((Object)class_1657.class_1658.field_7531);
    }

    private boolean isFree(class_1937 world, class_2338 pos) {
        List list = world.method_8390(class_1646.class, new class_238(pos), class_1309::method_6113);
        if (list.isEmpty()) {
            return false;
        }
        ((class_1646)list.get(0)).method_18400();
        return true;
    }

    private static boolean isBedTooFarAway(class_3222 player, class_2338 pos, class_2350 direction) {
        return AbstractComfortsBlock.isBedTooFarAway(player, pos) || AbstractComfortsBlock.isBedTooFarAway(player, pos.method_10093(direction.method_10153()));
    }

    private static boolean isBedTooFarAway(class_3222 player, class_2338 pos) {
        class_243 vec3d = class_243.method_24955((class_2382)pos);
        return Math.abs(player.method_23317() - vec3d.method_10216()) <= 3.0 && Math.abs(player.method_23318() - vec3d.method_10214()) <= 2.0 && Math.abs(player.method_23321() - vec3d.method_10215()) <= 3.0;
    }

    private static boolean isBedObstructed(class_3222 player, class_2338 pos, class_2350 direction) {
        class_2338 blockPos = pos.method_10084();
        return AbstractComfortsBlock.suffocates(player, blockPos) || AbstractComfortsBlock.suffocates(player, blockPos.method_10093(direction.method_10153()));
    }

    protected static boolean suffocates(class_3222 player, class_2338 pos) {
        return player.field_6002.method_8320(pos).method_26228((class_1922)player.field_6002, pos);
    }

    public static enum BedType {
        HAMMOCK("hammock"),
        SLEEPING_BAG("sleeping_bag");

        private final String name;

        private BedType(String name) {
            this.name = name;
        }
    }
}

