/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonPrimitive;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.config.ConfigEntry;
import net.minecraft.class_2960;

public enum PluginConfig implements IPluginConfig
{
    INSTANCE;

    private static final Path PATH;
    private static final Gson GSON;
    private static final TypeToken<Map<String, Map<String, JsonPrimitive>>> TYPE_TOKEN;
    private final Map<class_2960, ConfigEntry<?>> configs = new LinkedHashMap();

    public void addConfig(ConfigEntry<?> entry) {
        this.configs.put(entry.getId(), entry);
    }

    @Override
    public Set<class_2960> getKeys(String namespace) {
        return this.getKeys().stream().filter(id -> id.method_12836().equals(namespace)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public Set<class_2960> getKeys() {
        return this.configs.keySet();
    }

    @Override
    public boolean getBoolean(class_2960 key) {
        return (Boolean)this.getValue(key);
    }

    @Override
    public int getInt(class_2960 key) {
        return (Integer)this.getValue(key);
    }

    @Override
    public double getDouble(class_2960 key) {
        return (Double)this.getValue(key);
    }

    @Override
    public String getString(class_2960 key) {
        return (String)this.getValue(key);
    }

    @Override
    public <T extends Enum<T>> T getEnum(class_2960 key) {
        return (T)((Enum)this.getValue(key));
    }

    @Override
    public boolean get(class_2960 key, boolean defaultValue) {
        ConfigEntry<?> entry = this.configs.get(key);
        return entry == null ? defaultValue : (Boolean)entry.getValue();
    }

    public Set<ConfigEntry<Object>> getSyncableConfigs() {
        return this.configs.values().stream().filter(ConfigEntry::isSynced).map(t -> t).collect(Collectors.toSet());
    }

    public List<String> getNamespaces() {
        return this.configs.keySet().stream().map(class_2960::method_12836).distinct().sorted((o1, o2) -> o1.equals("waila") ? -1 : (o2.equals("waila") ? 1 : o1.compareToIgnoreCase((String)o2))).collect(Collectors.toList());
    }

    public <T> ConfigEntry<T> getEntry(class_2960 key) {
        return this.configs.get(key);
    }

    public <T> void set(class_2960 key, T value) {
        ConfigEntry<?> entry = this.configs.get(key);
        if (entry != null) {
            entry.setValue(value);
        }
    }

    public void reload() {
        if (!Files.exists(PATH, new LinkOption[0])) {
            this.writeConfig(true);
        } else {
            Map config;
            try (BufferedReader reader = Files.newBufferedReader(PATH, StandardCharsets.UTF_8);){
                config = (Map)GSON.fromJson((Reader)reader, TYPE_TOKEN.getType());
            }
            catch (IOException e) {
                config = new HashMap<String, Map>();
            }
            if (config == null) {
                this.writeConfig(true);
            } else {
                config.forEach((namespace, subMap) -> subMap.forEach((path, value) -> {
                    ConfigEntry<?> entry = this.configs.get(new class_2960(namespace, path));
                    if (entry != null) {
                        entry.setValue(entry.getType().parseValue((JsonPrimitive)value, entry.getDefaultValue()));
                    }
                }));
            }
        }
        Waila.LOGGER.info("Plugin config reloaded");
    }

    public void save() {
        this.writeConfig(false);
    }

    private <T> T getValue(class_2960 key) {
        return (T)this.configs.get(key).getValue();
    }

    private void writeConfig(boolean reset) {
        LinkedHashMap<String, Map> config = new LinkedHashMap<String, Map>();
        Iterator<ConfigEntry<?>> iterator = this.configs.values().iterator();
        while (iterator.hasNext()) {
            Object value;
            ConfigEntry<?> e;
            ConfigEntry<?> entry = e = iterator.next();
            Map modConfig = config.computeIfAbsent(entry.getId().method_12836(), k -> new LinkedHashMap());
            if (reset) {
                entry.setValue(entry.getDefaultValue());
            }
            if ((value = entry.getValue()) instanceof Enum) {
                Enum enumValue = (Enum)value;
                modConfig.put(entry.getId().method_12832(), enumValue.name());
                continue;
            }
            modConfig.put(entry.getId().method_12832(), entry.getValue());
        }
        try {
            String json = GSON.toJson(config);
            Path parent = PATH.getParent();
            if (!Files.exists(parent, new LinkOption[0])) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            BufferedWriter writer = Files.newBufferedWriter(PATH, StandardCharsets.UTF_8, new OpenOption[0]);
            writer.write(json);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        PATH = Waila.CONFIG_DIR.resolve("waila/waila_plugins.json");
        GSON = new GsonBuilder().setPrettyPrinting().create();
        TYPE_TOKEN = new TypeToken<Map<String, Map<String, JsonPrimitive>>>(){};
    }
}

