/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.fabric;

import mcp.mobius.waila.Waila;
import mcp.mobius.waila.config.BlacklistConfig;
import mcp.mobius.waila.config.PluginConfig;
import mcp.mobius.waila.network.PacketExecutor;
import mcp.mobius.waila.network.PacketIo;
import mcp.mobius.waila.network.PacketSender;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class FabricPacketSender
extends PacketSender {
    static final class_2960 REQUEST_ENTITY = Waila.id("request_entity");
    static final class_2960 REQUEST_BLOCK = Waila.id("request_tile");
    static final class_2960 RECEIVE_DATA = Waila.id("receive_data");
    static final class_2960 SEND_CONFIG = Waila.id("send_config");
    static final class_2960 SEND_BLACKLIST = Waila.id("send_blacklist");
    static final class_2960 GENERATE_CLIENT_DUMP = Waila.id("generate_client_dump");

    @Override
    public void initMain() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)REQUEST_ENTITY, (server, player, handler, buf, response) -> PacketIo.RequestEntity.consume(buf, entityId -> server.execute(() -> PacketExecutor.requestEntity(player, entityId, tag -> response.sendPacket(RECEIVE_DATA, PacketIo.ReceiveData.create((class_2487)tag))))));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)REQUEST_BLOCK, (server, player, handler, buf, response) -> PacketIo.RequestBlock.consume(buf, pos -> server.execute(() -> PacketExecutor.requestBlockEntity(player, pos, tag -> response.sendPacket(RECEIVE_DATA, PacketIo.ReceiveData.create((class_2487)tag))))));
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void initClient() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)RECEIVE_DATA, (client, handler, buf, response) -> PacketIo.ReceiveData.consume(buf, tag -> client.execute(() -> PacketExecutor.receiveData(tag))));
        ClientPlayNetworking.registerGlobalReceiver((class_2960)SEND_CONFIG, (client, handler, buf, response) -> PacketIo.SendConfig.consume(buf, map -> client.execute(() -> PacketExecutor.sendConfig(map))));
        ClientPlayNetworking.registerGlobalReceiver((class_2960)SEND_BLACKLIST, (client, handler, buf, response) -> PacketIo.SendBlacklist.consume(buf, ids -> client.execute(() -> PacketExecutor.sendBlacklist(ids))));
        ClientPlayNetworking.registerGlobalReceiver((class_2960)GENERATE_CLIENT_DUMP, (client, handler, buf, response) -> PacketIo.GenerateClientDump.consume(buf, unused -> client.execute(PacketExecutor::generateClientDump)));
    }

    @Override
    public void sendPluginConfig(PluginConfig config, class_3222 player) {
        ServerPlayNetworking.send((class_3222)player, (class_2960)SEND_CONFIG, (class_2540)PacketIo.SendConfig.create(config));
    }

    @Override
    public void sendBlacklistConfig(BlacklistConfig config, class_3222 player) {
        ServerPlayNetworking.send((class_3222)player, (class_2960)SEND_BLACKLIST, (class_2540)PacketIo.SendBlacklist.create(config));
    }

    @Override
    public void generateClientDump(class_3222 player) {
        ServerPlayNetworking.send((class_3222)player, (class_2960)GENERATE_CLIENT_DUMP, (class_2540)PacketIo.GenerateClientDump.create(null));
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean isServerAvailable() {
        return ClientPlayNetworking.canSend((class_2960)REQUEST_ENTITY);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void requestEntity(class_1297 entity) {
        ClientPlayNetworking.send((class_2960)REQUEST_ENTITY, (class_2540)PacketIo.RequestEntity.create(entity));
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void requestBlock(class_2586 blockEntity) {
        ClientPlayNetworking.send((class_2960)REQUEST_BLOCK, (class_2540)PacketIo.RequestBlock.create(blockEntity));
    }
}

