/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.hud;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.text2speech.Narrator;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.awt.Rectangle;
import java.util.function.Supplier;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IEventListener;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.IWailaConfig;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.api.component.EmptyComponent;
import mcp.mobius.waila.api.component.PairComponent;
import mcp.mobius.waila.config.PluginConfig;
import mcp.mobius.waila.config.WailaConfig;
import mcp.mobius.waila.data.DataAccessor;
import mcp.mobius.waila.event.EventCanceller;
import mcp.mobius.waila.hud.Line;
import mcp.mobius.waila.hud.Tooltip;
import mcp.mobius.waila.registry.Registrar;
import mcp.mobius.waila.util.DisplayUtil;
import net.minecraft.class_1041;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3695;
import net.minecraft.class_408;
import net.minecraft.class_4587;

public class TooltipHandler {
    private static final Tooltip TOOLTIP = new Tooltip();
    private static final Object2IntOpenHashMap<Line> LINE_HEIGHT = new Object2IntOpenHashMap();
    private static final Supplier<Rectangle> RENDER_RECT = Suppliers.memoize(Rectangle::new);
    private static final Supplier<Rectangle> RECT = Suppliers.memoize(Rectangle::new);
    private static final Supplier<Narrator> NARRATOR = Suppliers.memoize(Narrator::getNarrator);
    static boolean shouldRender = false;
    private static String lastNarration = "";
    private static ITooltipComponent icon = EmptyComponent.INSTANCE;
    private static int topOffset;
    public static int colonOffset;
    public static int colonWidth;
    private static boolean started;

    public static void beginBuild() {
        TOOLTIP.clear();
        LINE_HEIGHT.clear();
        icon = EmptyComponent.INSTANCE;
        topOffset = 0;
        colonOffset = 0;
        colonWidth = class_310.method_1551().field_1772.method_1727(": ");
        started = true;
    }

    public static void add(Tooltip tooltip) {
        Preconditions.checkState((boolean)started);
        for (class_2561 component : tooltip) {
            if (component instanceof Line) {
                Line line = (Line)component;
                if (line.tag != null) {
                    TOOLTIP.setLine(line.tag, line);
                    continue;
                }
                TooltipHandler.add(line);
                continue;
            }
            TooltipHandler.add(new Line(null).with(component));
        }
    }

    public static void add(Line line) {
        Preconditions.checkState((boolean)started);
        TOOLTIP.add(line);
        for (ITooltipComponent component : line.components) {
            if (!(component instanceof PairComponent)) continue;
            PairComponent pair = (PairComponent)component;
            colonOffset = Math.max(pair.key.getWidth(), colonOffset);
            break;
        }
    }

    public static void setIcon(ITooltipComponent icon) {
        Preconditions.checkState((boolean)started);
        TooltipHandler.icon = PluginConfig.INSTANCE.getBoolean(WailaConstants.CONFIG_SHOW_ICON) ? icon : EmptyComponent.INSTANCE;
    }

    public static void endBuild() {
        Preconditions.checkState((boolean)started);
        for (IEventListener listener : Registrar.INSTANCE.eventListeners.get(Object.class)) {
            listener.onHandleTooltip(TOOLTIP, DataAccessor.INSTANCE, PluginConfig.INSTANCE);
        }
        TooltipHandler.narrateObjectName();
        class_310 client = class_310.method_1551();
        class_1041 window = client.method_22683();
        float scale = Waila.CONFIG.get().getOverlay().getScale();
        WailaConfig.Overlay.Position pos = Waila.CONFIG.get().getOverlay().getPosition();
        int w = 0;
        int h = 0;
        for (class_2561 component : TOOLTIP) {
            Line line = (Line)component;
            int lineW = line.getWidth();
            int lineH = line.getHeight();
            w = Math.max(w, lineW);
            h += lineH;
            LINE_HEIGHT.put((Object)line, lineH);
        }
        topOffset = 0;
        if (icon.getHeight() > h) {
            topOffset = class_3532.method_38788((int)(icon.getHeight() - h), (int)2);
        }
        if (icon.getWidth() > 0) {
            w += icon.getWidth() + 3;
        }
        w += 6;
        h = Math.max(h, icon.getHeight()) + TOOLTIP.size() - 1 + 6;
        int windowW = (int)((float)window.method_4486() / scale);
        int windowH = (int)((float)window.method_4502() / scale);
        IWailaConfig.Overlay.Position.Align.X anchorX = pos.getAnchor().getX();
        IWailaConfig.Overlay.Position.Align.Y anchorY = pos.getAnchor().getY();
        IWailaConfig.Overlay.Position.Align.X alignX = pos.getAlign().getX();
        IWailaConfig.Overlay.Position.Align.Y alignY = pos.getAlign().getY();
        double x = (double)windowW * anchorX.multiplier - (double)w * alignX.multiplier + (double)pos.getX();
        double y = (double)windowH * anchorY.multiplier - (double)h * alignY.multiplier + (double)pos.getY();
        if (!pos.isBossBarsOverlap() && anchorX == IWailaConfig.Overlay.Position.Align.X.CENTER && anchorY == IWailaConfig.Overlay.Position.Align.Y.TOP) {
            y += (double)Math.min(client.field_1705.method_1740().field_2060.size() * 19, window.method_4502() / 3 + 2);
        }
        RECT.get().setRect(x, y, w, h);
        started = false;
    }

    public static void render(class_4587 matrices, float delta) {
        if (!shouldRender) {
            return;
        }
        class_310 client = class_310.method_1551();
        class_3695 profiler = client.method_16011();
        WailaConfig config = Waila.CONFIG.get();
        profiler.method_15396("Waila Overlay");
        float scale = config.getOverlay().getScale();
        RenderSystem.getModelViewStack().method_22903();
        RenderSystem.getModelViewStack().method_22905(scale, scale, 1.0f);
        RenderSystem.applyModelViewMatrix();
        matrices.method_22903();
        DisplayUtil.enable2DRender();
        Rectangle rect = RENDER_RECT.get();
        rect.setRect(RECT.get());
        EventCanceller canceller = EventCanceller.INSTANCE;
        canceller.setCanceled(false);
        for (IEventListener listener : Registrar.INSTANCE.eventListeners.get(Object.class)) {
            listener.onBeforeTooltipRender(matrices, rect, DataAccessor.INSTANCE, PluginConfig.INSTANCE, canceller);
            if (!canceller.isCanceled()) continue;
            matrices.method_22909();
            RenderSystem.enableDepthTest();
            RenderSystem.getModelViewStack().method_22909();
            RenderSystem.applyModelViewMatrix();
            profiler.method_15407();
            return;
        }
        int x = rect.x;
        int y = rect.y;
        int w = rect.width;
        int h = rect.height;
        WailaConfig.Overlay.Color color = config.getOverlay().getColor();
        int bg = color.getBackgroundColor();
        int gradStart = color.getGradientStart();
        int gradEnd = color.getGradientEnd();
        DisplayUtil.drawGradientRect(matrices, x + 1, y, w - 1, 1, bg, bg);
        DisplayUtil.drawGradientRect(matrices, x + 1, y + h, w - 1, 1, bg, bg);
        DisplayUtil.drawGradientRect(matrices, x + 1, y + 1, w - 1, h - 1, bg, bg);
        DisplayUtil.drawGradientRect(matrices, x, y + 1, 1, h - 1, bg, bg);
        DisplayUtil.drawGradientRect(matrices, x + w, y + 1, 1, h - 1, bg, bg);
        DisplayUtil.drawGradientRect(matrices, x + 1, y + 2, 1, h - 3, gradStart, gradEnd);
        DisplayUtil.drawGradientRect(matrices, x + w - 1, y + 2, 1, h - 3, gradStart, gradEnd);
        DisplayUtil.drawGradientRect(matrices, x + 1, y + 1, w - 1, 1, gradStart, gradStart);
        DisplayUtil.drawGradientRect(matrices, x + 1, y + h - 1, w - 1, 1, gradEnd, gradEnd);
        RenderSystem.enableBlend();
        int textX = x + (icon.getWidth() > 0 ? icon.getWidth() + 7 : 4);
        int textY = y + 4 + topOffset;
        for (class_2561 component : TOOLTIP) {
            Line line = (Line)component;
            line.render(matrices, textX, textY, delta);
            textY += LINE_HEIGHT.getInt((Object)line) + 1;
        }
        RenderSystem.disableBlend();
        matrices.method_22909();
        for (IEventListener listener : Registrar.INSTANCE.eventListeners.get(Object.class)) {
            listener.onAfterTooltipRender(matrices, rect, DataAccessor.INSTANCE, PluginConfig.INSTANCE);
        }
        icon.render(matrices, x + 4, y + class_3532.method_38788((int)(h - icon.getHeight()), (int)2), delta);
        RenderSystem.enableDepthTest();
        RenderSystem.getModelViewStack().method_22909();
        RenderSystem.applyModelViewMatrix();
        profiler.method_15407();
    }

    private static void narrateObjectName() {
        String narrate;
        if (!shouldRender) {
            return;
        }
        Narrator narrator = NARRATOR.get();
        if (narrator.active() || !Waila.CONFIG.get().getGeneral().isEnableTextToSpeech() || class_310.method_1551().field_1755 instanceof class_408) {
            return;
        }
        class_2561 objectName = TOOLTIP.getTag(WailaConstants.OBJECT_NAME_TAG);
        if (objectName != null && !lastNarration.equalsIgnoreCase(narrate = objectName.getString())) {
            narrator.clear();
            narrator.say(narrate, true);
            lastNarration = narrate;
        }
    }

    static {
        started = false;
    }
}

