/*
 * Decompiled with CFR 0.152.
 */
package com.github.klyser8.earthbounds.entity;

import com.github.klyser8.earthbounds.entity.CoalChunkEntity;
import com.github.klyser8.earthbounds.entity.Conductive;
import com.github.klyser8.earthbounds.entity.EarthboundEntityGroup;
import com.github.klyser8.earthbounds.entity.Earthen;
import com.github.klyser8.earthbounds.entity.goal.EscapeAttackerGoal;
import com.github.klyser8.earthbounds.registry.EarthboundEntities;
import com.github.klyser8.earthbounds.registry.EarthboundItems;
import com.github.klyser8.earthbounds.registry.EarthboundParticles;
import com.github.klyser8.earthbounds.registry.EarthboundSounds;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1314;
import net.minecraft.class_1341;
import net.minecraft.class_1352;
import net.minecraft.class_1353;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1379;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2404;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3494;
import net.minecraft.class_3611;
import net.minecraft.class_3726;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5328;
import net.minecraft.class_5532;
import net.minecraft.class_5761;
import net.minecraft.class_7;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class CarboraneaEntity
extends class_1429
implements Earthen,
Conductive,
class_5761 {
    private static final class_1856 BREEDING_INGREDIENT = class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8183});
    private final int maxCoals;
    private static final class_2940<Integer> LAST_DAMAGER_ID = class_2945.method_12791(CarboraneaEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Float> HEAT = class_2945.method_12791(CarboraneaEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Boolean> FROM_BUCKET = class_2945.method_12791(CarboraneaEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> SHOULD_MATE_SITTING = class_2945.method_12791(CarboraneaEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> COAL_AMOUNT = class_2945.method_12791(CarboraneaEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> ANIMATION_SHAKE_TIME = class_2945.method_12791(CarboraneaEntity.class, (class_2941)class_2943.field_13327);
    private final List<CoalChunkEntity> coals;
    private AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public CarboraneaEntity(class_1299<? extends class_1429> entityType, class_1937 world) {
        super(entityType, world);
        this.coals = new ArrayList<CoalChunkEntity>();
        this.method_5941(class_7.field_18, -1.0f);
        this.method_5941(class_7.field_14, 0.0f);
        this.method_5941(class_7.field_9, 0.0f);
        this.method_5941(class_7.field_3, 0.0f);
        this.maxCoals = this.field_5974.nextBoolean() ? 3 : (this.field_5974.nextBoolean() ? 6 : 9);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new EscapeAttackerGoal((class_1314)this, 1.5));
        this.field_6201.method_6277(1, (class_1352)new CarboraneaMateGoal(this, 1.0));
        this.field_6201.method_6277(2, (class_1352)new class_1353((class_1429)this, 1.0));
        this.field_6201.method_6277(3, (class_1352)new MoveToHeatSourceGoal(50));
        this.field_6201.method_6277(4, (class_1352)new ExcreteCoalsGoal());
        this.field_6201.method_6277(5, (class_1352)new FollowTargetGoal(1.0, 5.0f, 20.0f));
        this.field_6201.method_6277(6, (class_1352)new CarboraneaWanderAroundGoal((class_1314)this, 1.0, 120));
        this.field_6201.method_6277(7, (class_1352)new class_1361((class_1308)this, CarboraneaEntity.class, 5.0f, 0.5f));
        this.field_6201.method_6277(8, (class_1352)new class_1361((class_1308)this, class_1657.class, 5.0f, 0.5f));
        this.field_6201.method_6277(9, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(0, (class_1352)new class_1399((class_1314)this, new Class[]{Earthen.class}));
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_1657.class, false, false));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1429.class, false, false));
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(LAST_DAMAGER_ID, (Object)this.method_5628());
        this.field_6011.method_12784(HEAT, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(FROM_BUCKET, (Object)false);
        this.field_6011.method_12784(SHOULD_MATE_SITTING, (Object)false);
        this.field_6011.method_12784(COAL_AMOUNT, (Object)0);
        this.field_6011.method_12784(ANIMATION_SHAKE_TIME, (Object)0);
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "default", 10.0f, this::defaultPredicate));
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "shaking", 0.0f, this::shakingPredicate));
    }

    private <E extends IAnimatable> PlayState defaultPredicate(AnimationEvent<E> event) {
        if (this.field_6012 < 40) {
            event.getController().transitionLengthTicks = 0.0;
            event.getController().setAnimation(new AnimationBuilder().addAnimation("spawn", Boolean.valueOf(false)));
            return PlayState.CONTINUE;
        }
        if (this.field_6213 > 0) {
            event.getController().transitionLengthTicks = 0.0;
            event.getController().setAnimation(new AnimationBuilder().addAnimation("death", Boolean.valueOf(false)));
            return PlayState.CONTINUE;
        }
        if (((Boolean)this.field_6011.method_12789(SHOULD_MATE_SITTING)).booleanValue()) {
            event.getController().transitionLengthTicks = 10.0;
            event.getController().setAnimation(new AnimationBuilder().addAnimation("breed", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        if (this.method_5771() && event.isMoving()) {
            event.getController().transitionLengthTicks = 0.0;
            event.getController().setAnimation(new AnimationBuilder().addAnimation("swim", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        if (this.method_5771()) {
            event.getController().transitionLengthTicks = 20.0;
            event.getController().setAnimation(new AnimationBuilder().addAnimation("float", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        if (event.isMoving()) {
            event.getController().transitionLengthTicks = 0.0;
            event.getController().setAnimation(new AnimationBuilder().addAnimation("walk", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        if ((double)this.getCurrentHeat() < 200.0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("wave", Boolean.valueOf(false)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("bounce", Boolean.valueOf(false)));
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState shakingPredicate(AnimationEvent<E> event) {
        if ((Integer)this.field_6011.method_12789(ANIMATION_SHAKE_TIME) > 0) {
            this.field_6011.method_12778(ANIMATION_SHAKE_TIME, (Object)((Integer)this.field_6011.method_12789(ANIMATION_SHAKE_TIME) - 1));
            event.getController().setAnimation(new AnimationBuilder().addAnimation("shake", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        return (class_1296)EarthboundEntities.CARBORANEA.method_5883((class_1937)world);
    }

    public void method_5773() {
        super.method_5773();
        int period = 10;
        float heatChange = 0.0f;
        if (this.field_6012 % period == 0) {
            heatChange = this.updateHeat(period);
        }
        if (this.field_6012 < 40) {
            this.method_6125(0.0f);
        } else if (this.field_6012 == 41) {
            this.method_6125((float)this.method_26826(class_5134.field_23719));
        }
        this.coals.removeIf(class_1297::method_31481);
        this.field_6011.method_12778(COAL_AMOUNT, (Object)this.coals.size());
        if (this.field_6002.field_9236) {
            this.playParticles(heatChange);
        }
        this.updateFloating();
    }

    public boolean method_6481(class_1799 stack) {
        return BREEDING_INGREDIENT.method_8093(stack);
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    @Override
    public float updateHeat(int period) {
        if (this.method_6109()) {
            return 0.0f;
        }
        float currentHeat = ((Float)this.field_6011.method_12789(HEAT)).floatValue();
        float heatChange = Conductive.calculateHeatChangePerPeriod(this.field_6002, this.method_33571(), false);
        if ((currentHeat += heatChange) > 400.0f) {
            currentHeat = 400.0f;
        } else if (currentHeat < 0.0f) {
            currentHeat = 0.0f;
        }
        this.field_6011.method_12778(HEAT, (Object)Float.valueOf(currentHeat));
        return heatChange;
    }

    public void method_24650(class_3218 world, class_1429 other) {
        super.method_24650(world, other);
        this.method_5614(72000);
        other.method_5614(72000);
        this.field_6011.method_12778(ANIMATION_SHAKE_TIME, (Object)20);
        if (!world.field_9236) {
            world.method_8396(null, this.method_24515(), EarthboundSounds.CARBORANEA_SHAKE_SHORT, class_3419.field_15245, 1.0f, 1.0f);
        }
        ((CarboraneaEntity)other).field_6011.method_12778(ANIMATION_SHAKE_TIME, (Object)20);
    }

    public class_4048 method_18377(class_4050 pose) {
        float height = super.method_18377((class_4050)pose).field_18068;
        float width = super.method_18377((class_4050)pose).field_18067;
        return this.method_6109() ? class_4048.method_18384((float)(height / 2.0f), (float)(width / 2.0f)) : super.method_18377(pose);
    }

    @Override
    public float getCurrentHeat() {
        return ((Float)this.field_6011.method_12789(HEAT)).floatValue();
    }

    @Override
    public void setCurrentHeat(float heat) {
        this.field_6011.method_12778(HEAT, (Object)Float.valueOf(heat));
    }

    public boolean method_5753() {
        return true;
    }

    public boolean method_26319(class_3611 fluid) {
        return fluid.method_15791((class_3494)class_3486.field_15518);
    }

    public boolean method_5931(class_1657 player) {
        return false;
    }

    @Nullable
    protected class_3414 method_6011(class_1282 source) {
        return EarthboundSounds.CARBORANEA_HURT;
    }

    @Nullable
    protected class_3414 method_6002() {
        return EarthboundSounds.CARBORANEA_DEATH;
    }

    @Nullable
    protected class_3414 method_5994() {
        return this.method_6109() ? null : EarthboundSounds.CARBORANEA_AMBIENT;
    }

    public class_1310 method_6046() {
        return EarthboundEntityGroup.EARTHEN;
    }

    public void method_5966() {
        float pitch = 1.0f - this.getCurrentHeat() / 2000.0f;
        class_3414 soundEvent = this.method_5994();
        if (soundEvent != null) {
            this.method_5783(soundEvent, this.method_6107(), pitch);
        }
    }

    public int method_5970() {
        return 100;
    }

    public void method_5783(class_3414 sound, float volume, float pitch) {
        if (!sound.equals(EarthboundSounds.CARBORANEA_SHAKE_SHORT) && !sound.equals(EarthboundSounds.CARBORANEA_SHAKE)) {
            super.method_5783(sound, volume, pitch -= this.getCurrentHeat() / 2000.0f);
        }
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (this.getLastDamager() != null && source.method_5526() != null && !this.getLastDamager().equals((Object)source.method_5526())) {
            this.setLastDamager(source.method_5526());
        }
        if (!Earthen.isDamagePickaxe(source)) {
            amount = Earthen.handleNonPickaxeDamage(source, (class_1309)this, amount);
        }
        return super.method_5643(source, amount);
    }

    public boolean method_6453() {
        return (Boolean)this.field_6011.method_12789(FROM_BUCKET);
    }

    public void method_6454(boolean fromBucket) {
        this.field_6011.method_12778(FROM_BUCKET, (Object)fromBucket);
    }

    public class_1269 method_5664(class_1657 player, class_243 hitPos, class_1268 hand) {
        if (player.method_5998(hand).method_31574(class_1802.field_8187)) {
            return this.tryBucket(player, hand, this).orElse(super.method_5664(player, hitPos, hand));
        }
        return super.method_5664(player, hitPos, hand);
    }

    public void method_6455(class_1799 stack) {
    }

    public void method_35170(class_2487 nbt) {
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556("FromBucket", this.method_6453());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.method_6454(nbt.method_10577("FromBucket"));
    }

    public class_1799 method_6452() {
        return new class_1799((class_1935)EarthboundItems.CARBORANEA_BUCKET);
    }

    public class_3414 method_35171() {
        return EarthboundSounds.CARBORANEA_BUCKET_FILL;
    }

    private void playParticles(float heatChange) {
        if (this.field_5974.nextFloat() < 0.1f && heatChange > 0.0f) {
            this.field_6002.method_8406((class_2394)class_2398.field_11240, this.method_23317() + this.field_5974.nextDouble() / 5.0 - 0.1, this.method_23319(), this.method_23321() + this.field_5974.nextDouble() / 5.0 - 0.1, 0.0, 0.0, 0.0);
        }
        if (this.field_5974.nextFloat() < 0.2f && heatChange < 0.0f && this.getCurrentHeat() > 40.0f) {
            this.field_6002.method_8406((class_2394)EarthboundParticles.SCORCH_ASH, this.method_23317() + this.field_5974.nextDouble() / 5.0 - 0.1, this.method_23319(), this.method_23321() + this.field_5974.nextDouble() / 5.0 - 0.1, -0.05 + this.field_5974.nextDouble() / 10.0, 0.01, -0.05 + this.field_5974.nextDouble() / 10.0);
        }
    }

    private void updateFloating() {
        if (this.method_5771()) {
            class_3726 shapeContext = class_3726.method_16195((class_1297)this);
            if (!shapeContext.method_16192(class_2404.field_24412, this.method_24515(), true) || this.field_6002.method_8316(this.method_24515().method_10084()).method_15767((class_3494)class_3486.field_15518)) {
                this.method_18799(this.method_18798().method_1021(0.5).method_1031(0.0, 0.05, 0.0));
            } else {
                this.field_5952 = true;
            }
        }
    }

    public Optional<class_1269> tryBucket(class_1657 player, class_1268 hand, CarboraneaEntity carboranea) {
        class_1799 itemStack = player.method_5998(hand);
        if (itemStack.method_7909() == class_1802.field_8187 && carboranea.method_5805()) {
            class_1799 itemStack2 = carboranea.method_6452();
            carboranea.method_6455(itemStack2);
            class_1799 itemStack3 = class_5328.method_30270((class_1799)itemStack, (class_1657)player, (class_1799)itemStack2, (boolean)false);
            player.method_6122(hand, itemStack3);
            class_1937 world = carboranea.field_6002;
            if (!world.field_9236) {
                world.method_8396(null, carboranea.method_24515(), carboranea.method_35171(), class_3419.field_15254, 1.0f, 1.0f);
                class_174.field_1208.method_8932((class_3222)player, itemStack2);
            }
            carboranea.method_31472();
            return Optional.of(class_1269.method_29236((boolean)world.field_9236));
        }
        return Optional.empty();
    }

    @Override
    public class_1297 getLastDamager() {
        return this.field_6002.method_8469(((Integer)this.field_6011.method_12789(LAST_DAMAGER_ID)).intValue());
    }

    @Override
    public void setLastDamager(class_1297 entity) {
        this.field_6011.method_12778(LAST_DAMAGER_ID, (Object)entity.method_5628());
    }

    public static class_5132.class_5133 createAttributes() {
        return CarboraneaEntity.method_26828().method_26868(class_5134.field_23721, 1.0).method_26868(class_5134.field_23719, 0.25).method_26868(class_5134.field_23717, 48.0).method_26868(class_5134.field_23724, 5.0).method_26868(class_5134.field_23716, 10.0).method_26868(class_5134.field_23718, 0.25);
    }

    class CarboraneaMateGoal
    extends class_1341 {
        protected CarboraneaEntity sittingMate;

        public CarboraneaMateGoal(CarboraneaEntity carboranea, double chance) {
            super((class_1429)carboranea, chance);
            this.sittingMate = null;
        }

        public boolean method_6264() {
            return super.method_6264() && (double)CarboraneaEntity.this.getCurrentHeat() > 280.0;
        }

        public void method_6269() {
            super.method_6269();
            this.sittingMate = (CarboraneaEntity)(CarboraneaEntity.this.field_5974.nextBoolean() ? this.field_6404 : this.field_6406);
        }

        public void method_6268() {
            super.method_6268();
            if (CarboraneaEntity.this.method_5858((class_1297)this.field_6406) < 3.0 && !((Boolean)this.sittingMate.field_6011.method_12789(SHOULD_MATE_SITTING)).booleanValue()) {
                CarboraneaEntity.this.field_6011.method_12778(SHOULD_MATE_SITTING, (Object)true);
            }
        }

        public void method_6270() {
            super.method_6270();
            CarboraneaEntity.this.field_6011.method_12778(SHOULD_MATE_SITTING, (Object)false);
            this.sittingMate.field_6011.method_12778(SHOULD_MATE_SITTING, (Object)false);
            this.sittingMate = null;
        }
    }

    class MoveToHeatSourceGoal
    extends class_1352 {
        private double targetX = 0.0;
        private double targetY = 0.0;
        private double targetZ = 0.0;
        private final int attempts;

        public MoveToHeatSourceGoal(int attempts) {
            this.attempts = attempts;
        }

        public boolean method_6264() {
            if (CarboraneaEntity.this.method_6051().nextInt(120) != 0 || CarboraneaEntity.this.method_6109() || (double)CarboraneaEntity.this.getCurrentHeat() > 300.0 || Conductive.calculateHeatChangePerPeriod(CarboraneaEntity.this.field_6002, CarboraneaEntity.this.method_33571(), true) > 2.0f || CarboraneaEntity.this.method_5942().method_23966()) {
                return false;
            }
            boolean heatSourceFound = false;
            for (int i = 0; i < this.attempts; ++i) {
                if (!this.searchHeatSource()) continue;
                heatSourceFound = true;
                break;
            }
            return heatSourceFound;
        }

        public boolean method_6266() {
            return !CarboraneaEntity.this.method_5942().method_6357();
        }

        public void method_6269() {
            CarboraneaEntity.this.method_5942().method_6337(this.targetX, this.targetY, this.targetZ, 1.25);
        }

        protected boolean searchHeatSource() {
            class_243 vec3d = this.selectRandomConductingBlock();
            if (vec3d == null) {
                return false;
            }
            this.targetX = vec3d.field_1352;
            this.targetY = vec3d.field_1351;
            this.targetZ = vec3d.field_1350;
            return true;
        }

        private class_243 selectRandomConductingBlock() {
            class_2338 blockPos = CarboraneaEntity.this.method_24515().method_10069(CarboraneaEntity.this.field_5974.nextInt(40) - 20, CarboraneaEntity.this.field_5974.nextInt(20) - 10, CarboraneaEntity.this.field_5974.nextInt(40) - 20);
            return Conductive.calculateHeatChangePerPeriod(CarboraneaEntity.this.field_6002, class_243.method_24955((class_2382)blockPos), true) > Conductive.calculateHeatChangePerPeriod(CarboraneaEntity.this.field_6002, CarboraneaEntity.this.method_33571(), true) ? class_243.method_24955((class_2382)blockPos) : null;
        }
    }

    class ExcreteCoalsGoal
    extends class_1352 {
        private int cooldown = -1;

        public boolean method_6264() {
            return !CarboraneaEntity.this.method_5771() && (double)CarboraneaEntity.this.getCurrentHeat() > 300.0 && CarboraneaEntity.this.coals.size() + 1 < CarboraneaEntity.this.maxCoals && !CarboraneaEntity.this.method_6479();
        }

        public void method_6269() {
            super.method_6269();
        }

        public void method_6268() {
            super.method_6268();
            if (this.cooldown == -1 && !CarboraneaEntity.this.field_6002.field_9236) {
                CarboraneaEntity.this.field_6002.method_8396(null, CarboraneaEntity.this.method_24515(), EarthboundSounds.CARBORANEA_SHAKE, class_3419.field_15245, 1.0f, 1.0f);
            }
            --this.cooldown;
            if (this.cooldown > 0) {
                return;
            }
            this.excreteCoalChunk(new class_243(-0.1 + CarboraneaEntity.this.field_5974.nextDouble() / 5.0, CarboraneaEntity.this.field_5974.nextDouble() / 4.0, -0.1 + CarboraneaEntity.this.field_5974.nextDouble() / 5.0));
            this.cooldown = 3;
            CarboraneaEntity.this.setCurrentHeat((float)((double)CarboraneaEntity.this.getCurrentHeat() - 75.0));
        }

        public boolean method_6266() {
            return !CarboraneaEntity.this.method_5771() && (double)CarboraneaEntity.this.getCurrentHeat() > 120.0 && CarboraneaEntity.this.coals.size() < CarboraneaEntity.this.maxCoals && !CarboraneaEntity.this.method_6479();
        }

        public void method_6270() {
            super.method_6270();
            this.cooldown = -1;
        }

        private void excreteCoalChunk(class_243 velocity) {
            CoalChunkEntity coal = (CoalChunkEntity)EarthboundEntities.COAL_CHUNK.method_5883(CarboraneaEntity.this.field_6002);
            if (coal == null) {
                return;
            }
            coal.method_23327(CarboraneaEntity.this.method_23317() + (double)(CarboraneaEntity.this.field_5974.nextFloat() / 2.0f), CarboraneaEntity.this.method_23318() + 0.25, CarboraneaEntity.this.method_23321() + (double)(CarboraneaEntity.this.field_5974.nextFloat() / 2.0f));
            CarboraneaEntity.this.field_6002.method_8649((class_1297)coal);
            coal.method_18799(velocity);
            CarboraneaEntity.this.coals.add(coal);
            CarboraneaEntity.this.method_5783(class_3417.field_15219, 1.0f, 1.6f + CarboraneaEntity.this.field_5974.nextFloat() / 2.5f);
            CarboraneaEntity.this.field_6011.method_12778(ANIMATION_SHAKE_TIME, (Object)((Integer)CarboraneaEntity.this.field_6011.method_12789(ANIMATION_SHAKE_TIME) + 5));
        }
    }

    class FollowTargetGoal
    extends class_1352 {
        private final Random random = new Random();
        private class_1309 followed;
        private final double speed;
        private int updateCountdownTicks;
        private final float maxDistance;
        private final float minDistance;
        private float oldWaterPathfindingPenalty;

        public FollowTargetGoal(double speed, float minDistance, float maxDistance) {
            this.speed = speed;
            this.minDistance = minDistance;
            this.maxDistance = maxDistance;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            if (CarboraneaEntity.this.method_5968() == null) {
                return false;
            }
            float chance = CarboraneaEntity.this.getCurrentHeat() / 400.0f * 100.0f;
            if (this.random.nextFloat() < chance) {
                return false;
            }
            if (CarboraneaEntity.this.method_5942().method_23966()) {
                return false;
            }
            if (CarboraneaEntity.this.method_5968() == null) {
                return false;
            }
            if (CarboraneaEntity.this.method_5968().method_7325()) {
                return false;
            }
            if (CarboraneaEntity.this.method_5858((class_1297)CarboraneaEntity.this.method_5968()) < (double)(this.minDistance * this.minDistance) || CarboraneaEntity.this.method_5858((class_1297)CarboraneaEntity.this.method_5968()) > (double)(this.maxDistance * this.maxDistance)) {
                return false;
            }
            this.followed = CarboraneaEntity.this.method_5968();
            return true;
        }

        public boolean method_6266() {
            if (CarboraneaEntity.this.field_6189.method_6357() || CarboraneaEntity.this.method_5968() == null) {
                return false;
            }
            return CarboraneaEntity.this.method_5858((class_1297)this.followed) > (double)(this.minDistance * this.minDistance);
        }

        public void method_6269() {
            this.updateCountdownTicks = 0;
            this.oldWaterPathfindingPenalty = CarboraneaEntity.this.method_5944(class_7.field_18);
            CarboraneaEntity.this.method_5941(class_7.field_18, CarboraneaEntity.this.method_5944(class_7.field_18));
        }

        public void method_6270() {
            this.followed = null;
            CarboraneaEntity.this.field_6189.method_6340();
            CarboraneaEntity.this.method_5941(class_7.field_18, this.oldWaterPathfindingPenalty);
        }

        public void method_6268() {
            CarboraneaEntity.this.method_5988().method_6226((class_1297)this.followed, 10.0f, (float)CarboraneaEntity.this.method_5978());
            if (--this.updateCountdownTicks <= 0) {
                this.updateCountdownTicks = 10;
                CarboraneaEntity.this.field_6189.method_6335((class_1297)this.followed, this.speed);
            }
        }
    }

    class CarboraneaWanderAroundGoal
    extends class_1379 {
        public CarboraneaWanderAroundGoal(class_1314 mob, double speed, int chance) {
            super(mob, speed, chance);
        }

        public boolean method_6264() {
            return super.method_6264();
        }

        public void method_6270() {
            super.method_6270();
        }

        protected class_243 method_6302() {
            return class_5532.method_31510((class_1314)CarboraneaEntity.this, (int)((int)(6.0f - CarboraneaEntity.this.getCurrentHeat() / 100.0f)), (int)((int)(6.0f - CarboraneaEntity.this.getCurrentHeat() / 100.0f)));
        }
    }
}

