/*
 * Decompiled with CFR 0.152.
 */
package com.github.klyser8.earthbounds.entity;

import com.github.klyser8.earthbounds.Earthbounds;
import com.github.klyser8.earthbounds.client.sound.RubroActiveSoundInstance;
import com.github.klyser8.earthbounds.entity.EarthboundEntityGroup;
import com.github.klyser8.earthbounds.entity.Earthen;
import com.github.klyser8.earthbounds.entity.goal.EscapeAttackerGoal;
import com.github.klyser8.earthbounds.entity.goal.EscapeTargetGoal;
import com.github.klyser8.earthbounds.event.PlayerBlockBreakEventHandler;
import com.github.klyser8.earthbounds.registry.EarthboundBlocks;
import com.github.klyser8.earthbounds.registry.EarthboundEntities;
import com.github.klyser8.earthbounds.registry.EarthboundParticles;
import com.github.klyser8.earthbounds.registry.EarthboundSounds;
import com.github.klyser8.earthbounds.util.AdvancedBlockPos;
import com.github.klyser8.earthbounds.util.EarthMath;
import com.github.klyser8.earthbounds.util.EarthUtil;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1285;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1542;
import net.minecraft.class_1640;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1928;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2449;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2610;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_7;
import org.apache.logging.log4j.Level;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class RubroEntity
extends class_1314
implements Earthen {
    public static final int POWER_LIMIT = 200;
    private static final int TAIL_SPIN_ANIMATION_DURATION = 36;
    private static final UUID POWER_DAMAGE_BOOST_ID = UUID.fromString("e09618ac-395e-47b7-b6a1-b47aa59c92b9");
    private static final UUID POWER_SPEED_BOOST_ID = UUID.fromString("8391a50c-b8d5-44ee-bf77-84e519dbf5b2");
    private static final UUID POWER_FOLLOW_RANGE_ID = UUID.fromString("e31be277-eefe-4a00-b333-5ff68773f0a3");
    private final AnimationFactory factory;
    private static final class_2940<Integer> LAST_DAMAGER_ID = class_2945.method_12791(RubroEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> MAX_POWER = class_2945.method_12791(RubroEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> HAS_GOLD_SKULL = class_2945.method_12791(RubroEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> FROM_FOSSIL = class_2945.method_12791(RubroEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> DEEPSLATE = class_2945.method_12791(RubroEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> POWER = class_2945.method_12791(RubroEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> IS_FULLY_CHARGED = class_2945.method_12791(RubroEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<class_1799> CURRENT_ORE = class_2945.method_12791(RubroEntity.class, (class_2941)class_2943.field_13322);
    private static final class_2940<class_2338> BLOCK_TARGET_POS = class_2945.method_12791(RubroEntity.class, (class_2941)class_2943.field_13324);
    private static final class_2940<Integer> CURRENT_ENTITY_STATE = class_2945.method_12791(RubroEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> STANDING = class_2945.method_12791(RubroEntity.class, (class_2941)class_2943.field_13323);
    private static final int STATE_NONE = 0;
    private static final int STATE_DIGGING = 1;
    private static final int STATE_POUNCING = 2;
    private static final int STATE_SPINNING = 3;
    private boolean collides = true;
    private final Map<class_2338, Integer> ignoredBlocks = new HashMap<class_2338, Integer>();

    public RubroEntity(class_1299<? extends class_1314> entityType, class_1937 world) {
        super(entityType, world);
        this.factory = new AnimationFactory((IAnimatable)this);
        this.method_5941(class_7.field_18, -1.0f);
        this.method_5941(class_7.field_14, -1.0f);
        this.method_5941(class_7.field_9, 0.0f);
        this.method_5941(class_7.field_3, 0.0f);
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityNbt) {
        if (this.method_23318() < 0.0) {
            this.setDeepslate(true);
        }
        if (this.isDeepslate()) {
            this.createDeepslateAttributes();
        }
        return super.method_5943(world, difficulty, spawnReason, entityData, entityNbt);
    }

    public void initializeFossil(boolean deepslate, boolean fromFossil, boolean goldSkull, int startPower) {
        this.setFromFossil(fromFossil);
        this.setGoldSkull(goldSkull);
        this.updatePower(startPower);
        this.setDeepslate(deepslate);
        if (this.isDeepslate()) {
            this.createDeepslateAttributes();
        }
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new MoveToRedstoneGoal(60));
        this.field_6201.method_6277(1, (class_1352)new RubroAttackGoal());
        this.field_6201.method_6277(2, (class_1352)new RubroEscapeTargetGoal());
        this.field_6201.method_6277(3, (class_1352)new EscapeAttackerGoal(this, 1.2f));
        this.field_6201.method_6277(4, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(5, (class_1352)new class_1361((class_1308)this, class_1657.class, 10.0f));
        this.field_6201.method_6277(6, (class_1352)new class_1376((class_1308)this){

            public boolean method_6264() {
                return super.method_6264() && RubroEntity.this.getEntityState() == 0;
            }
        });
        this.field_6185.method_6277(0, (class_1352)new class_1399((class_1314)this, new Class[]{RubroEntity.class}));
        this.field_6185.method_6277(1, (class_1352)new RedstoneTargetGoal());
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1640.class, false, true));
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1309.method_26827().method_26868(class_5134.field_23721, 3.0).method_26868(class_5134.field_23719, 0.25).method_26868(class_5134.field_23717, 20.0).method_26867(class_5134.field_23722).method_26868(class_5134.field_23724, 10.0).method_26868(class_5134.field_23725, 0.0).method_26868(class_5134.field_23716, 20.0).method_26868(class_5134.field_23718, 0.35);
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (nbt.method_10545("Deepslate")) {
            this.setDeepslate(nbt.method_10577("Deepslate"));
        }
        if (nbt.method_10545("FromFossil")) {
            this.setFromFossil(nbt.method_10577("FromFossil"));
        }
        if (nbt.method_10545("GoldSkull")) {
            this.setGoldSkull(nbt.method_10577("GoldSkull"));
        }
        if (nbt.method_10545("Power")) {
            this.updatePower(nbt.method_10550("Power"));
        }
        if (nbt.method_10545("IsFullyCharged")) {
            this.setFullyCharged(nbt.method_10577("IsFullyCharged"));
        }
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556("Deepslate", this.isDeepslate());
        nbt.method_10556("FromFossil", this.isFromFossil());
        nbt.method_10556("GoldSkull", this.hasGoldSkull());
        nbt.method_10569("Power", this.getPower());
        nbt.method_10569("MaxPower", this.getMaxPower());
        nbt.method_10556("IsFullyCharged", this.isFullyCharged());
    }

    private void createDeepslateAttributes() {
        this.method_5996(class_5134.field_23721).method_6192(4.5);
        this.method_5996(class_5134.field_23716).method_6192(25.0);
        this.method_5996(class_5134.field_23719).method_6192(0.23);
        this.method_5996(class_5134.field_23724).method_6192(15.0);
        this.method_5996(class_5134.field_23725).method_6192(5.0);
        this.method_5996(class_5134.field_23718).method_6192(0.55);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(LAST_DAMAGER_ID, (Object)this.method_5628());
        this.field_6011.method_12784(MAX_POWER, (Object)(100 + this.field_5974.nextInt(10) * 10));
        this.field_6011.method_12784(HAS_GOLD_SKULL, (Object)false);
        this.field_6011.method_12784(FROM_FOSSIL, (Object)false);
        this.field_6011.method_12784(DEEPSLATE, (Object)false);
        this.field_6011.method_12784(POWER, (Object)0);
        this.field_6011.method_12784(IS_FULLY_CHARGED, (Object)false);
        this.field_6011.method_12784(CURRENT_ORE, (Object)class_1799.field_8037);
        this.field_6011.method_12784(BLOCK_TARGET_POS, (Object)this.method_24515());
        this.field_6011.method_12784(CURRENT_ENTITY_STATE, (Object)0);
        this.field_6011.method_12784(STANDING, (Object)false);
    }

    private <E extends IAnimatable> PlayState statePredicate(AnimationEvent<E> event) {
        if (this.getEntityState() == 2) {
            event.getController().transitionLengthTicks = 3.0;
            event.getController().setAnimation(new AnimationBuilder().addAnimation("leap", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        if (this.getEntityState() == 1) {
            event.getController().transitionLengthTicks = 5.0;
            event.getController().setAnimation(new AnimationBuilder().addAnimation("dig", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        if (this.getEntityState() == 3 && this.method_5805()) {
            event.getController().transitionLengthTicks = 1.0;
            event.getController().setAnimation(new AnimationBuilder().addAnimation("tail_spin", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        if (this.getEntityState() == 0) {
            event.getController().transitionLengthTicks = 10.0;
            event.getController().setAnimation(new AnimationBuilder().addAnimation("idle", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private <E extends IAnimatable> PlayState movementPredicate(AnimationEvent<E> event) {
        if (this.isStanding()) {
            event.getController().transitionLengthTicks = 10.0;
            event.getController().setAnimation(new AnimationBuilder().addAnimation("stand", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        if (event.isMoving()) {
            event.getController().transitionLengthTicks = 3.0;
            if (this.method_5624() || (double)this.method_6029() > 0.3) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("sprint", Boolean.valueOf(true)));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("walk", Boolean.valueOf(true)));
            }
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "state", 10.0f, this::statePredicate));
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "move", 10.0f, this::movementPredicate));
    }

    public class_4048 method_18377(class_4050 pose) {
        float height = super.method_18377((class_4050)pose).field_18068;
        float width = super.method_18377((class_4050)pose).field_18067;
        if (this.getPower() < 0) {
            height += (float)this.getPower() / 1000.0f;
            width += (float)this.getPower() / 700.0f;
        }
        if (this.isStanding()) {
            return class_4048.method_18384((float)width, (float)(height * 2.0f));
        }
        return class_4048.method_18384((float)width, (float)height);
    }

    protected float method_18394(class_4050 pose, class_4048 dimensions) {
        return dimensions.field_18068 * 0.75f;
    }

    protected float method_6106() {
        float materialMultiplier = this.isDeepslate() ? 0.0f : 0.05f;
        return (0.42f + (float)this.getPower() / 4000.0f) * this.method_23313() + materialMultiplier;
    }

    protected int method_23329(float fallDistance, float damageMultiplier) {
        return (int)((double)super.method_23329(fallDistance, damageMultiplier) * 0.25);
    }

    public void method_5951(class_1297 targetEntity, float maxYawChange, float maxPitchChange) {
        if (this.method_24828()) {
            super.method_5951(targetEntity, maxYawChange, maxPitchChange);
        } else {
            super.method_5951(targetEntity, maxYawChange * 0.25f, maxPitchChange * 0.25f);
        }
    }

    public void method_5702(class_2183.class_2184 anchorPoint, class_243 target) {
        super.method_5702(anchorPoint, target);
    }

    public boolean method_5863() {
        return super.method_5863() && this.collides;
    }

    public void setCollides(boolean collides) {
        this.collides = collides;
    }

    protected void leap(class_243 direction, float hMultiplier, float vMultiplier) {
        this.method_5762(direction.field_1352 * (double)hMultiplier, direction.field_1351 * (double)vMultiplier, direction.field_1350 * (double)hMultiplier);
    }

    public void method_33579(class_2610 packet) {
        super.method_33579(packet);
        RubroActiveSoundInstance.playSound(this);
    }

    public void method_5773() {
        super.method_5773();
        if (!this.field_6002.field_9236 && this.field_6012 % 5 == 0 && (double)this.getPower() > (double)this.getMaxPower() * 0.4) {
            this.playCrackleParticles(this.field_5974.nextInt(3) + 1);
        }
        if (this.field_6012 % 20 == 0) {
            this.method_18382();
            if (this.getPower() > 0) {
                this.updatePower(this.getPower() - 1);
            }
        }
        for (class_2338 pos : this.ignoredBlocks.keySet()) {
            if (this.field_6012 - this.ignoredBlocks.get(pos) <= 600) continue;
            this.ignoredBlocks.remove(pos);
            break;
        }
    }

    public class_1269 method_5664(class_1657 player, class_243 hitPos, class_1268 hand) {
        class_1269 result = super.method_5664(player, hitPos, hand);
        if (this.field_6002.field_9236) {
            return class_1269.field_5814;
        }
        class_1799 mainStack = player.method_5998(hand);
        if (hand == class_1268.field_5808 && this.getPower() < this.getMaxPower()) {
            int pow = 0;
            if (mainStack.method_31574(class_1802.field_8725)) {
                pow = 1;
            } else if (mainStack.method_31574(class_1802.field_8793)) {
                pow = 9;
            }
            if (pow > 0) {
                if (!player.method_7337()) {
                    mainStack.method_7934(1);
                }
                this.updatePower(this.getPower() + pow);
                if (!this.field_6002.field_9236) {
                    this.field_6002.method_8396(null, this.method_24515(), EarthboundSounds.RUBRO_EAT, class_3419.field_15254, 0.35f + (float)pow / 20.0f, 0.9f + this.field_5974.nextFloat() / 5.0f);
                    this.field_6002.method_8396(null, this.method_24515(), EarthboundSounds.RUBRO_CHARGE, class_3419.field_15254, 0.35f + (float)pow / 20.0f, 0.9f + this.field_5974.nextFloat() / 5.0f);
                }
                this.playRedstoneParticles(10);
                return class_1269.field_5812;
            }
        }
        return class_1269.field_5814;
    }

    public int method_5850() {
        return super.method_5850() * 3;
    }

    public boolean method_5679(class_1282 damageSource) {
        return super.method_5679(damageSource) || damageSource.equals(class_1282.field_5854) || damageSource.equals(class_1282.field_5867);
    }

    @Nullable
    protected class_3414 method_5994() {
        return this.method_6109() ? null : EarthboundSounds.RUBRO_AMBIENT;
    }

    public void method_5966() {
        class_3414 soundEvent = this.method_5994();
        if (soundEvent != null) {
            this.method_5783(soundEvent, this.method_6107(), this.isDeepslate() ? 0.85f : 1.0f);
        }
    }

    @Nullable
    protected class_3414 method_6011(class_1282 source) {
        return EarthboundSounds.RUBRO_HURT;
    }

    @Nullable
    protected class_3414 method_6002() {
        return EarthboundSounds.RUBRO_DEATH;
    }

    public class_1310 method_6046() {
        return EarthboundEntityGroup.EARTHEN;
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        if (this.field_5974.nextDouble() < 0.1) {
            this.method_5783(EarthboundSounds.RUBRO_CREAK, 0.5f, 0.8f + this.field_5974.nextFloat() / 2.5f);
        }
        super.method_5712(pos, state);
    }

    public boolean method_5643(class_1282 source, float amount) {
        int powerLost = 0;
        if (this.getLastDamager() != null && source.method_5526() != null && !this.getLastDamager().equals((Object)source.method_5526())) {
            this.setLastDamager(source.method_5526());
        }
        ++powerLost;
        if (!Earthen.isDamagePickaxe(source)) {
            amount = Earthen.handleNonPickaxeDamage(source, (class_1309)this, amount);
        }
        if (!this.field_6002.field_9236) {
            if ((double)this.getPower() > (double)this.getMaxPower() * 0.4 && this.field_5974.nextDouble() < (double)amount / 30.0) {
                powerLost += 20;
                this.playRedstoneParticles(30);
                if (this.field_6002.method_8450().method_8355(class_1928.field_19391)) {
                    class_1542 item = new class_1542(this.field_6002, this.method_23317(), this.method_23318() + 0.5, this.method_23321(), class_1802.field_8725.method_7854());
                    item.method_6979(class_1802.field_8725.method_7854());
                    item.method_6988();
                    this.field_6002.method_8649((class_1297)item);
                }
            }
            this.method_5783(EarthboundSounds.RUBRO_CREAK, 0.5f, 0.8f + this.field_5974.nextFloat() / 2.5f);
            this.playRedstoneParticles(5);
        }
        this.updatePower(this.getPower() - powerLost);
        return super.method_5643(source, amount);
    }

    public static boolean checkMobSpawn(class_1299<? extends class_1308> type, class_1936 world, class_3730 spawnReason, class_2338 pos, Random random) {
        if ((spawnReason == class_3730.field_16459 || spawnReason == class_3730.field_16472) && pos.method_10264() > -60 && pos.method_10264() < 25) {
            if (world.method_22339(pos) > 8) {
                return false;
            }
            for (int x = -10; x < 10; ++x) {
                for (int y = -5; y < 5; ++y) {
                    for (int z = -10; z < 10; ++z) {
                        AdvancedBlockPos redstonePos = new AdvancedBlockPos(new class_2338(pos.method_10263() + x, pos.method_10264() + y, pos.method_10260() + z));
                        if (!RubroEntity.isBlockPowering(world.method_8320(redstonePos.getPos()).method_26204())) continue;
                        boolean isExposedToAir = false;
                        for (class_2338 loopPos : redstonePos.getAllFaces()) {
                            if (loopPos.equals((Object)redstonePos.down()) || !world.method_8320(loopPos).method_26215()) continue;
                            isExposedToAir = true;
                            break;
                        }
                        return RubroEntity.method_20636(type, (class_1936)world, (class_3730)spawnReason, (class_2338)pos, (Random)random) && isExposedToAir;
                    }
                }
            }
        }
        return false;
    }

    private static boolean isBlockPowering(class_2248 block) {
        return block.equals(class_2246.field_10080) || block.equals(class_2246.field_29030) || block.equals(EarthboundBlocks.REDSTONE_FOSSIL_BLOCK) || block.equals(EarthboundBlocks.GILDED_REDSTONE_FOSSIL_BLOCK) || block.equals(EarthboundBlocks.DEEPSLATE_REDSTONE_FOSSIL_BLOCK) || block.equals(EarthboundBlocks.DEEPSLATE_GILDED_REDSTONE_FOSSIL_BLOCK);
    }

    private void playRedstoneParticles(int amount) {
        for (int i = 0; i < amount; ++i) {
            ((class_3218)this.field_6002).method_14199((class_2394)class_2390.field_11188, this.method_23322(0.5), this.method_23319(), this.method_23325(0.5), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private void playCrackleParticles(int amount) {
        for (int i = 0; i < amount; ++i) {
            ((class_3218)this.field_6002).method_14199((class_2394)EarthboundParticles.REDSTONE_CRACKLE, this.method_23322(0.5), this.method_23319(), this.method_23325(0.5), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public int getMaxPower() {
        return (Integer)this.field_6011.method_12789(MAX_POWER);
    }

    private void setMaxPower(int maxPower) {
        this.field_6011.method_12778(MAX_POWER, (Object)maxPower);
    }

    public boolean isFromFossil() {
        return (Boolean)this.field_6011.method_12789(FROM_FOSSIL);
    }

    private void setFromFossil(boolean fromFossil) {
        this.field_6011.method_12778(FROM_FOSSIL, (Object)fromFossil);
    }

    public boolean hasGoldSkull() {
        return (Boolean)this.field_6011.method_12789(HAS_GOLD_SKULL);
    }

    private void setGoldSkull(boolean goldSkull) {
        this.field_6011.method_12778(HAS_GOLD_SKULL, (Object)goldSkull);
    }

    public boolean isDeepslate() {
        return (Boolean)this.field_6011.method_12789(DEEPSLATE);
    }

    private void setDeepslate(boolean deepslate) {
        this.field_6011.method_12778(DEEPSLATE, (Object)deepslate);
    }

    public int getPower() {
        return (Integer)this.field_6011.method_12789(POWER);
    }

    public void updatePower(int power) {
        this.field_6011.method_12778(POWER, (Object)Math.max(power, 0));
        if ((double)this.getPower() >= (double)this.getMaxPower() * 0.85 && !this.isFullyCharged()) {
            this.setFullyCharged(true);
        } else if (this.isFullyCharged() && this.getPower() < this.getMaxPower()) {
            this.setFullyCharged(false);
        }
        class_1324 instance = this.method_5996(class_5134.field_23721);
        instance.method_6200(POWER_DAMAGE_BOOST_ID);
        instance.method_26835(new class_1322(POWER_DAMAGE_BOOST_ID, "power_damage_boost", 1.0 + (double)this.getPower() / 150.0, class_1322.class_1323.field_6330));
        instance = this.method_5996(class_5134.field_23719);
        instance.method_6200(POWER_SPEED_BOOST_ID);
        instance.method_26835(new class_1322(POWER_SPEED_BOOST_ID, "power_speed_boost", (double)this.getPower() / 1000.0, class_1322.class_1323.field_6328));
        instance = this.method_5996(class_5134.field_23717);
        instance.method_6200(POWER_FOLLOW_RANGE_ID);
        instance.method_26835(new class_1322(POWER_FOLLOW_RANGE_ID, "power_follow_range", (double)this.getPower() / 80.0, class_1322.class_1323.field_6330));
    }

    public class_2338 getBlockTargetPos() {
        return ((class_2338)this.field_6011.method_12789(BLOCK_TARGET_POS)).method_25503();
    }

    public void setBlockTargetPos(class_2338 pos) {
        this.field_6011.method_12778(BLOCK_TARGET_POS, (Object)pos);
    }

    public int getEntityState() {
        return (Integer)this.field_6011.method_12789(CURRENT_ENTITY_STATE);
    }

    public void setEntityState(int id) {
        this.field_6011.method_12778(CURRENT_ENTITY_STATE, (Object)id);
    }

    public boolean isStanding() {
        return (Boolean)this.field_6011.method_12789(STANDING);
    }

    public void setStanding(boolean standing) {
        this.field_6011.method_12778(STANDING, (Object)standing);
    }

    @Override
    public class_1297 getLastDamager() {
        return this.field_6002.method_8469(((Integer)this.field_6011.method_12789(LAST_DAMAGER_ID)).intValue());
    }

    @Override
    public void setLastDamager(class_1297 entity) {
        this.field_6011.method_12778(LAST_DAMAGER_ID, (Object)entity.method_5628());
    }

    public boolean isFullyCharged() {
        return (Boolean)this.field_6011.method_12789(IS_FULLY_CHARGED);
    }

    public void setFullyCharged(boolean isMaxPower) {
        this.field_6011.method_12778(IS_FULLY_CHARGED, (Object)isMaxPower);
    }

    class MoveToRedstoneGoal
    extends class_1352 {
        private class_2338 pathDestination;
        private long lastAttemptTime;
        private final int startDigTicks;
        private int digTicks;
        private final int cooldown;

        public MoveToRedstoneGoal(int cooldown) {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
            this.cooldown = cooldown;
            this.startDigTicks = this.digTicks = 100 + RubroEntity.this.field_5974.nextInt(60);
            this.pathDestination = null;
            this.lastAttemptTime = RubroEntity.this.field_6002.method_8510() - (long)cooldown + 10L;
        }

        public boolean method_6264() {
            boolean isHealthy = RubroEntity.this.method_6032() > RubroEntity.this.method_6063() / 3.0f;
            boolean canStart = true;
            if (RubroEntity.this.getEntityState() != 0) {
                return false;
            }
            if (isHealthy && EarthUtil.isOnCooldown(RubroEntity.this.field_6002.method_8510(), this.lastAttemptTime, this.cooldown)) {
                return false;
            }
            this.lastAttemptTime = RubroEntity.this.field_6002.method_8510();
            if (isHealthy) {
                if (RubroEntity.this.method_5942().method_23966()) {
                    return false;
                }
                if ((double)RubroEntity.this.getPower() > (double)RubroEntity.this.getMaxPower() * 0.4) {
                    boolean bl = canStart = RubroEntity.this.field_5974.nextInt(RubroEntity.this.getPower() / 5) == 0;
                }
            }
            if (!canStart) {
                return false;
            }
            AdvancedBlockPos advPos = this.findValidPoweringBlock();
            if (advPos == null) {
                return false;
            }
            if (RubroEntity.this.ignoredBlocks.containsKey(advPos.getPos())) {
                return false;
            }
            this.pathDestination = advPos.getPos();
            return true;
        }

        public void method_6269() {
            class_2338 destination = this.pathDestination;
            class_1297 entity = class_1299.field_33456.method_5883(RubroEntity.this.field_6002);
            if (entity != null) {
                class_243 pos = new class_243((double)destination.method_10263() + 0.5, (double)(destination.method_10264() + 1), (double)destination.method_10260() + 0.5);
                entity.method_23327(pos.field_1352, pos.field_1351, pos.field_1350);
                RubroEntity.this.field_6002.method_8649(entity);
                RubroEntity.this.method_5942().method_6335(entity, 1.0);
            }
        }

        public void method_6268() {
            super.method_6268();
            class_2338 face = this.getFaceExposedToAir(RubroEntity.this.getBlockTargetPos());
            if (face == null) {
                return;
            }
            double distance = RubroEntity.this.method_33571().method_1022(class_243.method_24953((class_2382)face));
            if (this.digTicks == this.startDigTicks && distance < 2.0) {
                RubroEntity.this.method_5988().method_20248((double)RubroEntity.this.getBlockTargetPos().method_10263() + 0.5, (double)RubroEntity.this.getBlockTargetPos().method_10264(), (double)RubroEntity.this.getBlockTargetPos().method_10260() + 0.5);
                if (distance > 1.0) {
                    class_243 vec = EarthMath.dirBetweenVecs(RubroEntity.this.method_33571(), class_243.method_24953((class_2382)face).method_1031(0.0, 1.0, 0.0));
                    RubroEntity.this.leap(vec, 0.5f, 0.25f);
                }
                this.pathDestination = null;
                if (RubroEntity.this.method_33571().method_10214() < (double)RubroEntity.this.getBlockTargetPos().method_10264() && Math.abs(RubroEntity.this.method_33571().method_10214() - (double)RubroEntity.this.getBlockTargetPos().method_10264()) > 0.13) {
                    RubroEntity.this.setStanding(true);
                }
                RubroEntity.this.setEntityState(1);
            }
            if (RubroEntity.this.getEntityState() == 1) {
                this.dig();
            }
        }

        public boolean method_6266() {
            if (RubroEntity.this.method_6066().method_35040() && (double)RubroEntity.this.method_6032() > (double)RubroEntity.this.method_6063() / 1.5) {
                return false;
            }
            if (RubroEntity.this.getPower() < RubroEntity.this.getMaxPower() && this.digTicks > 0) {
                if (RubroEntity.this.getEntityState() == 0 && !RubroEntity.this.method_5942().method_6357()) {
                    return true;
                }
                if (RubroEntity.this.getBlockTargetPos() == null) {
                    Earthbounds.LOGGER.log(Level.ERROR, "Rubro Entity: " + RubroEntity.this.method_5845() + " attempted scraping a redstone ore which was null! Happened at location: " + RubroEntity.this.method_19538());
                } else {
                    if (this.getFaceExposedToAir(RubroEntity.this.getBlockTargetPos()) == null) {
                        Earthbounds.LOGGER.log(Level.ERROR, "Rubro Entity: " + RubroEntity.this.method_5845() + " attempted looking for a block's face  exposed to air, and it returned null! Happened at location: " + RubroEntity.this.method_19538());
                        return false;
                    }
                    if (RubroEntity.this.getEntityState() == 1 && RubroEntity.this.method_33571().method_1022(class_243.method_24953((class_2382)this.getFaceExposedToAir(RubroEntity.this.getBlockTargetPos()))) < 2.0) {
                        return true;
                    }
                }
            }
            return false;
        }

        public boolean method_38846() {
            return true;
        }

        public void method_6270() {
            if (RubroEntity.this.isStanding()) {
                RubroEntity.this.setStanding(false);
            }
            RubroEntity.this.setEntityState(0);
            this.digTicks = this.startDigTicks;
            RubroEntity.this.ignoredBlocks.putIfAbsent(RubroEntity.this.getBlockTargetPos(), RubroEntity.this.field_6012);
            super.method_6270();
        }

        private void dig() {
            float yLevel = RubroEntity.this.getBlockTargetPos().method_10264();
            if (RubroEntity.this.isStanding()) {
                yLevel -= 10.0f;
            }
            RubroEntity.this.method_5988().method_20248((double)RubroEntity.this.getBlockTargetPos().method_10263() + 0.5, (double)yLevel, (double)RubroEntity.this.getBlockTargetPos().method_10260() + 0.5);
            class_2248 class_22482 = RubroEntity.this.field_6002.method_8320(RubroEntity.this.getBlockTargetPos()).method_26204();
            if (class_22482 instanceof class_2449) {
                class_2449 redstone = (class_2449)class_22482;
                redstone.method_9591(RubroEntity.this.field_6002, RubroEntity.this.getBlockTargetPos(), RubroEntity.this.field_6002.method_8320(RubroEntity.this.getBlockTargetPos()), (class_1297)RubroEntity.this);
            }
            RubroEntity.this.method_5636(RubroEntity.this.method_5791());
            if ((long)(this.digTicks % 4) - Math.round((double)RubroEntity.this.getPower() / 100.0) == 0L) {
                if (!RubroEntity.this.field_6002.field_9236) {
                    RubroEntity.this.field_6002.method_8396(null, RubroEntity.this.method_24515(), RubroEntity.this.isDeepslate() ? class_3417.field_28973 : class_3417.field_15026, class_3419.field_15254, 0.5f, 1.5f);
                }
                this.playDigParticles();
            }
            if (this.digTicks % 10 == 0) {
                RubroEntity.this.updatePower(RubroEntity.this.getPower() + 10);
                if (RubroEntity.this.method_6032() < RubroEntity.this.method_6063()) {
                    RubroEntity.this.method_6025(2.0f);
                }
            }
            if (this.digTicks % 15 == 0) {
                if (!RubroEntity.this.field_6002.field_9236) {
                    RubroEntity.this.field_6002.method_8396(null, RubroEntity.this.method_24515(), EarthboundSounds.RUBRO_CHARGE, class_3419.field_15251, 0.25f, 0.9f + RubroEntity.this.field_5974.nextFloat() / 5.0f);
                }
                RubroEntity.this.playRedstoneParticles(10);
            }
            --this.digTicks;
        }

        private AdvancedBlockPos findValidPoweringBlock() {
            class_2338 origin = new class_2338(RubroEntity.this.method_33571());
            Iterable iterable = class_2338.method_25996((class_2338)origin, (int)10, (int)10, (int)10);
            for (class_2338 pos : iterable) {
                AdvancedBlockPos bestPos;
                if (!RubroEntity.isBlockPowering(RubroEntity.this.field_6002.method_8320(pos).method_26204()) || RubroEntity.this.ignoredBlocks.containsKey(pos) || RubroEntity.this.field_6002.method_18023(EarthboundEntities.RUBRO, class_238.method_30048((class_243)class_243.method_24953((class_2382)pos), (double)2.0, (double)2.0, (double)2.0), rubroEntity -> rubroEntity.getPower() >= 0 && !rubroEntity.equals(RubroEntity.this) && !rubroEntity.method_29504()).size() != 0 || (bestPos = this.calculateBestTargetPos(pos)) == null) continue;
                return bestPos;
            }
            return null;
        }

        private AdvancedBlockPos calculateBestTargetPos(class_2338 pos) {
            if (this.getFaceExposedToAir(pos) != null && !RubroEntity.this.field_6002.method_22347(this.getFaceExposedToAir(pos).method_10087(2))) {
                AdvancedBlockPos advPos = new AdvancedBlockPos(pos);
                if (!this.getFaceExposedToAir(pos).equals((Object)pos.method_25503().method_10074()) && !this.getFaceExposedToAir(pos).equals((Object)pos.method_25503().method_10084())) {
                    advPos = RubroEntity.this.field_6002.method_22347(this.getFaceExposedToAir(pos).method_10074()) ? new AdvancedBlockPos(this.getFaceExposedToAir(pos).method_10087(2)) : new AdvancedBlockPos(this.getFaceExposedToAir(pos).method_10074());
                }
                RubroEntity.this.setBlockTargetPos(pos);
                return advPos;
            }
            return null;
        }

        public class_2338 getFaceExposedToAir(class_2338 pos) {
            if (RubroEntity.this.field_6002.method_8320(pos.method_25503().method_10084()).method_26215()) {
                return pos.method_25503().method_10084();
            }
            if (RubroEntity.this.field_6002.method_8320(pos.method_25503().method_10095()).method_26215()) {
                return pos.method_25503().method_10095();
            }
            if (RubroEntity.this.field_6002.method_8320(pos.method_25503().method_10078()).method_26215()) {
                return pos.method_25503().method_10078();
            }
            if (RubroEntity.this.field_6002.method_8320(pos.method_25503().method_10072()).method_26215()) {
                return pos.method_25503().method_10072();
            }
            if (RubroEntity.this.field_6002.method_8320(pos.method_25503().method_10067()).method_26215()) {
                return pos.method_10067();
            }
            if (RubroEntity.this.field_6002.method_8320(pos.method_25503().method_10074()).method_26215()) {
                return pos.method_25503().method_10074();
            }
            return null;
        }

        private void playDigParticles() {
            class_243 particleLoc = RubroEntity.this.method_33571();
            class_243 dir = EarthMath.dirBetweenVecs(particleLoc, class_243.method_24953((class_2382)RubroEntity.this.getBlockTargetPos().method_25503().method_33098((int)RubroEntity.this.method_23320())));
            double xMult = 0.6;
            double yMult = -0.6;
            double zMult = 0.6;
            if (!RubroEntity.this.isStanding()) {
                yMult = RubroEntity.this.method_23318() >= 0.0 ? 3.5 : -0.6;
            }
            particleLoc = particleLoc.method_1019(dir.method_18805(xMult, yMult, zMult));
            ((class_3218)RubroEntity.this.field_6002).method_14199((class_2394)new class_2388(class_2398.field_11217, RubroEntity.this.field_6002.method_8320(RubroEntity.this.getBlockTargetPos())), particleLoc.field_1352, particleLoc.field_1351, particleLoc.field_1350, 10, 0.0, 0.0, 0.0, 0.0);
        }
    }

    class RubroAttackGoal
    extends class_1352 {
        private long lastAttemptTime;
        private long lastPounceTime;
        private long lastSpinTime;
        private boolean hasAirStruck = false;
        private final int spinCooldown;
        private final int pounceCooldown;
        private final int maxIdleTime = 30;
        private int tailSpinTime = 0;
        private int idleTime = 0;
        private final double defaultMinLeapDistance = 3.0;
        private final double defaultMaxLeapDistance;

        public RubroAttackGoal() {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
            this.lastPounceTime = RubroEntity.this.field_6002.method_8510() - (long)this.calculatePounceCooldown() + 30L;
            this.lastPounceTime = RubroEntity.this.field_6002.method_8510();
            if (RubroEntity.this.isDeepslate()) {
                this.spinCooldown = 70;
                this.pounceCooldown = 70;
                this.defaultMaxLeapDistance = 4.0;
            } else {
                this.spinCooldown = 50;
                this.pounceCooldown = 50;
                this.defaultMaxLeapDistance = 6.0;
            }
        }

        public boolean method_6264() {
            if (RubroEntity.this.field_6002.method_8510() - this.lastAttemptTime < 20L) {
                return false;
            }
            this.lastAttemptTime = RubroEntity.this.field_6002.method_8510();
            if ((double)RubroEntity.this.getPower() < (double)RubroEntity.this.getMaxPower() * 0.4) {
                return false;
            }
            if (RubroEntity.this.method_5968() == null) {
                return false;
            }
            if (RubroEntity.this.method_5968().method_29504()) {
                return false;
            }
            if (RubroEntity.this.getEntityState() != 0) {
                return false;
            }
            return !EarthUtil.isOnCooldown(RubroEntity.this.field_6002.method_8510(), this.lastPounceTime, this.pounceCooldown) && !EarthUtil.isOnCooldown(RubroEntity.this.field_6002.method_8510(), this.lastSpinTime, this.spinCooldown);
        }

        public void method_6269() {
            RubroEntity.this.method_5942().method_6335((class_1297)RubroEntity.this.method_5968(), 1.0);
            RubroEntity.this.method_19540(true);
        }

        public boolean method_6266() {
            class_1309 target = RubroEntity.this.method_5968();
            if ((double)RubroEntity.this.getPower() < (double)RubroEntity.this.getMaxPower() * 0.4) {
                return false;
            }
            if (target == null) {
                return false;
            }
            if (target.method_29504()) {
                return false;
            }
            if (!RubroEntity.this.method_18407(target.method_24515())) {
                return false;
            }
            if (target.method_7325() || target instanceof class_1657 && ((class_1657)target).method_7337()) {
                return false;
            }
            if (this.idleTime >= 30 && RubroEntity.this.getEntityState() != 2 && RubroEntity.this.getEntityState() != 3) {
                return false;
            }
            return !EarthUtil.isOnCooldown(RubroEntity.this.field_6002.method_8510(), this.lastSpinTime, this.spinCooldown);
        }

        public void method_6270() {
            class_1309 target = RubroEntity.this.method_5968();
            if (!class_1301.field_6156.test(target)) {
                RubroEntity.this.method_5980(null);
            }
            if (RubroEntity.this.method_5624()) {
                RubroEntity.this.method_5728(false);
            }
            RubroEntity.this.method_19540(false);
            RubroEntity.this.method_5942().method_6340();
            RubroEntity.this.setCollides(true);
            if (this.hasAirStruck) {
                this.hasAirStruck = false;
            }
            RubroEntity.this.setEntityState(0);
        }

        public boolean method_38846() {
            return true;
        }

        public void method_6268() {
            class_1309 target = RubroEntity.this.method_5968();
            this.updateIdleTime();
            double eyeToFootDistance = RubroEntity.this.method_33571().method_1022(RubroEntity.this.method_5968().method_19538());
            RubroEntity.this.method_5728(eyeToFootDistance > this.calculateMaxLeapDistance() && !RubroEntity.this.method_5942().method_6357());
            if (target == null) {
                return;
            }
            if (RubroEntity.this.method_24828()) {
                RubroEntity.this.method_5951((class_1297)RubroEntity.this.method_5968(), 30.0f, 30.0f);
            }
            if (EarthUtil.isOnCooldown(RubroEntity.this.field_6002.method_8510(), this.lastPounceTime, this.pounceCooldown) && RubroEntity.this.method_24828() && RubroEntity.this.getEntityState() == 2) {
                RubroEntity.this.setEntityState(0);
            }
            if (RubroEntity.this.getEntityState() == 0 && eyeToFootDistance <= this.calculateMaxLeapDistance() && eyeToFootDistance >= 3.0 && RubroEntity.this.method_6057((class_1297)target) && !EarthUtil.isOnCooldown(RubroEntity.this.field_6002.method_8510(), this.lastPounceTime, this.pounceCooldown) && !EarthUtil.isOnCooldown(RubroEntity.this.field_6002.method_8510(), this.lastSpinTime, this.spinCooldown) && EarthUtil.isEntityLookingAtEntity((class_1309)RubroEntity.this, RubroEntity.this.method_5968())) {
                this.pounce();
            }
            if (RubroEntity.this.getEntityState() == 2) {
                RubroEntity.this.playRedstoneParticles(3);
                if (RubroEntity.this.method_33571().method_1022(target.method_33571()) <= 1.5 && !this.hasAirStruck) {
                    this.airStrike();
                }
            }
            if (RubroEntity.this.getEntityState() == 0 && (this.hasAirStruck && RubroEntity.this.method_24828() || eyeToFootDistance <= 3.0 && !EarthUtil.isOnCooldown(RubroEntity.this.field_6002.method_8510(), this.lastSpinTime, this.spinCooldown))) {
                if (eyeToFootDistance <= 3.0) {
                    RubroEntity.this.setEntityState(3);
                    this.tailSpinTime = 37;
                } else {
                    RubroEntity.this.method_5942().method_6335((class_1297)RubroEntity.this.method_5968(), 1.0);
                }
            }
            if (RubroEntity.this.getEntityState() == 3) {
                if (this.tailSpinTime > 0) {
                    --this.tailSpinTime;
                }
                this.attemptTailSpin();
            }
        }

        protected void pounce() {
            RubroEntity.this.setEntityState(2);
            class_243 targetPos = RubroEntity.this.method_5968().method_33571().method_1031(0.0, 1.0, 0.0);
            double hyp = RubroEntity.this.method_33571().method_1022(targetPos);
            double opp = targetPos.field_1351 - RubroEntity.this.method_23320();
            float sin = (float)Math.sin(opp / hyp);
            float forceMultiplier = 1.2240763f - sin;
            float materialMultiplier = RubroEntity.this.isDeepslate() ? 1.0f : 1.15f;
            RubroEntity.this.leap(EarthMath.dirBetweenVecs(RubroEntity.this.method_19538(), targetPos), (1.3f + (float)RubroEntity.this.getPower() / 500.0f) * materialMultiplier, (1.3f + (float)RubroEntity.this.getPower() / 500.0f) * forceMultiplier * materialMultiplier);
            RubroEntity.this.setCollides(false);
            this.lastPounceTime = RubroEntity.this.field_6002.method_8510();
            RubroEntity.this.method_5942().method_6340();
            RubroEntity.this.method_5636(RubroEntity.this.method_5791());
            if (!RubroEntity.this.field_6002.field_9236) {
                RubroEntity.this.field_6002.method_8396(null, RubroEntity.this.method_24515(), class_3417.field_33438, class_3419.field_15251, 0.5f, 1.4f + RubroEntity.this.field_5974.nextFloat() / 5.0f);
            }
        }

        protected void airStrike() {
            class_1309 target = RubroEntity.this.method_5968();
            class_1285 source = new class_1285("rubro", (class_1297)RubroEntity.this){

                public class_2561 method_5506(class_1309 entity) {
                    String string = "death.attack." + this.field_5841 + ".pounce";
                    return new class_2588(string, new Object[]{entity.method_5476(), this.field_5879.method_5476()});
                }
            };
            float damage = (float)RubroEntity.this.method_26825(class_5134.field_23721) * 0.75f;
            target.method_5643((class_1282)source, target instanceof class_1657 ? damage : damage * 2.0f);
            this.hasAirStruck = true;
            if (target.method_24828()) {
                double yVel = RubroEntity.this.method_18798().method_10214();
                if (yVel <= 0.2 || yVel > 0.5) {
                    yVel = 0.3;
                }
                target.method_18799(RubroEntity.this.method_18798().method_1031(0.2, yVel, 0.2).method_18805(1.5, 1.0, 1.5));
            } else {
                target.method_18799(RubroEntity.this.method_18798());
            }
            if (target.method_6061((class_1282)source)) {
                RubroEntity.this.method_18799(RubroEntity.this.method_18798().method_22882());
            } else if (!RubroEntity.this.field_6002.field_9236) {
                RubroEntity.this.field_6002.method_8396(null, new class_2338(RubroEntity.this.method_33571()), class_3417.field_33439, class_3419.field_15251, 0.5f, 1.4f + RubroEntity.this.field_5974.nextFloat() / 5.0f);
            }
        }

        protected void attemptTailSpin() {
            if (this.tailSpinTime > 0) {
                int firstSpinHalfway = 10;
                int secondSpinHalfway = 27;
                int firstSpinBegin = 36;
                int secondSpinBegin = 18;
                boolean isOutOfReach = Math.abs(RubroEntity.this.method_23318() - RubroEntity.this.method_5968().method_23318()) > 0.5;
                class_243 dir = EarthMath.dirBetweenVecs(RubroEntity.this.method_19538(), RubroEntity.this.method_5968().method_19538());
                if (this.tailSpinTime == firstSpinBegin || this.tailSpinTime == secondSpinBegin) {
                    if (RubroEntity.this.method_24828() && (Math.abs(RubroEntity.this.method_23318() - RubroEntity.this.method_5968().method_23318()) > (double)EarthUtil.calculateJumpHeight(RubroEntity.this.method_6106()) || isOutOfReach) && RubroEntity.this.method_5968().method_23318() > RubroEntity.this.method_23318()) {
                        RubroEntity.this.leap(dir, 1.0f, 0.0f);
                        RubroEntity.this.method_6043();
                    }
                } else if (this.tailSpinTime == firstSpinBegin - 3 || this.tailSpinTime == secondSpinBegin - 3) {
                    if (!RubroEntity.this.field_6002.field_9236) {
                        RubroEntity.this.field_6002.method_8396(null, new class_2338(RubroEntity.this.method_33571()), class_3417.field_14987, class_3419.field_15251, 0.25f, 1.7f + RubroEntity.this.field_5974.nextFloat() / 5.0f);
                    }
                } else if (this.tailSpinTime == firstSpinHalfway || this.tailSpinTime == secondSpinHalfway) {
                    if (RubroEntity.this.method_24828()) {
                        RubroEntity.this.leap(dir, 1.0f, 0.0f);
                    }
                    for (class_1309 entity : RubroEntity.this.field_6002.method_8390(class_1309.class, class_238.method_30048((class_243)RubroEntity.this.method_19538(), (double)3.0, (double)1.0, (double)3.0), e -> !e.equals((Object)RubroEntity.this))) {
                        class_1282 source = new class_1282("mob"){

                            public class_2561 method_5506(class_1309 entity) {
                                String string = "death.attack." + this.field_5841;
                                return new class_2588(string, new Object[]{entity.method_5476(), RubroEntity.this.method_5476()});
                            }
                        };
                        float damage = (float)(RubroEntity.this.method_26825(class_5134.field_23721) * 0.5);
                        entity.method_5643(source, RubroEntity.this.method_5968() instanceof class_1657 ? damage : damage * 2.0f);
                        dir = EarthMath.dirBetweenVecs(RubroEntity.this.method_19538(), entity.method_19538());
                        entity.method_6015((class_1309)RubroEntity.this);
                        entity.method_18799(dir.method_1021(0.5).method_1031(0.0, 0.15, 0.0));
                    }
                }
            } else {
                RubroEntity.this.setEntityState(0);
                this.lastSpinTime = RubroEntity.this.field_6002.method_8510();
            }
        }

        private double calculateMaxLeapDistance() {
            return this.defaultMaxLeapDistance + (double)RubroEntity.this.getPower() / 100.0;
        }

        private int calculatePounceCooldown() {
            return this.pounceCooldown + RubroEntity.this.getPower() / 5;
        }

        private void updateIdleTime() {
            this.idleTime = RubroEntity.this.method_5942().method_6357() ? ++this.idleTime : 0;
        }
    }

    class RubroEscapeTargetGoal
    extends EscapeTargetGoal {
        public RubroEscapeTargetGoal() {
            super(RubroEntity.this, 1.0);
        }

        @Override
        public boolean method_6264() {
            if (RubroEntity.this.method_5968() == null) {
                return false;
            }
            if (RubroEntity.this.method_5739((class_1297)RubroEntity.this.method_5968()) > 12.0f) {
                return false;
            }
            return super.method_6264() && (double)RubroEntity.this.getPower() > (double)RubroEntity.this.getMaxPower() * 0.3;
        }

        @Override
        public void method_6269() {
            RubroEntity.this.method_5728(true);
            super.method_6269();
        }

        @Override
        public boolean method_6266() {
            if (RubroEntity.this.method_5968() == null) {
                return false;
            }
            if (RubroEntity.this.method_5739((class_1297)RubroEntity.this.method_5968()) > 16.0f) {
                return false;
            }
            return super.method_6266();
        }

        public void method_6270() {
            RubroEntity.this.method_5728(false);
            super.method_6270();
        }
    }

    class RedstoneTargetGoal
    extends class_1400<class_1657> {
        public RedstoneTargetGoal() {
            super((class_1308)RubroEntity.this, class_1657.class, 10, false, true, entity -> {
                if (!entity.method_24518(class_1802.field_8725)) {
                    if (!entity.method_24518(class_1802.field_8793)) return true;
                }
                if (!(entity instanceof class_1657)) return false;
                class_1657 player = (class_1657)entity;
                if (!PlayerBlockBreakEventHandler.getRedstoneBreakTimes().containsKey(player)) return false;
                if (com$github$klyser8$earthbounds$entity$RubroEntity$this.field_6002.method_8510() - PlayerBlockBreakEventHandler.getRedstoneBreakTimes().get(player) >= 3600L) return false;
                return true;
            });
        }

        public boolean method_6264() {
            return super.method_6264() && (double)RubroEntity.this.getPower() > (double)RubroEntity.this.getMaxPower() * 0.4;
        }
    }
}

