/*
 * Decompiled with CFR 0.152.
 */
package com.github.klyser8.earthbounds.entity.renderer;

import com.github.klyser8.earthbounds.entity.RubroEntity;
import com.github.klyser8.earthbounds.entity.model.RubroEntityModel;
import com.github.klyser8.earthbounds.entity.renderer.EarthenEntityRenderer;
import com.github.klyser8.earthbounds.entity.renderer.RubroMaskLayer;
import com.github.klyser8.earthbounds.entity.renderer.RubroRedstoneLayer;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import software.bernie.geckolib3.geo.render.built.GeoBone;
import software.bernie.geckolib3.geo.render.built.GeoModel;
import software.bernie.geckolib3.renderers.geo.IGeoRenderer;

public class RubroEntityRenderer
extends EarthenEntityRenderer<RubroEntity> {
    public RubroEntityRenderer(class_5617.class_5618 ctx) {
        super(ctx, new RubroEntityModel());
        this.addLayer(new RubroRedstoneLayer((IGeoRenderer<RubroEntity>)this));
        this.addLayer(new RubroMaskLayer((IGeoRenderer<RubroEntity>)this));
    }

    public class_1921 getRenderType(RubroEntity animatable, float partialTicks, class_4587 stack, class_4597 renderTypeBuffer, class_4588 vertexBuilder, int packedLightIn, class_2960 textureLocation) {
        return class_1921.method_23580((class_2960)this.getTextureLocation((class_1309)animatable));
    }

    @Override
    public void render(GeoModel model, RubroEntity rubro, float partialTicks, class_1921 type, class_4587 matrixStackIn, class_4597 renderTypeBuffer, class_4588 vertexBuilder, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        boolean shouldPop = false;
        this.renderMask(model, rubro);
        if (rubro.getPower() < 0) {
            this.babify(matrixStackIn, 1.0f + (float)rubro.getPower() / 650.0f);
            shouldPop = true;
        }
        super.render(model, rubro, partialTicks, type, matrixStackIn, renderTypeBuffer, vertexBuilder, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        if (shouldPop) {
            matrixStackIn.method_22909();
        }
    }

    private void babify(class_4587 matrixStackIn, float scale) {
        matrixStackIn.method_22903();
        matrixStackIn.method_22905(scale, scale, scale);
        this.field_4673 = scale / 2.0f;
    }

    private void renderMask(GeoModel model, RubroEntity rubro) {
        if (model.getBone("mask").isEmpty()) {
            System.err.println("RubroEntityRenderer: Mask is missing!");
        } else if (!rubro.isFromFossil()) {
            if (!((GeoBone)model.getBone("mask").get()).isHidden()) {
                model.getBone("mask").ifPresent(geoBone -> geoBone.setHidden(true));
            }
        } else if (((GeoBone)model.getBone("mask").get()).isHidden()) {
            model.getBone("mask").ifPresent(geoBone -> geoBone.setHidden(false));
        }
    }
}

