/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.originsclasses.util;

import com.google.common.collect.Sets;
import io.github.apace100.originsclasses.mixin.CombinedEntryAccessor;
import io.github.apace100.originsclasses.mixin.ItemEntryAccessor;
import io.github.apace100.originsclasses.mixin.LootPoolAccessor;
import io.github.apace100.originsclasses.mixin.LootTableAccessor;
import io.github.apace100.originsclasses.mixin.TagEntryAccessor;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Random;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_55;
import net.minecraft.class_60;
import net.minecraft.class_69;
import net.minecraft.class_77;
import net.minecraft.class_79;
import net.minecraft.class_91;
import net.minecraft.server.MinecraftServer;

public class ItemUtil {
    private static final Set<class_1792> OBTAINABLE = new HashSet<class_1792>();
    private static class_1792[] OBTAINABLE_ARRAY;
    private static boolean isObtainableSetBuilt;

    public static class_1799 createMerchantItemStack(class_1792 item, Random random) {
        class_1799 stack = new class_1799((class_1935)item);
        if (item.method_7870(stack) && (double)random.nextFloat() < 0.5) {
            class_1890.method_8233((Random)random, (class_1799)stack, (int)(1 + random.nextInt(30)), (boolean)random.nextBoolean());
        }
        return stack;
    }

    public static boolean isObtainable(MinecraftServer server, class_1792 item) {
        ItemUtil.buildObtainableSet(server);
        return OBTAINABLE.contains(item);
    }

    public static class_1792 getRandomObtainableItem(MinecraftServer server, Random random, Set<class_1792> exclude) {
        ItemUtil.buildObtainableSet(server);
        if (exclude == null || exclude.isEmpty()) {
            return OBTAINABLE_ARRAY[random.nextInt(OBTAINABLE_ARRAY.length)];
        }
        Sets.SetView possibles = Sets.difference(OBTAINABLE, exclude);
        class_1792[] items = new class_1792[possibles.size()];
        items = possibles.toArray(items);
        return items[random.nextInt(items.length)];
    }

    public static void buildObtainableSet(MinecraftServer server) {
        if (isObtainableSetBuilt) {
            return;
        }
        class_60 manager = server.method_3857();
        Set lootTables = manager.method_370();
        for (class_2960 id : lootTables) {
            LootTableAccessor table = (LootTableAccessor)manager.method_367(id);
            class_55[] pools = table.getPools();
            LinkedList<class_79> entryQueue = new LinkedList<class_79>();
            for (class_55 pool : pools) {
                class_79[] entries = ((LootPoolAccessor)pool).getEntries();
                entryQueue.addAll(Arrays.asList(entries));
            }
            while (!entryQueue.isEmpty()) {
                class_79 entry = (class_79)entryQueue.remove();
                if (entry instanceof class_77) {
                    OBTAINABLE.add(((ItemEntryAccessor)entry).getItem());
                    continue;
                }
                if (entry instanceof class_91) {
                    OBTAINABLE.addAll(((TagEntryAccessor)entry).getName().method_15138());
                    continue;
                }
                if (!(entry instanceof class_69)) continue;
                entryQueue.addAll(Arrays.asList(((CombinedEntryAccessor)entry).getChildren()));
            }
        }
        OBTAINABLE_ARRAY = new class_1792[OBTAINABLE.size()];
        OBTAINABLE_ARRAY = OBTAINABLE.toArray(OBTAINABLE_ARRAY);
        isObtainableSetBuilt = true;
    }

    static {
        isObtainableSetBuilt = false;
    }
}

