/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.client.gui.element;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.ilexiconn.llibrary.LLibrary;
import net.ilexiconn.llibrary.client.ClientProxy;
import net.ilexiconn.llibrary.client.gui.element.ElementHandler;
import net.ilexiconn.llibrary.client.gui.element.ScrollbarElement;
import net.ilexiconn.llibrary.client.gui.element.color.ColorScheme;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.Tessellator;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class Element<T extends GuiScreen> {
    public static final ColorScheme DEFAULT = ColorScheme.create(() -> LLibrary.CONFIG.getPrimaryColor(), () -> LLibrary.CONFIG.getSecondaryColor());
    private final T gui;
    private Element<T> parent;
    private List<Element<T>> children = new ArrayList<Element<T>>();
    private ColorScheme colorScheme = DEFAULT;
    private float posX;
    private float posY;
    private int width;
    private int height;
    private boolean enabled = true;
    private boolean visible = true;

    public Element(T gui, float posX, float posY, int width, int height) {
        this.gui = gui;
        this.posX = posX;
        this.posY = posY;
        this.width = width;
        this.height = height;
    }

    public void init() {
    }

    public void update() {
    }

    public void render(float mouseX, float mouseY, float partialTicks) {
    }

    public boolean mouseClicked(float mouseX, float mouseY, int button) {
        return this.isSelected(mouseX, mouseY);
    }

    public boolean mouseDragged(float mouseX, float mouseY, int button, long timeSinceClick) {
        return this.isSelected(mouseX, mouseY);
    }

    public boolean mouseReleased(float mouseX, float mouseY, int button) {
        return this.isSelected(mouseX, mouseY);
    }

    public boolean keyPressed(char character, int key) {
        return false;
    }

    public boolean mouseScrolled(float mouseX, float mouseY, int amount) {
        if (this.isSelected(mouseX, mouseY)) {
            for (Element<T> child : this.getChildren()) {
                if (!(child instanceof ScrollbarElement)) continue;
                ((ScrollbarElement)child).setScrollVelocity(((ScrollbarElement)child).getScrollVelocity() + (float)amount / 120.0f * 0.5f);
                break;
            }
            return true;
        }
        return false;
    }

    protected boolean isSelected(float mouseX, float mouseY) {
        return ElementHandler.INSTANCE.isElementOnTop(this.getGUI(), this) && mouseX >= this.getPosX() && mouseY >= this.getPosY() && mouseX < this.getPosX() + (float)this.getWidth() && mouseY < this.getPosY() + (float)this.getHeight();
    }

    public Element<T> withParent(Element<T> parent) {
        if (this.parent != null) {
            this.parent.children.remove(this);
        }
        this.parent = parent;
        if (this.parent != null && !this.parent.children.contains(this)) {
            this.parent.children.add(this);
        }
        this.children.clear();
        this.init();
        return this;
    }

    public Element<T> withColorScheme(ColorScheme colorScheme) {
        this.colorScheme = colorScheme;
        return this;
    }

    public T getGUI() {
        return this.gui;
    }

    public Element<T> getParent() {
        return this.parent;
    }

    public List<Element<T>> getChildren() {
        return this.children;
    }

    public ColorScheme getColorScheme() {
        return this.colorScheme;
    }

    public float getPosX() {
        return this.posX + (this.getParent() != null ? this.getParent().getPosX() : 0.0f);
    }

    public void setPosX(float posX) {
        this.posX = posX;
    }

    public float getPosY() {
        return this.posY + (this.getParent() != null ? this.getParent().getPosY() : 0.0f);
    }

    public void setPosY(float posY) {
        this.posY = posY;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    protected void drawRectangle(double x, double y, double width, double height, int color) {
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78369_a(r, g, b, a);
        tessellator.func_78377_a(x, y + height, 0.0);
        tessellator.func_78377_a(x + width, y + height, 0.0);
        tessellator.func_78377_a(x + width, y, 0.0);
        tessellator.func_78377_a(x, y, 0.0);
        tessellator.func_78381_a();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
    }

    protected void drawTexturedRectangle(double x, double y, double width, double height, int color) {
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78369_a(r, g, b, a);
        tessellator.func_78374_a(x, y + height, 0.0, 0.0, 1.0);
        tessellator.func_78374_a(x + width, y + height, 0.0, 1.0, 1.0);
        tessellator.func_78374_a(x + width, y, 0.0, 1.0, 0.0);
        tessellator.func_78374_a(x, y, 0.0, 0.0, 0.0);
        tessellator.func_78381_a();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
    }

    protected void drawOutline(double x, double y, double width, double height, int color, double outlineSize) {
        this.drawRectangle(x, y, width - outlineSize, outlineSize, color);
        this.drawRectangle(x + width - outlineSize, y, outlineSize, height - outlineSize, color);
        this.drawRectangle(x, y + height - outlineSize, width, outlineSize, color);
        this.drawRectangle(x, y, outlineSize, height - outlineSize, color);
    }

    protected void startScissor() {
        GL11.glEnable((int)3089);
        float scaleFactor = new ScaledResolution(ClientProxy.MINECRAFT, ClientProxy.MINECRAFT.field_71443_c, ClientProxy.MINECRAFT.field_71440_d).func_78325_e();
        GL11.glScissor((int)((int)(this.posX * scaleFactor)), (int)((int)(((float)((GuiScreen)this.gui).field_146295_m - (this.posY + (float)this.height)) * scaleFactor)), (int)((int)((float)this.width * scaleFactor)), (int)((int)((float)this.height * scaleFactor)));
    }

    protected void endScissor() {
        GL11.glDisable((int)3089);
    }

    public int drawString(String string, float x, float y, int color, boolean shadow) {
        int l;
        FontRenderer fontRenderer = ((GuiScreen)this.getGUI()).field_146297_k.field_71466_p;
        GL11.glEnable((int)3008);
        fontRenderer.func_78265_b();
        if (shadow) {
            l = this.renderString(string, x + 1.0f, y + 1.0f, color, true);
            l = Math.max(l, this.renderString(string, x, y, color, false));
        } else {
            l = this.renderString(string, x, y, color, false);
        }
        return l;
    }

    private int renderString(String string, float x, float y, int color, boolean shadow) {
        if (string != null) {
            FontRenderer fontRenderer = ((GuiScreen)this.getGUI()).field_146297_k.field_71466_p;
            if (fontRenderer.field_78294_m) {
                string = fontRenderer.func_147647_b(string);
            }
            if ((color & 0xFC000000) == 0) {
                color |= 0xFF000000;
            }
            if (shadow) {
                color = (color & 0xFCFCFC) >> 2 | color & 0xFF000000;
            }
            fontRenderer.field_78291_n = (float)(color >> 16 & 0xFF) / 255.0f;
            fontRenderer.field_78292_o = (float)(color >> 8 & 0xFF) / 255.0f;
            fontRenderer.field_78306_p = (float)(color & 0xFF) / 255.0f;
            fontRenderer.field_78305_q = (float)(color >> 24 & 0xFF) / 255.0f;
            GL11.glColor4f((float)fontRenderer.field_78291_n, (float)fontRenderer.field_78292_o, (float)fontRenderer.field_78306_p, (float)fontRenderer.field_78305_q);
            fontRenderer.field_78295_j = x;
            fontRenderer.field_78296_k = y;
            fontRenderer.func_78255_a(string, shadow);
            return (int)fontRenderer.field_78295_j;
        }
        return 0;
    }
}

