/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.client.model.qubble;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.ilexiconn.llibrary.client.model.qubble.QubbleAnimationKeyframe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class QubbleAnimation {
    private String name;
    private List<QubbleAnimationKeyframe> keyframes = new ArrayList<QubbleAnimationKeyframe>();

    private QubbleAnimation() {
    }

    public static QubbleAnimation create(String name) {
        QubbleAnimation animation = new QubbleAnimation();
        animation.setName(name);
        return animation;
    }

    public static QubbleAnimation deserialize(NBTTagCompound compound) {
        QubbleAnimation animation = new QubbleAnimation();
        animation.deserializeNBT(compound);
        return animation;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("name", this.name);
        NBTTagList keyframesTag = new NBTTagList();
        for (QubbleAnimationKeyframe keyframe : this.keyframes) {
            keyframesTag.func_74742_a((NBTBase)keyframe.serializeNBT());
        }
        compound.func_74782_a("keyframes", (NBTBase)keyframesTag);
        return compound;
    }

    public void deserializeNBT(NBTTagCompound compound) {
        this.name = compound.func_74779_i("name");
        NBTTagList keyframesTag = compound.func_150295_c("name", 10);
        for (int i = 0; i < keyframesTag.func_74745_c(); ++i) {
            this.keyframes.add(QubbleAnimationKeyframe.deserialize(keyframesTag.func_150305_b(i)));
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<QubbleAnimationKeyframe> getKeyframes() {
        return this.keyframes;
    }

    public QubbleAnimation copy() {
        QubbleAnimation animation = QubbleAnimation.create(this.getName());
        animation.getKeyframes().addAll(this.getKeyframes().stream().map(QubbleAnimationKeyframe::copy).collect(Collectors.toList()));
        return animation;
    }
}

