/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.client.model.tabula;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ilexiconn.llibrary.client.model.tabula.ITabulaModelAnimator;
import net.ilexiconn.llibrary.client.model.tabula.container.TabulaCubeContainer;
import net.ilexiconn.llibrary.client.model.tabula.container.TabulaCubeGroupContainer;
import net.ilexiconn.llibrary.client.model.tabula.container.TabulaModelContainer;
import net.ilexiconn.llibrary.client.model.tools.AdvancedModelBase;
import net.ilexiconn.llibrary.client.model.tools.AdvancedModelRenderer;
import net.minecraft.entity.Entity;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class TabulaModel
extends AdvancedModelBase {
    protected Map<String, AdvancedModelRenderer> cubes = new HashMap<String, AdvancedModelRenderer>();
    protected List<AdvancedModelRenderer> rootBoxes = new ArrayList<AdvancedModelRenderer>();
    protected ITabulaModelAnimator tabulaAnimator;
    protected Map<String, AdvancedModelRenderer> identifierMap = new HashMap<String, AdvancedModelRenderer>();
    protected double[] scale;

    public TabulaModel(TabulaModelContainer container, ITabulaModelAnimator tabulaAnimator) {
        this.field_78090_t = container.getTextureWidth();
        this.field_78089_u = container.getTextureHeight();
        this.tabulaAnimator = tabulaAnimator;
        for (TabulaCubeContainer cube : container.getCubes()) {
            this.parseCube(cube, null);
        }
        container.getCubeGroups().forEach(this::parseCubeGroup);
        this.updateDefaultPose();
        this.scale = container.getScale();
    }

    public TabulaModel(TabulaModelContainer container) {
        this(container, null);
    }

    private void parseCubeGroup(TabulaCubeGroupContainer container) {
        for (TabulaCubeContainer cube : container.getCubes()) {
            this.parseCube(cube, null);
        }
        container.getCubeGroups().forEach(this::parseCubeGroup);
    }

    private void parseCube(TabulaCubeContainer cube, AdvancedModelRenderer parent) {
        AdvancedModelRenderer box = this.createBox(cube);
        this.cubes.put(cube.getName(), box);
        this.identifierMap.put(cube.getIdentifier(), box);
        if (parent != null) {
            parent.func_78792_a(box);
        } else {
            this.rootBoxes.add(box);
        }
        for (TabulaCubeContainer child : cube.getChildren()) {
            this.parseCube(child, box);
        }
    }

    private AdvancedModelRenderer createBox(TabulaCubeContainer cube) {
        int[] textureOffset = cube.getTextureOffset();
        double[] position = cube.getPosition();
        double[] rotation = cube.getRotation();
        double[] offset = cube.getOffset();
        int[] dimensions = cube.getDimensions();
        AdvancedModelRenderer box = new AdvancedModelRenderer(this, cube.getName());
        box.setTextureOffset(textureOffset[0], textureOffset[1]);
        box.func_78793_a((float)position[0], (float)position[1], (float)position[2]);
        box.func_78790_a((float)offset[0], (float)offset[1], (float)offset[2], dimensions[0], dimensions[1], dimensions[2], 0.0f);
        box.field_78795_f = (float)Math.toRadians(rotation[0]);
        box.field_78796_g = (float)Math.toRadians(rotation[1]);
        box.field_78808_h = (float)Math.toRadians(rotation[2]);
        return box;
    }

    public void func_78088_a(Entity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float rotationYaw, float rotationPitch, float scale) {
        this.func_78087_a(limbSwing, limbSwingAmount, ageInTicks, rotationYaw, rotationPitch, scale, entity);
        GL11.glPushMatrix();
        GL11.glScaled((double)this.scale[0], (double)this.scale[1], (double)this.scale[2]);
        for (AdvancedModelRenderer box : this.rootBoxes) {
            box.func_78785_a(scale);
        }
        GL11.glPopMatrix();
    }

    public void func_78087_a(float limbSwing, float limbSwingAmount, float ageInTicks, float rotationYaw, float rotationPitch, float scale, Entity entity) {
        this.resetToDefaultPose();
        if (this.tabulaAnimator != null) {
            this.tabulaAnimator.setRotationAngles(this, entity, limbSwing, limbSwingAmount, ageInTicks, rotationYaw, rotationPitch, scale);
        }
    }

    public AdvancedModelRenderer getCube(String name) {
        return this.cubes.get(name);
    }

    public AdvancedModelRenderer getCubeByIdentifier(String identifier) {
        return this.identifierMap.get(identifier);
    }

    public Map<String, AdvancedModelRenderer> getCubes() {
        return this.cubes;
    }
}

