/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.server.command;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.ilexiconn.llibrary.LLibrary;
import net.ilexiconn.llibrary.server.command.CommandHandler;
import net.ilexiconn.llibrary.server.command.ICommandExecutor;
import net.ilexiconn.llibrary.server.command.argument.Argument;
import net.ilexiconn.llibrary.server.command.argument.CommandArguments;
import net.ilexiconn.llibrary.server.command.argument.IArgumentParser;
import net.ilexiconn.llibrary.server.util.ListHashMap;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;

public class Command
extends CommandBase {
    private String name;
    private String commandUsage;
    private int permissionLevel = 4;
    private ListHashMap<String, IArgumentParser<?>> requiredArguments = new ListHashMap();
    private ListHashMap<String, IArgumentParser<?>> optionalArguments = new ListHashMap();
    private ICommandExecutor executor;

    private Command(String name) {
        this.name = name;
    }

    public static Command create(String name) {
        return new Command(name);
    }

    public Command setPermissionLevel(int permissionLevel) {
        this.permissionLevel = permissionLevel;
        return this;
    }

    public <T> Command addRequiredArgument(String argument, Class<T> type) {
        if (!this.optionalArguments.isEmpty()) {
            LLibrary.LOGGER.error("Please register required arguments before optional ones! Skipping argument " + argument + " with type " + type + ".");
            return this;
        }
        IArgumentParser<T> argumentParser = CommandHandler.INSTANCE.getParserForType(type);
        if (argumentParser != null) {
            this.requiredArguments.put(argument, argumentParser);
        } else {
            LLibrary.LOGGER.error("Unable to find argument parser for type " + type + ". Skipping argument.");
        }
        return this;
    }

    public <T> Command addOptionalArgument(String argument, Class<T> type) {
        IArgumentParser<T> argumentParser = CommandHandler.INSTANCE.getParserForType(type);
        if (argumentParser != null) {
            this.optionalArguments.put(argument, argumentParser);
        } else {
            LLibrary.LOGGER.error("Unable to find argument parser for type " + type + ". Skipping argument.");
        }
        return this;
    }

    Command setExecutor(ICommandExecutor executor) {
        this.executor = executor;
        return this;
    }

    public String func_71517_b() {
        return this.name;
    }

    public int func_82362_a() {
        return this.permissionLevel;
    }

    public String func_71518_a(ICommandSender sender) {
        if (this.commandUsage == null) {
            StringBuilder builder = new StringBuilder();
            builder.append("/");
            builder.append(this.func_71517_b());
            for (String requiredArgument : this.requiredArguments.keySet()) {
                builder.append(" ");
                builder.append("<");
                builder.append(requiredArgument);
                builder.append(">");
            }
            for (String optionalArgument : this.optionalArguments.keySet()) {
                builder.append(" ");
                builder.append("[");
                builder.append(optionalArgument);
                builder.append("]");
            }
            this.commandUsage = builder.toString();
            return this.commandUsage;
        }
        return this.commandUsage;
    }

    public void func_71515_b(ICommandSender sender, String[] args) throws CommandException {
        if (args.length < this.requiredArguments.size()) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        if (args.length > this.requiredArguments.size() + this.optionalArguments.size()) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        ArrayList arguments = Lists.newArrayList();
        for (int i = 0; i < args.length; ++i) {
            Map.Entry<String, IArgumentParser<?>> entry;
            if (i < this.requiredArguments.size()) {
                entry = this.requiredArguments.getEntry(i);
                try {
                    arguments.add(new Argument(entry.getKey(), entry.getValue().parseArgument(MinecraftServer.func_71276_C(), sender, args[i])));
                }
                catch (CommandException e) {
                    sender.func_145747_a(new ChatComponentText(e.getLocalizedMessage()).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.RED)));
                }
                continue;
            }
            entry = this.optionalArguments.getEntry(i - this.requiredArguments.size());
            try {
                arguments.add(new Argument(entry.getKey(), entry.getValue().parseArgument(MinecraftServer.func_71276_C(), sender, args[i])));
                continue;
            }
            catch (CommandException e) {
                sender.func_145747_a(new ChatComponentText(e.getLocalizedMessage()).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.RED)));
            }
        }
        this.executor.execute(MinecraftServer.func_71276_C(), sender, new CommandArguments(arguments));
    }

    public List<String> func_71516_a(ICommandSender sender, String[] args) {
        if (args.length <= this.requiredArguments.size()) {
            return this.requiredArguments.getValue(args.length - 1).getTabCompletion(MinecraftServer.func_71276_C(), sender, args);
        }
        if (args.length <= this.requiredArguments.size() + this.optionalArguments.size()) {
            return this.optionalArguments.getValue(args.length - this.requiredArguments.size() - 1).getTabCompletion(MinecraftServer.func_71276_C(), sender, args);
        }
        return Collections.emptyList();
    }
}

