/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.server.entity;

import java.util.Collections;
import java.util.Set;
import net.ilexiconn.llibrary.server.entity.PropertiesTracker;
import net.ilexiconn.llibrary.server.util.WeakIdentityHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public abstract class EntityProperties<T extends Entity>
implements IExtendedEntityProperties {
    private World world;
    private T entity;
    private Set<PropertiesTracker<?>> trackers = Collections.newSetFromMap(new WeakIdentityHashMap());

    public final void init(Entity entity, World world) {
        this.entity = entity;
        this.world = world;
        this.init();
    }

    public Set<PropertiesTracker<?>> getTrackers() {
        return this.trackers;
    }

    public void sync() {
        this.trackers.forEach(PropertiesTracker::setReady);
    }

    public final World getWorld() {
        return this.world;
    }

    public final T getEntity() {
        return this.entity;
    }

    public abstract void init();

    public abstract String getID();

    public abstract Class<T> getEntityClass();

    public int getTrackingTime() {
        return -1;
    }

    public int getTrackingUpdateTime() {
        return 0;
    }

    public void saveTrackingSensitiveData(NBTTagCompound compound) {
        this.saveNBTData(compound);
    }

    public void loadTrackingSensitiveData(NBTTagCompound compound) {
        this.loadNBTData(compound);
    }

    public void onSync() {
    }

    public PropertiesTracker<T> createTracker(T entity) {
        PropertiesTracker<T> tracker = new PropertiesTracker<T>(entity, this);
        this.trackers.add(tracker);
        return tracker;
    }
}

