/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.multipart.microblock;

import codechicken.lib.render.BlockRenderer;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.Vertex5;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import codechicken.microblock.MicroMaterialRegistry;
import codechicken.multipart.TMultiPart;
import com.rwtema.extrautils.LogHelper;
import com.rwtema.extrautils.multipart.microblock.PartMicroBlock;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class PartSphere
extends PartMicroBlock {
    final double r = 0.375;
    public static Cuboid6 bounds;
    public static final Vector3 DOWN;
    public static final Vector3 UP;
    public static final Vector3 NORTH;
    public static final Vector3 SOUTH;
    public static final Vector3 EAST;
    public static final Vector3 WEST;
    public BlockFaceUniformLighting face = new BlockFaceUniformLighting();
    public static ArrayList<Vertex5[]> faces;
    public static ArrayList<Vertex5[]> faces_inv;
    double h = 1.35;
    double h2 = Math.sqrt(1.0 - this.h * this.h / 4.0);

    public PartSphere(int materialID) {
        super(materialID);
    }

    public PartSphere() {
    }

    public Cuboid6 getBounds() {
        return new Cuboid6(0.125, 0.125, 0.125, 0.875, 0.875, 0.875);
    }

    @Override
    public String getType() {
        return "extrautils:sphere";
    }

    @Override
    public Iterable<Cuboid6> getCollisionBoxes() {
        if (this.isEthereal()) {
            return new ArrayList<Cuboid6>();
        }
        return Arrays.asList(this.getBounds());
    }

    @Override
    public boolean hideCreativeTab() {
        return false;
    }

    @Override
    public void reloadShape() {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(Vector3 pos, int pass) {
        this.renderSphere(pos.copy().add(0.5), pass, this.mat);
    }

    @Override
    public int getMetadata() {
        return 3;
    }

    @Override
    public TMultiPart newPart(boolean client) {
        return new PartSphere();
    }

    @Override
    public TMultiPart placePart(ItemStack stack, EntityPlayer player, World world, BlockCoord pos, int side, Vector3 arg5, int materialID) {
        return new PartSphere(materialID);
    }

    @Override
    public void registerPassThroughs() {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderItem(ItemStack item, MicroMaterialRegistry.IMicroMaterial material) {
        Vector3 pos = new Vector3(0.5, 0.5, 0.5);
        if (faces_inv == null) {
            faces_inv = new ArrayList();
            this.calcSphere(0.5, 0.5, faces_inv);
            LogHelper.debug("Calculated faces " + faces_inv.size(), new Object[0]);
        }
        CCRenderState.setModel((CCRenderState.IVertexSource)this.face);
        for (Vertex5[] f : faces_inv) {
            this.face.lcComputed = false;
            this.face.verts[0].set(f[0]);
            this.face.verts[1].set(f[1]);
            this.face.verts[2].set(f[2]);
            this.face.verts[3].set(f[3]);
            this.face.side = f[0].uv.tex;
            material.renderMicroFace(pos, -1, this.getBounds());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderSphere(Vector3 pos, int pass, MicroMaterialRegistry.IMicroMaterial m) {
        if (faces == null) {
            faces = new ArrayList();
            this.calcSphere(0.25, 0.25, faces);
            LogHelper.debug("Calculated " + faces.size(), new Object[0]);
        }
        CCRenderState.setModel((CCRenderState.IVertexSource)this.face);
        for (Vertex5[] f : faces) {
            this.face.verts[0].set(f[0]);
            this.face.verts[1].set(f[1]);
            this.face.verts[2].set(f[2]);
            this.face.verts[3].set(f[3]);
            this.face.side = f[0].uv.tex;
            m.renderMicroFace(pos, pass, this.getBounds());
        }
    }

    public void calcSphere(double d, double d2, ArrayList<Vertex5[]> faces) {
        this.renderCurvedSide2(DOWN, NORTH, WEST, 0, d, d2, faces);
        this.renderCurvedSide2(UP, NORTH, EAST, 1, d, d2, faces);
        this.renderCurvedSide(NORTH, EAST, UP, 2, d, d2, faces);
        this.renderCurvedSide(SOUTH, WEST, UP, 3, d, d2, faces);
        this.renderCurvedSide(WEST, NORTH, UP, 4, d, d2, faces);
        this.renderCurvedSide(EAST, SOUTH, UP, 5, d, d2, faces);
    }

    @Override
    public int getLightValue() {
        return 15;
    }

    public void renderCurvedSide(Vector3 forward, Vector3 left, Vector3 up, int side, double d, double d2, ArrayList<Vertex5[]> faces) {
        for (double u = 0.0; u < 1.0; u += d2) {
            for (double v = 0.0; v < 1.0; v += d) {
                Vertex5[] verts = new Vertex5[]{new Vertex5(), new Vertex5(), new Vertex5(), new Vertex5()};
                this.calcVec1(verts[0], forward, left, up, u + d2, v, side);
                this.calcVec1(verts[1], forward, left, up, u + d2, v + d, side);
                this.calcVec1(verts[2], forward, left, up, u, v + d, side);
                this.calcVec1(verts[3], forward, left, up, u, v, side);
                faces.add(verts);
            }
        }
    }

    public void calcVec1(Vertex5 vert, Vector3 forward, Vector3 left, Vector3 up, double u, double v, int side) {
        double a = u - 0.5;
        double dy = (v - 0.5) * this.h;
        double dx = Math.sin(a * Math.PI / 2.0) * Math.sqrt(1.0 - dy * dy);
        double dz = Math.sqrt(1.0 - dx * dx - dy * dy);
        vert.vec.set(left.copy().multiply(dx).add(up.copy().multiply(dy)).add(forward.copy().multiply(dz)).multiply(0.375));
        vert.uv.set(u, 1.0 - v, side);
    }

    public void renderCurvedSide2(Vector3 forward, Vector3 left, Vector3 up, int side, double d, double d2, ArrayList<Vertex5[]> faces) {
        for (double t = 0.0; t < 1.0; t += d2 / 4.0) {
            for (double dr = 0.0; dr < 1.0; dr += d * 2.0) {
                Vertex5[] verts = new Vertex5[]{new Vertex5(), new Vertex5(), new Vertex5(), new Vertex5()};
                this.calcVec2(verts[0], forward, left, up, t, dr, side);
                this.calcVec2(verts[1], forward, left, up, t, dr + d * 2.0, side);
                this.calcVec2(verts[2], forward, left, up, t + d2 / 4.0, dr + d * 2.0, side);
                this.calcVec2(verts[3], forward, left, up, t + d2 / 4.0, dr, side);
                faces.add(verts);
            }
        }
    }

    public void calcVec2(Vertex5 vert, Vector3 forward, Vector3 left, Vector3 up, double t, double dr, int side) {
        double du = Math.cos(t * Math.PI * 2.0) * dr;
        double dv = Math.sin(t * Math.PI * 2.0) * dr;
        double d = du == 0.0 || dv == 0.0 ? 0.0 : Math.min(Math.abs(du / dv), Math.abs(dv / du));
        d = Math.sqrt(1.0 + d * d);
        double dx = du * this.h2;
        double dy = dv * this.h2;
        double dz = Math.sqrt(1.0 - dx * dx - dy * dy);
        vert.vec.set(left.copy().multiply(dx).add(up.copy().multiply(dy)).add(forward.copy().multiply(dz)).multiply(0.375));
        vert.uv.set((1.0 + d * du) / 2.0, (1.0 + d * dv) / 2.0, side);
    }

    static {
        DOWN = new Vector3(0.0, -1.0, 0.0);
        UP = new Vector3(0.0, 1.0, 0.0);
        NORTH = new Vector3(0.0, 0.0, -1.0);
        SOUTH = new Vector3(0.0, 0.0, 1.0);
        EAST = new Vector3(-1.0, 0.0, 0.0);
        WEST = new Vector3(1.0, 0.0, 0.0);
        faces = null;
        faces_inv = null;
    }

    public class BlockFaceUniformLighting
    extends BlockRenderer.BlockFace {
        public void prepareVertex() {
            CCRenderState.side = 1;
        }

        public BlockRenderer.BlockFace computeLightCoords() {
            if (!this.lcComputed) {
                for (int i = 0; i < 4; ++i) {
                    this.lightCoords[i].set(0, 1.0f, 0.0f, 0.0f, 0.0f);
                }
                this.lcComputed = true;
            }
            return this;
        }
    }
}

