/*
 * Decompiled with CFR 0.152.
 */
package com.fiskmods.lightsabers.asm.transformers;

import com.fiskmods.lightsabers.asm.ALLoadingPlugin;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.List;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public abstract class ClassTransformerBase
implements IClassTransformer,
Opcodes {
    public static final Logger LOGGER = LogManager.getFormatterLogger((String)"Advanced Lightsabers");
    protected final String classPath;
    protected final String unobfClass;

    public ClassTransformerBase(String path) {
        this.classPath = path;
        this.unobfClass = path.substring(path.lastIndexOf(46) + 1);
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        try {
            if (transformedName.equals(this.classPath)) {
                LOGGER.info("Patching Class %s (%s)", new Object[]{this.unobfClass, name});
                ClassWriter writer = new ClassWriter(1);
                ClassReader reader = new ClassReader(bytes);
                ClassNode node = new ClassNode();
                reader.accept((ClassVisitor)node, 0);
                this.setupMappings();
                boolean success = this.processFields(node.fields) && this.processMethods(node.methods);
                this.addInterface(node.interfaces);
                node.accept((ClassVisitor)writer);
                if (success) {
                    LOGGER.debug("Patching Class %s done", new Object[]{this.unobfClass});
                } else {
                    LOGGER.error("Patching Class %s FAILED!", new Object[]{this.unobfClass});
                }
                ClassTransformerBase.writeClassFile(writer, String.format("%s (%s)", this.unobfClass, name));
                return writer.toByteArray();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bytes;
    }

    public void addInterface(List<String> interfaces) {
    }

    public abstract boolean processMethods(List<MethodNode> var1);

    public abstract boolean processFields(List<FieldNode> var1);

    public abstract void setupMappings();

    public void sendPatchLog(String method) {
        LOGGER.log(Level.INFO, "\tPatching method %s in %s", new Object[]{method, this.unobfClass});
    }

    public static void writeClassFile(ClassWriter cw, String name) {
        try {
            File outDir = new File("debug/");
            outDir.mkdirs();
            DataOutputStream dout = new DataOutputStream(new FileOutputStream(new File(outDir, name + ".class")));
            dout.write(cw.toByteArray());
            dout.flush();
            dout.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getClassName(String className) {
        return "net/minecraft/" + className.replace(".", "/");
    }

    public static String getMappedName(String name, String devName) {
        return ALLoadingPlugin.obfuscatedEnv ? name : devName;
    }
}

