/*
 * Decompiled with CFR 0.152.
 */
package com.fiskmods.lightsabers.asm.transformers;

import com.fiskmods.lightsabers.asm.ASMHooksClient;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.List;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class ClassTransformerColor
implements IClassTransformer,
Opcodes {
    public byte[] transform(String name, String transformedName, byte[] bytes) {
        try {
            ClassReader cr = new ClassReader(bytes);
            ClassNode cn = new ClassNode();
            cr.accept((ClassVisitor)cn, 0);
            boolean success = this.processMethods(cn.methods);
            ClassWriter cw = new ClassWriter(1);
            cn.accept((ClassVisitor)cw);
            return cw.toByteArray();
        }
        catch (Exception e) {
            if (!(e instanceof NullPointerException)) {
                e.printStackTrace();
            }
            return bytes;
        }
    }

    public boolean processMethods(List<MethodNode> methods) {
        boolean flag = false;
        for (MethodNode method : methods) {
            InsnList list = new InsnList();
            for (int j = 0; j < method.instructions.size(); ++j) {
                AbstractInsnNode node = method.instructions.get(j);
                if (node instanceof MethodInsnNode) {
                    MethodInsnNode methodNode = (MethodInsnNode)node;
                    if (node.getOpcode() == 184 && methodNode.owner.equals("org/lwjgl/opengl/GL11") && (methodNode.name.startsWith("glColor3") || methodNode.name.startsWith("glColor4"))) {
                        list.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(ASMHooksClient.class), methodNode.name, methodNode.desc, false));
                        flag = true;
                        continue;
                    }
                }
                list.add(node);
            }
            method.instructions.clear();
            method.instructions.add(list);
        }
        return flag;
    }

    public static void writeClassFile(ClassWriter cw, String name) {
        try {
            File outDir = new File("debug/glColor/");
            outDir.mkdirs();
            DataOutputStream dout = new DataOutputStream(new FileOutputStream(new File(outDir, name + ".class")));
            dout.write(cw.toByteArray());
            dout.flush();
            dout.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

