/*
 * Decompiled with CFR 0.152.
 */
package com.fiskmods.lightsabers.client.gui;

import com.fiskmods.lightsabers.common.container.ContainerLightsaberForge;
import com.fiskmods.lightsabers.common.container.InventoryLightsaberForge;
import com.fiskmods.lightsabers.common.hilt.Hilt;
import com.fiskmods.lightsabers.common.item.ItemCrystal;
import com.fiskmods.lightsabers.common.item.ItemLightsaberPart;
import com.fiskmods.lightsabers.common.lightsaber.LightsaberData;
import com.fiskmods.lightsabers.common.lightsaber.PartType;
import com.fiskmods.lightsabers.common.tileentity.TileEntityLightsaberForge;
import com.fiskmods.lightsabers.helper.ALRenderHelper;
import com.google.common.collect.Iterables;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiLightsaberForge
extends GuiContainer {
    private static final ResourceLocation GUI_TEXTURES = new ResourceLocation("lightsabers", "textures/gui/container/lightsaber_forge.png");

    public GuiLightsaberForge(InventoryPlayer inventoryPlayer, TileEntityLightsaberForge tile) {
        super((Container)new ContainerLightsaberForge(inventoryPlayer, tile));
        this.field_147000_g = 196;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String s = I18n.func_135052_a((String)"gui.lightsaber_forge", (Object[])new Object[0]);
        this.field_146289_q.func_78276_b(s, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(s) / 2, 6, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 8, this.field_147000_g - 94, 0x404040);
        ContainerLightsaberForge container = (ContainerLightsaberForge)this.field_147002_h;
        InventoryLightsaberForge inventory = container.craftMatrix;
        LightsaberData data = inventory.result;
        if (data != null) {
            if (data.isTooShort()) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_146297_k.func_110434_K().func_110577_a(GUI_TEXTURES);
                this.func_73729_b(131, 65, 176, 0, 26, 17);
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)300.0f);
                this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"gui.lightsaber_forge.too_short", (Object[])new Object[0]), 45, 64 - this.field_146289_q.field_78288_b, 14108744);
            } else {
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)300.0f);
                this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"%s cm", (Object[])new Object[]{ItemStack.field_111284_a.format(data.getHeightCm())}), 45, 64 - this.field_146289_q.field_78288_b, -1);
            }
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-300.0f);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(GUI_TEXTURES);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        ContainerLightsaberForge container = (ContainerLightsaberForge)this.field_147002_h;
        InventoryLightsaberForge inventory = container.craftMatrix;
        LightsaberData data = inventory.result;
        if (data != null) {
            float spin = (float)this.field_146297_k.field_71439_g.field_70173_aa + partialTicks;
            GL11.glEnable((int)32826);
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            GL11.glEnable((int)2903);
            GL11.glPushMatrix();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glTranslatef((float)(this.field_147003_i + 110), (float)(this.field_147009_r + 40), (float)20.0f);
            GL11.glRotatef((float)((float)Math.sin(spin / 20.0f) * 2.5f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)((float)Math.sin(spin / 20.0f + 2.0f) * 2.5f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)(90.0f + spin), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glScalef((float)-20.0f, (float)20.0f, (float)20.0f);
            RenderHelper.func_74520_c();
            ALRenderHelper.startGlScissor(this.field_147003_i + 43, this.field_147009_r + 17, 113, 47);
            ALRenderHelper.renderLightsaber(data, container.craftResult.func_70301_a(0), false);
            ALRenderHelper.endGlScissor();
            RenderHelper.func_74518_a();
            GL11.glPopMatrix();
            RenderHelper.func_74518_a();
        } else {
            Hilt hilt = null;
            for (int slot = 0; slot < 4; ++slot) {
                ItemStack stack = inventory.func_70301_a(slot);
                if (stack == null) continue;
                if (hilt == null || hilt == ItemLightsaberPart.get(stack)) {
                    hilt = ItemLightsaberPart.get(stack);
                    continue;
                }
                hilt = null;
                break;
            }
            if (hilt == null) {
                hilt = (Hilt)Iterables.get(Hilt.REGISTRY, (int)(this.field_146297_k.field_71439_g.field_70173_aa / 20 % Hilt.REGISTRY.func_148742_b().size()));
            }
            ALRenderHelper.setupRenderItemIntoGUI();
            GL11.glColor4f((float)0.6f, (float)0.6f, (float)0.6f, (float)0.125f);
            boolean prevColor = GuiLightsaberForge.field_146296_j.field_77024_a;
            GuiLightsaberForge.field_146296_j.field_77024_a = false;
            if (hilt != null) {
                for (int slot = 0; slot < 4; ++slot) {
                    if (inventory.func_70301_a(slot) != null) continue;
                    int[] pos = ContainerLightsaberForge.SLOTS[slot];
                    field_146296_j.func_82406_b(this.field_146297_k.field_71466_p, this.field_146297_k.func_110434_K(), ItemLightsaberPart.create(PartType.values()[slot], hilt), this.field_147003_i + pos[0], this.field_147009_r + pos[1]);
                }
                if (inventory.func_70301_a(5) == null) {
                    int[] pos = ContainerLightsaberForge.SLOTS[5];
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.25f);
                    field_146296_j.func_82406_b(this.field_146297_k.field_71466_p, this.field_146297_k.func_110434_K(), ItemCrystal.create(hilt.getColor()), this.field_147003_i + pos[0], this.field_147009_r + pos[1]);
                }
            }
            GuiLightsaberForge.field_146296_j.field_77024_a = prevColor;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            ALRenderHelper.finishRenderItemIntoGUI();
        }
    }
}

