/*
 * Decompiled with CFR 0.152.
 */
package com.fiskmods.lightsabers.client.gui;

import com.fiskmods.lightsabers.Lightsabers;
import com.fiskmods.lightsabers.common.data.ALData;
import com.fiskmods.lightsabers.common.data.ALEntityData;
import com.fiskmods.lightsabers.common.data.ALPlayerData;
import com.fiskmods.lightsabers.common.data.effect.Effect;
import com.fiskmods.lightsabers.common.data.effect.StatusEffect;
import com.fiskmods.lightsabers.common.force.Power;
import com.fiskmods.lightsabers.common.force.effect.PowerEffect;
import com.fiskmods.lightsabers.common.force.effect.PowerEffectActive;
import com.fiskmods.lightsabers.helper.ALHelper;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.awt.Rectangle;
import java.util.List;
import mods.battlegear2.utils.BattlegearConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.util.StringUtils;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.opengl.GL11;

public class GuiOverlay
extends Gui {
    private Minecraft mc = Minecraft.func_71410_x();
    public static final ResourceLocation ICONS = new ResourceLocation("lightsabers", "textures/gui/icons.png");
    public static final ResourceLocation WIDGETS = new ResourceLocation("lightsabers", "textures/gui/widgets.png");

    @SubscribeEvent
    public void onRenderGameOverlayPre(RenderGameOverlayEvent.Pre event) {
        ScaledResolution res = event.resolution;
        EntityClientPlayerMP player = this.mc.field_71439_g;
        int width = res.func_78326_a();
        int height = res.func_78328_b();
        if (event.type == RenderGameOverlayEvent.ElementType.EXPERIENCE || event.type == RenderGameOverlayEvent.ElementType.JUMPBAR) {
            if (ALHelper.getForcePowerMax((EntityPlayer)player) > 0) {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)0.0f, (float)-6.0f, (float)0.0f);
            }
        } else if (event.type == RenderGameOverlayEvent.ElementType.ALL) {
            if (this.mc.field_71474_y.field_74320_O == 0) {
                GL11.glPushMatrix();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.5f);
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                for (StatusEffect status : ALEntityData.getData((EntityLivingBase)player).activeEffects) {
                    Power power = status.effect.getPower(status.amplifier);
                    PowerEffect powerEffect = power.powerEffect;
                    if (!(powerEffect instanceof PowerEffectActive)) continue;
                    ((PowerEffectActive)powerEffect).render((EntityPlayer)player, event.partialTicks);
                }
                GL11.glPopMatrix();
            }
            if (ALHelper.getForcePowerMax((EntityPlayer)player) > 0 && GuiIngameForge.renderExperiance) {
                GuiIngameForge.left_height += 6;
                GuiIngameForge.right_height += 6;
            }
        }
    }

    @SubscribeEvent
    public void onRenderGameOverlayPost(RenderGameOverlayEvent.Post event) {
        ScaledResolution res = event.resolution;
        EntityClientPlayerMP player = this.mc.field_71439_g;
        int width = res.func_78326_a();
        int height = res.func_78328_b();
        if (event.type == RenderGameOverlayEvent.ElementType.EXPERIENCE || event.type == RenderGameOverlayEvent.ElementType.JUMPBAR) {
            if (ALHelper.getForcePowerMax((EntityPlayer)player) > 0) {
                GL11.glPopMatrix();
            }
        } else if (event.type == RenderGameOverlayEvent.ElementType.HOTBAR) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.renderForceBar(event, width, height, (EntityPlayer)player);
            this.renderPowerSelector(event, width, height, (EntityPlayer)player);
            this.renderStatusEffects(event, width, height, (EntityPlayer)player);
        }
    }

    public void renderForceBar(RenderGameOverlayEvent.Post event, int width, int height, EntityPlayer player) {
        this.mc.func_110434_K().func_110577_a(ICONS);
        int cap = ALHelper.getForcePowerMax(player);
        int left = width / 2 - 91;
        int top = height - 32 + 3;
        if (cap > 0) {
            int barWidth = 182;
            int filled = (int)(ALData.FORCE_POWER.interpolate((Entity)player).floatValue() / (float)cap * (float)barWidth);
            int filledDiff = (int)(ALData.FORCE_POWER_DIFF.interpolate((Entity)player).floatValue() / (float)cap * (float)barWidth);
            GL11.glEnable((int)3042);
            this.func_73729_b(left, top, 0, 74, barWidth, 5);
            if (filledDiff > filled && filledDiff > 0) {
                this.func_73729_b(left, top, 0, 79, filledDiff, 5);
            }
            if (filled > 0) {
                this.func_73729_b(left, top, 0, 84, filled, 5);
            }
            String s = MathHelper.func_76141_d((float)((Float)ALData.FORCE_POWER.get((Entity)player)).floatValue()) + "/" + cap;
            boolean prevUnicode = this.mc.field_71466_p.func_82883_a();
            this.mc.field_71466_p.func_78264_a(true);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(left + barWidth / 2 - this.mc.field_71466_p.func_78256_a(s) / 2), (float)(top - 2), (float)0.0f);
            this.mc.field_71466_p.func_78276_b(s, 1, 0, 0);
            this.mc.field_71466_p.func_78276_b(s, -1, 0, 0);
            this.mc.field_71466_p.func_78276_b(s, 0, 1, 0);
            this.mc.field_71466_p.func_78276_b(s, 0, -1, 0);
            for (int i = 0; i < 4; ++i) {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)(i == 0 ? 0.5f : (i == 1 ? -0.5f : 0.0f)), (float)(i == 2 ? 0.5f : (i == 3 ? -0.5f : 0.0f)), (float)0.0f);
                this.mc.field_71466_p.func_78276_b(s, 0, 0, 0x404040);
                GL11.glPopMatrix();
            }
            this.mc.field_71466_p.func_78276_b(s, 0, 0, -1);
            this.mc.field_71466_p.func_78264_a(prevUnicode);
            GL11.glDisable((int)3042);
            GL11.glPopMatrix();
        }
    }

    public void renderPowerSelector(RenderGameOverlayEvent.Post event, int width, int height, EntityPlayer player) {
        this.mc.func_110434_K().func_110577_a(WIDGETS);
        int left = width / 2 - 184;
        int top = height - 22;
        if (ALHelper.getForcePowerMax(player) > 0) {
            ALPlayerData data = ALPlayerData.getData(player);
            byte selected = ALData.SELECTED_POWER.get((Entity)player);
            if (Lightsabers.isBattlegearLoaded) {
                BattlegearConfig config = new BattlegearConfig();
                if (new Rectangle(left + BattlegearConfig.battleBarOffset[0], top + BattlegearConfig.battleBarOffset[1], 62, 22).intersects(left, top, 62.0, 22.0)) {
                    left += BattlegearConfig.battleBarOffset[0];
                    top += BattlegearConfig.battleBarOffset[1] - 25;
                }
            }
            GL11.glEnable((int)3042);
            this.func_73729_b(left, top, 0, 0, 62, 22);
            this.mc.func_110434_K().func_110577_a(ICONS);
            List<Power> selectedPowers = ALData.SELECTED_POWERS.get((Entity)player);
            for (int i = 0; i < selectedPowers.size(); ++i) {
                Power power;
                if (i > 2 || (power = selectedPowers.get(i)) == null || !power.hasIcon()) continue;
                this.func_73729_b(left + 3 + i * 20, top + 3, power.getIconX() * 16, power.getIconY() * 16, 16, 16);
            }
            this.mc.func_110434_K().func_110577_a(WIDGETS);
            this.func_73729_b(left - 1 + selected * 20, top - 1, 0, 22, 24, 24);
            GL11.glDisable((int)3042);
        }
    }

    public void renderStatusEffects(RenderGameOverlayEvent.Post event, int width, int height, EntityPlayer player) {
        GL11.glEnable((int)3042);
        ALEntityData data = ALEntityData.getData((EntityLivingBase)player);
        int left = width - 3;
        int top = height - 28;
        boolean prevUnicodeFlag = this.mc.field_71466_p.func_82883_a();
        this.mc.field_71466_p.func_78264_a(true);
        for (int i = 0; i < data.activeEffects.size(); ++i) {
            Power power;
            StatusEffect status = data.activeEffects.get(i);
            Effect e = status.effect;
            if (status.duration < 0) continue;
            this.mc.func_110434_K().func_110577_a(ICONS);
            this.func_73729_b(left - 26, top - 26 - 28 * i, 0, 48, 26, 26);
            if (e == null || (power = e.getPower(status.amplifier)) == null) continue;
            if (power.hasIcon()) {
                this.func_73729_b(left - 21, top - 21 - 28 * i, power.getIconX() * 16, power.getIconY() * 16, 16, 16);
            }
            String s = e.getLocalizedName();
            String s1 = StringUtils.func_76337_a((int)status.duration);
            if (status.amplifier > 0 && status.amplifier < 10) {
                s = s + " " + StatCollector.func_74838_a((String)("enchantment.level." + (status.amplifier + 1)));
            }
            this.func_73731_b(this.mc.field_71466_p, s, left - 30 - this.mc.field_71466_p.func_78256_a(s), top - 22 - 28 * i, -1);
            this.func_73731_b(this.mc.field_71466_p, s1, left - 30 - this.mc.field_71466_p.func_78256_a(s1), top - 13 - 28 * i, -1);
        }
        this.mc.field_71466_p.func_78264_a(prevUnicodeFlag);
        GL11.glDisable((int)3042);
    }
}

