/*
 * Decompiled with CFR 0.152.
 */
package com.fiskmods.lightsabers.client.gui;

import com.fiskmods.lightsabers.client.gui.GuiOverlay;
import com.fiskmods.lightsabers.common.data.ALData;
import com.fiskmods.lightsabers.common.force.Power;
import com.fiskmods.lightsabers.common.force.PowerData;
import com.fiskmods.lightsabers.common.force.PowerStats;
import com.fiskmods.lightsabers.common.force.PowerType;
import com.fiskmods.lightsabers.helper.ALHelper;
import com.google.common.collect.Lists;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiSelectPowers
extends GuiScreen {
    public static final ResourceLocation GUI_TEXTURES = new ResourceLocation("lightsabers", "textures/gui/container/force_power_selector.png");
    protected int xSize = 176;
    protected int ySize = 166;
    public int grabbedId = -1;
    public int grabbedOffsetX;
    public int grabbedOffsetY;
    public List<PowerSlot> slots = new ArrayList<PowerSlot>();
    public Power[] selectedPowers = new Power[3];

    public void func_73866_w_() {
        super.func_73866_w_();
        this.slots.clear();
        this.selectedPowers = ALData.SELECTED_POWERS.get((Entity)this.field_146297_k.field_71439_g).toArray(this.selectedPowers);
        List<PowerData> list = ALHelper.getRelevantPowers((EntityPlayer)this.field_146297_k.field_71439_g);
        Collections.sort(list);
        PowerData[] powers = list.toArray(new PowerData[16]);
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 4; ++y) {
                PowerData data = powers[y + x * 4];
                this.slots.add(new PowerSlot(data != null ? data.power : null, y + x * 4, 8 + y * 18, 8 + x * 18));
            }
        }
    }

    protected void func_73869_a(char c, int key) {
        super.func_73869_a(c, key);
        if (key == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i()) {
            this.field_146297_k.func_147108_a((GuiScreen)null);
            this.field_146297_k.func_71381_h();
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int button) {
        super.func_73864_a(mouseX, mouseY, button);
        int x = (this.field_146294_l - this.xSize) / 2;
        int y = (this.field_146295_m - this.ySize) / 2;
        boolean flag = false;
        if (button == 0 && GuiSelectPowers.func_146272_n()) {
            int i;
            ArrayList indexes = Lists.newArrayList();
            for (i = 0; i < this.selectedPowers.length; ++i) {
                if (this.selectedPowers[i] != null) continue;
                indexes.add(i);
            }
            if (!indexes.isEmpty() && this.grabbedId < 0) {
                for (PowerSlot slot : this.slots) {
                    int x1 = x + slot.x;
                    int y1 = y + slot.y;
                    if (slot.power == null || !new Rectangle(x1 - 1, y1 - 1, 18, 18).contains(mouseX, mouseY)) continue;
                    this.selectedPowers[((Integer)indexes.get((int)0)).intValue()] = slot.power;
                    flag = true;
                }
            }
            if (this.grabbedId < 0) {
                for (i = 0; i < 3; ++i) {
                    if (this.selectedPowers[i] == null || !new Rectangle(x + 62 + i * 18, y + 142, 16, 16).contains(mouseX, mouseY)) continue;
                    this.selectedPowers[i] = null;
                    flag = true;
                }
            }
        }
        if (flag) {
            ALData.SELECTED_POWERS.setWithoutNotify((Entity)this.field_146297_k.field_71439_g, Lists.newArrayList((Object[])this.selectedPowers));
        }
    }

    protected void func_146273_a(int mouseX, int mouseY, int button, long time) {
        super.func_146273_a(mouseX, mouseY, button, time);
        int x = (this.field_146294_l - this.xSize) / 2;
        int y = (this.field_146295_m - this.ySize) / 2;
        if (button == 0 && this.grabbedId < 0) {
            for (PowerSlot slot : this.slots) {
                int x1 = x + slot.x;
                int y1 = y + slot.y;
                if (slot.power == null || !new Rectangle(x1 - 1, y1 - 1, 18, 18).contains(mouseX, mouseY)) continue;
                this.grabbedId = slot.id;
                this.grabbedOffsetX = x1 - mouseX;
                this.grabbedOffsetY = y1 - mouseY;
            }
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int signature) {
        super.func_146286_b(mouseX, mouseY, signature);
        int x = (this.field_146294_l - this.xSize) / 2;
        int y = (this.field_146295_m - this.ySize) / 2;
        if (signature == 0) {
            if (this.grabbedId >= 0) {
                for (int i = 0; i < 3; ++i) {
                    PowerSlot slot;
                    if (!new Rectangle(x + 62 + i * 18, y + 142, 16, 16).contains(mouseX, mouseY) || (slot = this.slots.get(this.grabbedId)) == null) continue;
                    this.selectedPowers[i] = slot.power;
                    ALData.SELECTED_POWERS.setWithoutNotify((Entity)this.field_146297_k.field_71439_g, Lists.newArrayList((Object[])this.selectedPowers));
                }
            }
            this.grabbedId = -1;
        }
    }

    public PowerSlot getSlotFor(Power power) {
        for (PowerSlot slot : this.slots) {
            if (slot.power != power) continue;
            return slot;
        }
        return null;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        GL11.glEnable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(GUI_TEXTURES);
        int x = (this.field_146294_l - this.xSize) / 2;
        int y = (this.field_146295_m - this.ySize) / 2;
        this.func_73729_b(x, y, 0, 0, this.xSize, this.ySize);
        this.field_146297_k.func_110434_K().func_110577_a(GuiOverlay.ICONS);
        Power grabPower = null;
        Power hoverPower = null;
        for (PowerSlot slot : this.slots) {
            Power power = slot.power;
            int x1 = x + slot.x;
            int y1 = y + slot.y;
            if (power != null) {
                if (power.hasIcon()) {
                    this.func_73729_b(x1, y1, power.getIconX() * 16, power.getIconY() * 16, 16, 16);
                }
                if (this.grabbedId == slot.id) {
                    grabPower = power;
                }
            }
            if (!new Rectangle(x1 - 1, y1 - 1, 18, 18).contains(mouseX, mouseY)) continue;
            GL11.glDisable((int)2929);
            GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            this.func_73733_a(x1, y1, x1 + 16, y1 + 16, -2130706433, -2130706433);
            GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GL11.glEnable((int)2929);
            GL11.glEnable((int)3042);
            hoverPower = power;
        }
        int grabX = mouseX + this.grabbedOffsetX;
        int grabY = mouseY + this.grabbedOffsetY;
        for (int i = 0; i < this.selectedPowers.length; ++i) {
            Power power = this.selectedPowers[i];
            int x1 = x + 62 + i * 18;
            int y1 = y + 142;
            boolean flag = new Rectangle(x1 - 1, y1 - 1, 18, 18).contains(mouseX, mouseY);
            if (flag) {
                grabX = x1;
                grabY = y1;
            }
            if (power != null && power.hasIcon() && (grabX != x1 || grabY != y1 || grabPower == null)) {
                this.func_73729_b(x1, y1, power.getIconX() * 16, power.getIconY() * 16, 16, 16);
            }
            if (!flag) continue;
            GL11.glDisable((int)2929);
            GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            this.func_73733_a(x1, y1, x1 + 16, y1 + 16, -2130706433, -2130706433);
            GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GL11.glEnable((int)2929);
            GL11.glEnable((int)3042);
            hoverPower = power;
        }
        if (hoverPower != null) {
            Tessellator tessellator = Tessellator.field_78398_a;
            float f = 0.00390625f;
            float scale = 70.0f;
            if (hoverPower.hasIcon()) {
                TextureUtil.func_152777_a((boolean)false, (boolean)false, (float)1.0f);
                GL11.glPushMatrix();
                GL11.glEnable((int)32826);
                GL11.glTranslatef((float)(x + 126), (float)((float)y + 60.5f), (float)(this.field_73735_i + 20.0f));
                GL11.glScalef((float)scale, (float)(-scale), (float)(-scale));
                GL11.glTranslatef((float)-0.5f, (float)-0.25f, (float)-0.0421875f);
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.084375f);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                ItemRenderer.func_78439_a((Tessellator)tessellator, (float)((float)(hoverPower.getIconX() * 16) * f), (float)((float)(hoverPower.getIconY() * 16) * f), (float)((float)(hoverPower.getIconX() * 16 + 16) * f), (float)((float)(hoverPower.getIconY() * 16 + 16) * f), (int)16, (int)16, (float)0.0f);
                GL11.glDisable((int)32826);
                GL11.glPopMatrix();
                TextureUtil.func_147945_b();
            }
            String name = hoverPower.getLocalizedName();
            int x1 = x + 8;
            int y1 = y + 84;
            int fieldWidth = Math.max(this.field_146289_q.func_78256_a(name), 160);
            ArrayList list = Lists.newArrayList();
            PowerStats stats = hoverPower.powerStats;
            if (hoverPower.powerEffect != null) {
                String[] astring = hoverPower.powerEffect.getDesc();
                for (String s : astring) {
                    list.add(s);
                }
            }
            for (String desc : list) {
                fieldWidth = Math.max(this.field_146289_q.func_78256_a(desc), fieldWidth);
            }
            this.func_73733_a(x1, y1, x1 + fieldWidth, y1 + Math.max((this.field_146289_q.field_78288_b + 2) * list.size() + this.field_146289_q.field_78288_b * 2 + 12, 52), -1524489694, -1524489694);
            int height = y1 + this.field_146289_q.field_78288_b + 4;
            if (name != null) {
                this.field_146289_q.func_78261_a(name, x1 + 3, y1 + 3, -1);
            }
            if (stats.useCost > 0.0f) {
                this.field_146289_q.func_78261_a(I18n.func_135052_a((String)(stats.powerType == PowerType.PER_USE ? "forcepower.perUse" : "forcepower.perSecond"), (Object[])new Object[]{ItemStack.field_111284_a.format(stats.useCost)}), x1 + 3, height + 3, 0xA4A4A4);
                height += 5 + this.field_146289_q.field_78288_b;
            }
            for (String desc : list) {
                this.field_146289_q.func_78261_a(desc, x1 + 3, height + 3, 0xA4A4A4);
                height += 2 + this.field_146289_q.field_78288_b;
            }
            GL11.glEnable((int)3042);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (grabPower != null && grabPower.hasIcon()) {
            this.field_146297_k.func_110434_K().func_110577_a(GuiOverlay.ICONS);
            this.func_73729_b(grabX, grabY, grabPower.getIconX() * 16, grabPower.getIconY() * 16, 16, 16);
        }
        GL11.glDisable((int)3042);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_146281_b() {
        ALData.SELECTED_POWERS.sync((EntityPlayer)this.field_146297_k.field_71439_g);
    }

    private class PowerSlot {
        public Power power;
        public int id;
        public int x;
        public int y;

        public PowerSlot(Power power, int id, int x, int y) {
            this.power = power;
            this.id = id;
            this.x = x;
            this.y = y;
        }
    }
}

