/*
 * Decompiled with CFR 0.152.
 */
package com.fiskmods.lightsabers.client.model;

import com.fiskmods.lightsabers.common.config.ModConfig;
import com.fiskmods.lightsabers.common.lightsaber.FocusingCrystal;
import com.fiskmods.lightsabers.common.lightsaber.LightsaberData;
import com.fiskmods.lightsabers.helper.ALRenderHelper;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class ModelLightsaberBlade
extends ModelBase {
    public ModelRenderer blade;
    public int bladeLength;

    public ModelLightsaberBlade(int length) {
        this.field_78090_t = 64;
        this.field_78089_u = 32;
        this.blade = new ModelRenderer((ModelBase)this, 0, 0);
        this.blade.func_78789_a(-0.5f, (float)(-length), -0.5f, 1, length, 1);
        this.bladeLength = length;
    }

    public void renderInner(LightsaberData data, ItemStack stack, float[] rgb, boolean inWorld, boolean isCrossguard) {
        boolean fineCut = data.hasFocusingCrystal(FocusingCrystal.FINE_CUT);
        if (isCrossguard && fineCut) {
            GL11.glScalef((float)1.0f, (float)1.2f, (float)1.0f);
        }
        if (data.hasFocusingCrystal(FocusingCrystal.INVERTING)) {
            GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        } else if (data.hasFocusingCrystal(FocusingCrystal.PRISMATIC)) {
            GL11.glColor4f((float)rgb[0], (float)rgb[1], (float)rgb[2], (float)1.0f);
        } else {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (data.hasFocusingCrystal(FocusingCrystal.COMPRESSED)) {
            GL11.glScalef((float)0.6f, (float)1.0f, (float)0.6f);
        }
        if (data.hasFocusingCrystal(FocusingCrystal.CRACKED)) {
            float divider = 60.0f;
            int ticks = Minecraft.func_71410_x().field_71439_g.field_70173_aa;
            Random rand = new Random(ticks % 100 * 1000);
            Random prev = new Random((ticks - 1) % 100 * 1000);
            Supplier<Float> nextFloat = () -> Float.valueOf(ALRenderHelper.median(rand.nextFloat(), prev.nextFloat()));
            for (int i = 0; i < 4; ++i) {
                GL11.glPushMatrix();
                if (i != 0) {
                    GL11.glTranslatef((float)((nextFloat.get().floatValue() - 0.5f) / divider), (float)0.0f, (float)((nextFloat.get().floatValue() - 0.5f) / divider));
                    for (int j = 0; j < this.bladeLength; ++j) {
                        GL11.glPushMatrix();
                        GL11.glRotatef((float)(nextFloat.get().floatValue() * 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                        GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                        GL11.glTranslatef((float)0.0f, (float)(0.05f - (1.0f - nextFloat.get().floatValue() * 0.2f) / 16.0f), (float)((1.0f + nextFloat.get().floatValue() * (float)this.bladeLength) / 16.0f));
                        ALRenderHelper.drawTip(0.04f, 0.0f);
                        GL11.glPopMatrix();
                    }
                }
                if (!fineCut) {
                    this.blade.func_78785_a(0.0625f);
                    GL11.glTranslatef((float)0.0f, (float)(-(0.5f + (float)this.bladeLength) / 16.0f), (float)0.03125f);
                    ALRenderHelper.drawTip(0.03125f, 0.125f);
                }
                GL11.glPopMatrix();
            }
        }
        if (fineCut) {
            Tessellator tessellator = Tessellator.field_78398_a;
            float f = 0.0625f;
            float length = f * (float)this.bladeLength * 0.7f;
            float edge = f * 1.5f;
            float edgeAngle = -f * 1.5f;
            float length1 = f * (float)this.bladeLength * 0.3f;
            float edge1 = f / 2.0f;
            float tip = f * 1.5f;
            tessellator.func_78382_b();
            tessellator.func_78377_a((double)(-f / 2.0f), (double)(-length), (double)(f / 2.0f));
            tessellator.func_78377_a(0.0, (double)(-length), (double)edge);
            tessellator.func_78377_a(0.0, (double)edgeAngle, (double)edge);
            tessellator.func_78377_a((double)(-f / 2.0f), (double)(-f), (double)(f / 2.0f));
            tessellator.func_78377_a((double)(f / 2.0f), (double)(-length), (double)(f / 2.0f));
            tessellator.func_78377_a(0.0, (double)(-length), (double)edge);
            tessellator.func_78377_a(0.0, (double)edgeAngle, (double)edge);
            tessellator.func_78377_a((double)(f / 2.0f), (double)(-f), (double)(f / 2.0f));
            tessellator.func_78377_a((double)(f / 2.0f), (double)(-f), (double)(f / 2.0f));
            tessellator.func_78377_a(0.0, (double)edgeAngle, (double)edge);
            tessellator.func_78377_a(0.0, (double)edgeAngle, (double)edge);
            tessellator.func_78377_a((double)(-f / 2.0f), (double)(-f), (double)(f / 2.0f));
            tessellator.func_78377_a((double)(-f / 2.0f), (double)(0.0f - length), (double)(f / 2.0f));
            tessellator.func_78377_a((double)(-f / 2.0f), (double)(-length1 - length), (double)edge1);
            tessellator.func_78377_a(0.0, (double)(-length1 - length), (double)edge1);
            tessellator.func_78377_a(0.0, (double)(0.0f - length), (double)edge);
            tessellator.func_78377_a((double)(f / 2.0f), (double)(0.0f - length), (double)(f / 2.0f));
            tessellator.func_78377_a((double)(f / 2.0f), (double)(-length1 - length), (double)edge1);
            tessellator.func_78377_a(0.0, (double)(-length1 - length), (double)edge1);
            tessellator.func_78377_a(0.0, (double)(0.0f - length), (double)edge);
            tessellator.func_78377_a((double)(-f / 2.0f), (double)(0.0f - f * (float)this.bladeLength), (double)(f / 2.0f));
            tessellator.func_78377_a(0.0, (double)(-tip - f * (float)this.bladeLength), (double)(-f / 2.0f));
            tessellator.func_78377_a(0.0, (double)(-tip - f * (float)this.bladeLength), (double)(-f / 2.0f));
            tessellator.func_78377_a((double)(-f / 2.0f), (double)(0.0f - f * (float)this.bladeLength), (double)(-f / 2.0f));
            tessellator.func_78377_a((double)(f / 2.0f), (double)(0.0f - f * (float)this.bladeLength), (double)(f / 2.0f));
            tessellator.func_78377_a(0.0, (double)(-tip - f * (float)this.bladeLength), (double)(-f / 2.0f));
            tessellator.func_78377_a(0.0, (double)(-tip - f * (float)this.bladeLength), (double)(-f / 2.0f));
            tessellator.func_78377_a((double)(f / 2.0f), (double)(0.0f - f * (float)this.bladeLength), (double)(-f / 2.0f));
            tessellator.func_78377_a((double)(-f / 2.0f), (double)(0.0f - f * (float)this.bladeLength), (double)(-f / 2.0f));
            tessellator.func_78377_a(0.0, (double)(-tip - f * (float)this.bladeLength), (double)(-f / 2.0f));
            tessellator.func_78377_a(0.0, (double)(-tip - f * (float)this.bladeLength), (double)(-f / 2.0f));
            tessellator.func_78377_a((double)(f / 2.0f), (double)(0.0f - f * (float)this.bladeLength), (double)(-f / 2.0f));
            tessellator.func_78377_a((double)(-f / 2.0f), (double)(0.0f - f * (float)this.bladeLength), (double)(f / 2.0f));
            tessellator.func_78377_a(0.0, (double)(-tip - f * (float)this.bladeLength), (double)(-f / 2.0f));
            tessellator.func_78377_a(0.0, (double)(-tip - f * (float)this.bladeLength), (double)(-f / 2.0f));
            tessellator.func_78377_a((double)(f / 2.0f), (double)(0.0f - f * (float)this.bladeLength), (double)(f / 2.0f));
            tessellator.func_78381_a();
            this.blade.func_78785_a(0.0625f);
        } else {
            this.blade.func_78785_a(0.0625f);
            GL11.glTranslatef((float)0.0f, (float)(-0.0625f * (0.5f + (float)this.bladeLength)), (float)0.03125f);
            ALRenderHelper.drawTip(0.03125f, 0.125f);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void renderOuter(LightsaberData data, ItemStack itemstack, float[] rgb, boolean inWorld) {
        boolean fineCut = data.hasFocusingCrystal(FocusingCrystal.FINE_CUT);
        int smooth = 10;
        float width = 0.6f;
        float f = 1.0f;
        float f1 = 1.0f;
        float f2 = 1.0f;
        float f3 = 0.1f;
        if (data.hasFocusingCrystal(FocusingCrystal.COMPRESSED)) {
            width = 0.4f;
            smooth = 7;
            f3 = 0.07f;
        }
        if (data.hasFocusingCrystal(FocusingCrystal.INVERTING) && data.hasFocusingCrystal(FocusingCrystal.PRISMATIC)) {
            rgb = new float[3];
            f3 *= 1.5f;
            GL11.glBlendFunc((int)770, (int)771);
        }
        if (fineCut) {
            f *= 0.55f;
            f1 *= 0.925f;
            f2 *= 1.1f;
        }
        if (inWorld) {
            width *= ModConfig.renderGlobalMultiplier * ModConfig.renderWidthMultiplier;
            smooth = (int)((float)smooth * (ModConfig.renderGlobalMultiplier * ModConfig.renderSmoothingMultiplier));
        }
        if (itemstack.func_82833_r().equals("jeb_")) {
            smooth = (int)((float)smooth * 0.25f);
        }
        int layerCount = 5 * smooth;
        float opacityMultiplier = inWorld ? ModConfig.renderGlobalMultiplier * ModConfig.renderOpacityMultiplier : 1.0f;
        for (int i = 0; i < layerCount; ++i) {
            GL11.glColor4f((float)rgb[0], (float)rgb[1], (float)rgb[2], (float)(f3 / (float)smooth * opacityMultiplier));
            float scale = 1.0f + (float)i * (width / (float)smooth);
            float f4 = (float)i / (float)layerCount * 50.0f;
            GL11.glPushMatrix();
            GL11.glScaled((double)(scale * f), (double)((1.0f - f4 * (fineCut ? 0.003f : 0.005f) + 0.2f) * f1), (double)(scale * f2));
            GL11.glTranslatef((float)0.0f, (float)(-f4 / 400.0f + 0.06f), (float)0.0f);
            if (fineCut) {
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(0.005f + f4 * 1.0E-5f));
            }
            this.blade.func_78785_a(0.0625f);
            GL11.glPopMatrix();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void renderCrossguardOuter(LightsaberData data, ItemStack itemstack, float[] rgb, boolean inWorld) {
        boolean fineCut = data.hasFocusingCrystal(FocusingCrystal.FINE_CUT);
        int smooth = 10;
        float width = 0.4f;
        float f = 1.0f;
        float f1 = 1.0f;
        float f2 = 1.0f;
        float f3 = 0.1f;
        if (data.hasFocusingCrystal(FocusingCrystal.INVERTING) && data.hasFocusingCrystal(FocusingCrystal.PRISMATIC)) {
            rgb = new float[3];
            GL11.glBlendFunc((int)770, (int)771);
        }
        if (data.hasFocusingCrystal(FocusingCrystal.COMPRESSED)) {
            width = 0.2f;
            smooth = 7;
            f1 = 0.9f;
            f3 = 0.07f;
        }
        if (fineCut) {
            f *= 0.55f;
            f1 *= 0.925f;
            f2 *= 1.3f;
        }
        if (inWorld) {
            width *= ModConfig.renderGlobalMultiplier * ModConfig.renderWidthMultiplier;
            smooth = (int)((float)smooth * (ModConfig.renderGlobalMultiplier * ModConfig.renderSmoothingMultiplier));
        }
        if (itemstack.func_82833_r().equals("jeb_")) {
            smooth = (int)((float)smooth * 0.25f);
        }
        int layerCount = 5 * smooth;
        for (int i = 0; i < layerCount; ++i) {
            GL11.glColor4f((float)rgb[0], (float)rgb[1], (float)rgb[2], (float)(f3 / (float)smooth * (inWorld ? ModConfig.renderGlobalMultiplier * ModConfig.renderOpacityMultiplier : 1.0f)));
            float scale = 1.0f + (float)i * (width / (float)smooth);
            float f4 = (float)i / (float)layerCount * 50.0f;
            GL11.glPushMatrix();
            GL11.glScaled((double)(scale * f), (double)((1.0f - f4 * 0.05f + 2.0f) * f1), (double)(scale * f2));
            GL11.glTranslatef((float)0.0f, (float)(-f4 / 400.0f + 0.06f), (float)0.0f);
            if (fineCut) {
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(0.005f + f4 * 1.0E-5f));
            }
            this.blade.func_78785_a(0.0625f);
            GL11.glPopMatrix();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

