/*
 * Decompiled with CFR 0.152.
 */
package com.fiskmods.lightsabers.client.render.hilt;

import com.fiskmods.lightsabers.common.hilt.Hilt;
import com.fiskmods.lightsabers.common.lightsaber.PartType;
import fiskfille.utils.registry.FiskRegistryEntry;
import fiskfille.utils.registry.FiskSimpleRegistry;
import net.minecraft.client.model.ModelBase;
import net.minecraft.util.ResourceLocation;

public abstract class HiltRenderer
extends FiskRegistryEntry<HiltRenderer> {
    public static final FiskSimpleRegistry<HiltRenderer> REGISTRY = new FiskSimpleRegistry("lightsabers", "graflex");

    public static void register(String key, HiltRenderer value) {
        REGISTRY.putObject(key, value);
    }

    public static void register(Hilt key, HiltRenderer value) {
        HiltRenderer.register(key.delegate.name(), value);
    }

    public static HiltRenderer get(String key) {
        return REGISTRY.getObject(key);
    }

    public static HiltRenderer get(Hilt key) {
        return key == null ? null : HiltRenderer.get(key.delegate.name());
    }

    public abstract ModelBase getEmitter();

    public abstract ModelBase getSwitchSection();

    public abstract ModelBase getBody();

    public abstract ModelBase getPommel();

    public ModelBase getModel(PartType type) {
        switch (type) {
            case EMITTER: {
                return this.getEmitter();
            }
            case SWITCH_SECTION: {
                return this.getSwitchSection();
            }
            case BODY: {
                return this.getBody();
            }
        }
        return this.getPommel();
    }

    public ResourceLocation getTexture(PartType type) {
        return new ResourceLocation(this.getDomain(), String.format("textures/models/lightsaber/%s_%s.png", type.textureName, this.getRegistryName().func_110623_a()));
    }

    public final Hilt getHilt() {
        return (Hilt)Hilt.REGISTRY.getObject(this.delegate.name());
    }
}

