/*
 * Decompiled with CFR 0.152.
 */
package com.fiskmods.lightsabers.client.render.item;

import com.fiskmods.lightsabers.client.render.hilt.HiltRenderer;
import com.fiskmods.lightsabers.common.hilt.Hilt;
import com.fiskmods.lightsabers.common.item.ItemLightsaberPart;
import com.fiskmods.lightsabers.common.lightsaber.PartType;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class RenderItemLightsaberPart
implements IItemRenderer {
    public PartType partType;

    public RenderItemLightsaberPart(PartType type) {
        this.partType = type;
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type == IItemRenderer.ItemRenderType.ENTITY || type == IItemRenderer.ItemRenderType.INVENTORY;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack itemstack, Object ... data) {
        Hilt hilt = ItemLightsaberPart.get(itemstack);
        HiltRenderer renderer = HiltRenderer.get(hilt);
        float scale = 0.4f;
        float height = hilt.getPart((PartType)this.partType).height;
        float f = height * (float)(this.partType.isLowerPart() ? -1 : 1) / 2.0f * 0.0625f;
        GL11.glPushMatrix();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(renderer.getTexture(this.partType));
        if (type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            GL11.glRotatef((float)-100.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)-150.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)5.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)0.0f, (float)0.15f, (float)0.9f);
        } else if (type == IItemRenderer.ItemRenderType.EQUIPPED) {
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)-150.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)0.1f, (float)0.15f, (float)0.475f);
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)-20.0f, (float)0.0f, (float)1.0f, (float)1.0f);
            GL11.glRotatef((float)-10.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        } else if (type == IItemRenderer.ItemRenderType.ENTITY) {
            GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        } else if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            GL11.glRotatef((float)-20.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)-45.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)0.05f, (float)0.0f);
            GL11.glRotatef((float)-110.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            scale = this.partType == PartType.POMMEL && height <= 4.0f ? 2.0f : 1.0f;
            if (height * scale > 20.0f) {
                scale = 20.0f / height;
            }
        }
        if (scale != 1.0f) {
            GL11.glScalef((float)scale, (float)scale, (float)scale);
        }
        GL11.glTranslatef((float)0.0f, (float)f, (float)0.0f);
        renderer.getModel(this.partType).func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        GL11.glPopMatrix();
    }
}

