/*
 * Decompiled with CFR 0.152.
 */
package com.fiskmods.lightsabers.client.render.tile;

import com.fiskmods.lightsabers.client.model.tile.ModelLightsaberStand;
import com.fiskmods.lightsabers.common.item.ItemDoubleLightsaber;
import com.fiskmods.lightsabers.common.item.ItemLightsaber;
import com.fiskmods.lightsabers.common.lightsaber.LightsaberData;
import com.fiskmods.lightsabers.common.tileentity.TileEntityLightsaberStand;
import com.fiskmods.lightsabers.helper.ALRenderHelper;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class RenderLightsaberStand
extends TileEntitySpecialRenderer {
    private ResourceLocation texture = new ResourceLocation("lightsabers", "textures/models/lightsaber_stand.png");
    private ModelLightsaberStand model = new ModelLightsaberStand();

    public void render(TileEntityLightsaberStand tile, double x, double y, double z, float partialTicks) {
        LightsaberData[] data;
        ItemStack stack = tile.getDisplayStack();
        float scale = 0.15f;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        this.model.rStandTip.field_78800_c = 2.5f;
        this.model.lStandTip.field_78800_c = -3.5f;
        if (tile.func_145831_w() != null) {
            this.adjustRotation(tile, tile.func_145832_p());
            if (stack != null && stack.func_77973_b() instanceof ItemLightsaber) {
                data = LightsaberData.get(stack);
                float f = Math.min(data.getHeightCm() - 25.0f, 0.0f) * 0.2f;
                this.model.rStandTip.field_78800_c += f;
                this.model.lStandTip.field_78800_c -= f;
            }
        }
        this.func_147499_a(this.texture);
        this.model.render();
        if (tile.func_145831_w() != null && stack != null) {
            GL11.glTranslatef((float)0.0f, (float)1.36f, (float)0.0f);
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glScalef((float)scale, (float)scale, (float)scale);
            GL11.glEnable((int)32826);
            if (stack.func_77973_b() instanceof ItemDoubleLightsaber) {
                data = ItemDoubleLightsaber.get(stack);
                ALRenderHelper.renderLightsaberHilt(data);
            } else {
                data = LightsaberData.get(stack);
                ALRenderHelper.renderLightsaberHilt((LightsaberData)data);
            }
            GL11.glDisable((int)32826);
        }
        GL11.glPopMatrix();
    }

    public void adjustRotation(TileEntityLightsaberStand tile, int metadata) {
        if (metadata > 1) {
            int[] matrix = new int[]{2, 0, 1, 3};
            GL11.glRotatef((float)(90 * matrix[Math.min(metadata - 2, 3)]), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        } else if (metadata == 1) {
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        GL11.glTranslatef((float)0.0f, (float)-1.0f, (float)0.0f);
    }

    public void func_147500_a(TileEntity tile, double x, double y, double z, float partialTicks) {
        this.render((TileEntityLightsaberStand)tile, x, y, z, partialTicks);
    }
}

