/*
 * Decompiled with CFR 0.152.
 */
package com.fiskmods.lightsabers.common.block;

import com.fiskmods.lightsabers.Lightsabers;
import com.fiskmods.lightsabers.common.tileentity.TileEntityDisassemblyStation;
import com.fiskmods.lightsabers.helper.ALHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockDisassemblyStation
extends BlockContainer {
    public static final int[][] DIRECTIONS = new int[][]{{-1, 0}, {0, -1}, {1, 0}, {0, 1}};
    private Random rand = new Random();

    public BlockDisassemblyStation() {
        super(Material.field_151573_f);
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
        this.setHarvestLevel("pickaxe", 1);
        this.func_149672_a(field_149777_j);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        TileEntity tile;
        if (!world.field_72995_K && (tile = BlockDisassemblyStation.getBase(world, x, y, z)) != null) {
            player.openGui((Object)Lightsabers.instance, 4, world, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
        }
        return true;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        int metadata = world.func_72805_g(x, y, z);
        int dir = BlockDisassemblyStation.getRotation(metadata);
        Part part = Part.get(metadata);
        if (part == Part.TOP) {
            if (world.func_147439_a(x, y - 1, z) != this) {
                world.func_147468_f(x, y, z);
            }
        } else if (part == Part.SIDE) {
            if (world.func_147439_a(x - DIRECTIONS[dir][0], y, z - DIRECTIONS[dir][1]) != this || world.func_147439_a(x, y + 1, z) != this) {
                world.func_147468_f(x, y, z);
            }
        } else if (world.func_147439_a(x + DIRECTIONS[dir][0], y, z + DIRECTIONS[dir][1]) != this || world.func_147439_a(x, y + 1, z) != this) {
            world.func_147468_f(x, y, z);
            if (!world.field_72995_K) {
                this.func_149697_b(world, x, y, z, metadata, 0);
            }
        }
    }

    public Item func_149650_a(int metadata, Random rand, int fortune) {
        return BlockDisassemblyStation.isBasePart(metadata) ? super.func_149650_a(metadata, rand, fortune) : Item.func_150899_d((int)0);
    }

    public void func_149690_a(World world, int x, int y, int z, int metadata, float chance, int fortune) {
        if (BlockDisassemblyStation.isBasePart(metadata)) {
            super.func_149690_a(world, x, y, z, metadata, chance, 0);
        }
    }

    public void func_149681_a(World world, int x, int y, int z, int metadata, EntityPlayer player) {
        TileEntity tile;
        if (player.field_71075_bZ.field_75098_d && !BlockDisassemblyStation.isBasePart(metadata) && (tile = BlockDisassemblyStation.getBase(world, x, y, z)) != null && world.func_147439_a(x = tile.field_145851_c, y = tile.field_145848_d, z = tile.field_145849_e) == this) {
            world.func_147468_f(x, y, z);
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int metadata) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof IInventory) {
            IInventory inventory = (IInventory)tile;
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack stack = inventory.func_70301_a(i);
                if (stack == null) continue;
                ALHelper.dropItem(world, x, y, z, stack, this.rand);
            }
            world.func_147453_f(x, y, z, block);
        }
        super.func_149749_a(world, x, y, z, block, metadata);
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return -1;
    }

    public boolean func_149662_c() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return super.func_149633_g(world, x, y, z);
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB aabb, List list, Entity entity) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        super.func_149743_a(world, x, y, z, aabb, list, entity);
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        int metadata = world.func_72805_g(x, y, z);
        Part part = Part.get(metadata);
        float f = 0.0625f;
        if (part == Part.TOP) {
            int dir = BlockDisassemblyStation.getRotation(metadata);
            float width = f * 12.4f;
            float height = f * 13.0f;
            float f1 = f;
            if (BlockDisassemblyStation.isBasePart(world.func_72805_g(x, y - 1, z))) {
                f1 = -f * 2.0f;
            }
            if (dir == 0) {
                this.func_149676_a(0.0f, f1, 1.0f - width, 1.0f, height, 1.0f);
            } else if (dir == 1) {
                this.func_149676_a(0.0f, f1, 0.0f, width, height, 1.0f);
            } else if (dir == 2) {
                this.func_149676_a(0.0f, f1, 0.0f, 1.0f, height, width);
            } else if (dir == 3) {
                this.func_149676_a(1.0f - width, f1, 0.0f, 1.0f, height, 1.0f);
            }
        } else if (part == Part.SIDE) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, f * 17.0f, 1.0f);
        } else {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, f * 14.0f, 1.0f);
        }
    }

    public int func_149656_h() {
        return 2;
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World world, int x, int y, int z, int side) {
        return Container.func_94526_b((IInventory)((IInventory)world.func_147438_o(x, y, z)));
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileEntityDisassemblyStation();
    }

    public boolean hasTileEntity(int metadata) {
        return BlockDisassemblyStation.isBasePart(metadata);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.field_149761_L = iconRegister.func_94245_a("iron_block");
    }

    public static int serialize(int rotation, Part part) {
        return part.serialize(rotation & 3);
    }

    public static int getRotation(int metadata) {
        return metadata & 3;
    }

    public static boolean isBasePart(int metadata) {
        return Part.get(metadata) == Part.BASE;
    }

    public static TileEntity getBase(World world, int x, int y, int z) {
        int metadata = world.func_72805_g(x, y, z);
        int dir = BlockDisassemblyStation.getRotation(metadata);
        Part part = Part.get(metadata);
        if (part == Part.BASE) {
            return world.func_147438_o(x, y, z);
        }
        if (part == Part.TOP) {
            return BlockDisassemblyStation.getBase(world, x, y - 1, z);
        }
        return BlockDisassemblyStation.getBase(world, x - DIRECTIONS[dir][0], y, z - DIRECTIONS[dir][1]);
    }

    public static enum Part {
        BASE,
        SIDE,
        TOP;


        public int serialize(int rotation) {
            return rotation | (this.ordinal() & 3) << 2;
        }

        public static Part get(int metadata) {
            return Part.values()[metadata >> 2 & 3];
        }
    }
}

