/*
 * Decompiled with CFR 0.152.
 */
package com.fiskmods.lightsabers.common.block;

import com.fiskmods.lightsabers.common.tileentity.TileEntityLightsaberStand;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockLightsaberStand
extends BlockContainer {
    private final Random rand = new Random();

    public BlockLightsaberStand() {
        super(Material.field_151573_f);
        this.func_149711_c(1.5f);
        this.func_149752_b(10.0f);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149672_a(field_149777_j);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        TileEntity tileentity;
        if (!world.field_72995_K && (tileentity = world.func_147438_o(x, y, z)) instanceof TileEntityLightsaberStand) {
            TileEntityLightsaberStand tile = (TileEntityLightsaberStand)tileentity;
            if (player.field_71075_bZ.field_75098_d || tile.isOwner((EntityLivingBase)player)) {
                ItemStack stack = tile.getDisplayStack();
                if (tile.setDisplayStack(player.func_70694_bm())) {
                    player.func_70062_b(0, stack);
                }
            } else {
                player.func_145747_a(new ChatComponentTranslation("message.lightsaberStand.notOwner", new Object[0]).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.RED)));
            }
        }
        return true;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int metadata) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityLightsaberStand) {
            ItemStack itemstack = ((TileEntityLightsaberStand)tile).getDisplayStack();
            if (itemstack != null) {
                float f = this.rand.nextFloat() * 0.8f + 0.1f;
                float f1 = this.rand.nextFloat() * 0.8f + 0.1f;
                float f2 = this.rand.nextFloat() * 0.8f + 0.1f;
                while (itemstack.field_77994_a > 0) {
                    int j1 = this.rand.nextInt(21) + 10;
                    if (j1 > itemstack.field_77994_a) {
                        j1 = itemstack.field_77994_a;
                    }
                    itemstack.field_77994_a -= j1;
                    EntityItem entityitem = new EntityItem(world, (double)((float)x + f), (double)((float)y + f1), (double)((float)z + f2), new ItemStack(itemstack.func_77973_b(), j1, itemstack.func_77960_j()));
                    if (itemstack.func_77942_o()) {
                        entityitem.func_92059_d().func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
                    }
                    float f3 = 0.05f;
                    entityitem.field_70159_w = (float)this.rand.nextGaussian() * f3;
                    entityitem.field_70181_x = (float)this.rand.nextGaussian() * f3 + 0.2f;
                    entityitem.field_70179_y = (float)this.rand.nextGaussian() * f3;
                    world.func_72838_d((Entity)entityitem);
                }
            }
            world.func_147453_f(x, y, z, block);
        }
        super.func_149749_a(world, x, y, z, block, metadata);
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return -1;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149707_d(World world, int x, int y, int z, int side) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        return dir != ForgeDirection.DOWN && world.isSideSolid(x - dir.offsetX, y - dir.offsetY, z - dir.offsetZ, dir, true) && super.func_149707_d(world, x, y, z, side);
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        ForgeDirection dir = BlockLightsaberStand.getDirection(world.func_72805_g(x, y, z));
        return world.isSideSolid(x - dir.offsetX, y - dir.offsetY, z - dir.offsetZ, dir, true);
    }

    public int func_149660_a(World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        if (side == 1) {
            side = 0;
        }
        return side;
    }

    public static ForgeDirection getDirection(int metadata) {
        if (metadata == 0) {
            metadata = 1;
        }
        return ForgeDirection.getOrientation((int)metadata);
    }

    public void func_149726_b(World world, int x, int y, int z) {
        this.updatePlacement(world, x, y, z);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        this.updatePlacement(world, x, y, z);
    }

    protected void updatePlacement(World world, int x, int y, int z) {
        if (!this.func_149718_j(world, x, y, z) && world.func_147439_a(x, y, z) == this) {
            this.func_149697_b(world, x, y, z, 1, 0);
            world.func_147468_f(x, y, z);
        }
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB aabb, List list, Entity entity) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        super.func_149743_a(world, x, y, z, aabb, list, entity);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return super.func_149633_g(world, x, y, z);
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        int metadata = world.func_72805_g(x, y, z);
        float w = 0.171875f;
        float l = 0.328125f;
        float h = 0.8125f;
        if (metadata == 2) {
            this.func_149676_a(w, l, h, 1.0f - w, 1.0f - l, 1.0f);
        } else if (metadata == 3) {
            this.func_149676_a(w, l, 0.0f, 1.0f - w, 1.0f - l, 1.0f - h);
        } else if (metadata == 4) {
            this.func_149676_a(h, l, w, 1.0f, 1.0f - l, 1.0f - w);
        } else if (metadata == 5) {
            this.func_149676_a(0.0f, l, w, 1.0f - h, 1.0f - l, 1.0f - w);
        } else if ((metadata & 1) == 0) {
            this.func_149676_a(w, 0.0f, l, 1.0f - w, 1.0f - h, 1.0f - l);
        } else {
            this.func_149676_a(l, 0.0f, w, 1.0f - l, 1.0f - h, 1.0f - w);
        }
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack itemstack) {
        super.func_149689_a(world, x, y, z, entity, itemstack);
        TileEntity tile = world.func_147438_o(x, y, z);
        int metadata = world.func_72805_g(x, y, z);
        if (metadata == 0) {
            int i = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 1;
            world.func_72921_c(x, y, z, i, 2);
        }
        if (tile instanceof TileEntityLightsaberStand) {
            ((TileEntityLightsaberStand)tile).setOwner(entity);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.field_149761_L = iconRegister.func_94245_a("iron_block");
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileEntityLightsaberStand();
    }
}

