/*
 * Decompiled with CFR 0.152.
 */
package com.fiskmods.lightsabers.common.block;

import com.fiskmods.lightsabers.Lightsabers;
import com.fiskmods.lightsabers.common.network.ALNetworkManager;
import com.fiskmods.lightsabers.common.network.PacketTileAction;
import com.fiskmods.lightsabers.common.tileentity.TileEntitySithCoffin;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockSithCoffin
extends BlockContainer
implements ITileEntityProvider {
    public static final int[][] DIRECTIONS = new int[][]{{0, 1}, {-1, 0}, {0, -1}, {1, 0}};
    private Random rand = new Random();

    public BlockSithCoffin() {
        super(Material.field_151576_e);
        this.func_149711_c(50.0f);
        this.func_149752_b(2000.0f);
    }

    public boolean canHarvestBlock(EntityPlayer player, int meta) {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return -1;
    }

    public boolean func_149662_c() {
        return false;
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB aabb, List list, Entity entity) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        super.func_149743_a(world, x, y, z, aabb, list, entity);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return super.func_149633_g(world, x, y, z);
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        int metadata = world.func_72805_g(x, y, z);
        int i = BlockSithCoffin.isBlockFrontOfCoffin(metadata) ? 1 : 0;
        int dir = BlockSithCoffin.getDirection(metadata);
        float f = 0.9575f;
        float height = 0.9375f;
        if (dir == 0) {
            this.func_149676_a(0.0f, 0.0f, -i, 1.0f, height, 2 - i);
        } else if (dir == 1) {
            this.func_149676_a(i - 1, 0.0f, 0.0f, 1 + i, height, 1.0f);
        } else if (dir == 2) {
            this.func_149676_a(0.0f, 0.0f, i - 1, 1.0f, height, 1 + i);
        } else if (dir == 3) {
            this.func_149676_a(-i, 0.0f, 0.0f, 2 - i, height, 1.0f);
        }
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        int metadata = world.func_72805_g(x, y, z);
        int dir = BlockSithCoffin.getDirection(metadata);
        if (BlockSithCoffin.isBlockFrontOfCoffin(metadata)) {
            if (world.func_147439_a(x - DIRECTIONS[dir][0], y, z - DIRECTIONS[dir][1]) != this) {
                world.func_147468_f(x, y, z);
            }
        } else if (world.func_147439_a(x + DIRECTIONS[dir][0], y, z + DIRECTIONS[dir][1]) != this) {
            world.func_147468_f(x, y, z);
            if (!world.field_72995_K) {
                this.func_149697_b(world, x, y, z, metadata, 0);
            }
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        TileEntitySithCoffin tile;
        int metadata = world.func_72805_g(x, y, z);
        int dir = BlockSithCoffin.getDirection(metadata);
        if (BlockSithCoffin.isBlockFrontOfCoffin(metadata)) {
            x -= DIRECTIONS[dir][0];
            z -= DIRECTIONS[dir][1];
        }
        if ((tile = (TileEntitySithCoffin)world.func_147438_o(x, y, z)) != null) {
            if (!tile.hasBeenOpened || tile.lidOpenTimer == 0 || player.func_70093_af()) {
                this.sendActionPacket(tile, player, 0);
                return true;
            }
            if (tile.lidOpenTimer == 60) {
                player.openGui((Object)Lightsabers.instance, 1, world, x, y, z);
                return true;
            }
        }
        return false;
    }

    public void sendActionPacket(TileEntitySithCoffin tile, EntityPlayer player, int action) {
        if (player.field_70170_p.field_72995_K) {
            ALNetworkManager.wrapper.sendToServer((IMessage)new PacketTileAction((Entity)player, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, action));
        }
    }

    public Item func_149650_a(int metadata, Random rand, int fortune) {
        return BlockSithCoffin.isBlockFrontOfCoffin(metadata) ? Item.func_150899_d((int)0) : super.func_149650_a(metadata, rand, fortune);
    }

    public static boolean isBlockFrontOfCoffin(int metadata) {
        return (metadata & 8) != 0;
    }

    public static int getDirection(int metadata) {
        return metadata & 3;
    }

    public void func_149690_a(World world, int x, int y, int z, int metadata, float dropChance, int fortune) {
        if (!BlockSithCoffin.isBlockFrontOfCoffin(metadata)) {
            super.func_149690_a(world, x, y, z, metadata, dropChance, 0);
        }
    }

    public int func_149656_h() {
        return 2;
    }

    public void func_149681_a(World world, int x, int y, int z, int metadata, EntityPlayer player) {
        int dir;
        if (player.field_71075_bZ.field_75098_d && BlockSithCoffin.isBlockFrontOfCoffin(metadata) && world.func_147439_a(x -= DIRECTIONS[dir = BlockSithCoffin.getDirection(metadata)][0], y, z -= DIRECTIONS[dir][1]) == this) {
            world.func_147468_f(x, y, z);
        }
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileEntitySithCoffin();
    }

    public void func_149651_a(IIconRegister iconRegister) {
        this.field_149761_L = iconRegister.func_94245_a("obsidian");
    }
}

