/*
 * Decompiled with CFR 0.152.
 */
package com.fiskmods.lightsabers.common.block;

import com.fiskmods.lightsabers.common.block.ModBlocks;
import com.fiskmods.lightsabers.common.entity.EntitySithGhost;
import com.fiskmods.lightsabers.common.network.ALNetworkManager;
import com.fiskmods.lightsabers.common.network.PacketTileAction;
import com.fiskmods.lightsabers.common.tileentity.TileEntitySithStoneCoffin;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockSithStoneCoffin
extends BlockContainer {
    private final Random rand = new Random();

    public BlockSithStoneCoffin() {
        super(Material.field_151576_e);
        this.func_149711_c(50.0f);
        this.func_149752_b(2000.0f);
    }

    public static EntitySithGhost spawnSithGhost(World world, int x, int y, int z) {
        EntitySithGhost entity = new EntitySithGhost(world);
        entity.func_70012_b((float)x + 0.5f, (float)y + 0.1875f, (float)z + 0.5f, world.func_72805_g(x, y, z) * 90, 0.0f);
        entity.func_110161_a(null);
        entity.field_70173_aa = -entity.func_70681_au().nextInt(20);
        entity.hasRestingPlace = true;
        entity.restingPlaceX = x;
        entity.restingPlaceY = y;
        entity.restingPlaceZ = z;
        if (world.func_147438_o(x, y, z) instanceof TileEntitySithStoneCoffin) {
            TileEntitySithStoneCoffin tile = (TileEntitySithStoneCoffin)world.func_147438_o(x, y, z);
            if (tile.equipment != null) {
                if (tile.equipment.func_77942_o()) {
                    tile.equipment.func_77978_p().func_74757_a("active", false);
                }
                entity.func_70062_b(0, tile.equipment);
            }
            tile.baseplateOnly = true;
        }
        world.func_72838_d((Entity)entity);
        return entity;
    }

    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
        if (world.func_72864_z(x, y, z)) {
            this.activate(world, x, y, z);
        }
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        int metadata = world.func_72805_g(x, y, z);
        if (metadata >= 4) {
            if (world.func_147439_a(x, y - 1, z) != ModBlocks.sithStoneCoffin) {
                world.func_147468_f(x, y, z);
                this.func_149749_a(world, x, y, z, block, metadata);
            }
        } else {
            TileEntitySithStoneCoffin tile = (TileEntitySithStoneCoffin)world.func_147438_o(x, y, z);
            if (!(tile != null && tile.baseplateOnly || world.func_147439_a(x, y + 1, z) == ModBlocks.sithStoneCoffin)) {
                world.func_147468_f(x, y, z);
                this.func_149749_a(world, x, y, z, block, metadata);
            }
        }
        if (world.func_72864_z(x, y, z)) {
            this.activate(world, x, y, z);
        }
    }

    public void activate(World world, int x, int y, int z) {
        TileEntitySithStoneCoffin tile;
        if (world.func_72805_g(x, y, z) >= 4) {
            --y;
        }
        if ((tile = (TileEntitySithStoneCoffin)world.func_147438_o(x, y, z)) != null && !tile.baseplateOnly && !world.field_72995_K) {
            BlockSithStoneCoffin.spawnSithGhost(world, x, y, z);
            ALNetworkManager.wrapper.sendToServer((IMessage)new PacketTileAction(null, x, y, z, 1));
        }
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer player) {
        if (!player.field_71075_bZ.field_75098_d && !world.field_72995_K) {
            TileEntitySithStoneCoffin tile;
            if (world.func_72805_g(x, y, z) >= 4) {
                --y;
            }
            if ((tile = (TileEntitySithStoneCoffin)world.func_147438_o(x, y, z)) != null && !tile.baseplateOnly && tile.taskFinished) {
                world.func_72926_e(2001, x, y, z, Block.func_149682_b((Block)world.func_147439_a(x, y, z)) + (world.func_72805_g(x, y, z) << 12));
                world.func_147468_f(x, y, z);
                ItemStack itemstack = new ItemStack((Block)this);
                itemstack.func_77982_d(new NBTTagCompound());
                if (tile.equipment != null) {
                    NBTTagCompound nbttagcompound = new NBTTagCompound();
                    tile.equipment.func_77955_b(nbttagcompound);
                    itemstack.func_77978_p().func_74782_a("Equipment", (NBTBase)nbttagcompound);
                }
                float f = this.rand.nextFloat() * 0.8f + 0.1f;
                float f1 = this.rand.nextFloat() * 0.8f + 0.1f;
                float f2 = this.rand.nextFloat() * 0.8f + 0.1f;
                float f3 = 0.05f;
                EntityItem entityitem = new EntityItem(world, (double)((float)x + f), (double)((float)y + f1), (double)((float)z + f2), itemstack);
                entityitem.field_70159_w = (float)this.rand.nextGaussian() * f3;
                entityitem.field_70181_x = (float)this.rand.nextGaussian() * f3 + 0.2f;
                entityitem.field_70179_y = (float)this.rand.nextGaussian() * f3;
                world.func_72838_d((Entity)entityitem);
                this.func_149749_a(world, x, y, z, world.func_147439_a(x, y, z), world.func_72805_g(x, y, z));
            }
        }
        super.func_149699_a(world, x, y, z, player);
    }

    public boolean canHarvestBlock(EntityPlayer player, int meta) {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return -1;
    }

    public boolean func_149662_c() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return super.func_149633_g(world, x, y, z);
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB aabb, List list, Entity entity) {
        int metadata = world.func_72805_g(x, y, z);
        float f = 0.0625f;
        if (metadata < 4) {
            this.addBox(0.0f, 0.0f, 0.0f, 1.0f, 3.0f * f, 1.0f, world, x, y, z, aabb, list, entity);
            TileEntitySithStoneCoffin tile = (TileEntitySithStoneCoffin)world.func_147438_o(x, y, z);
            if (tile != null && !tile.baseplateOnly) {
                if (metadata == 0) {
                    this.addBox(1.5f * f, 3.0f * f, 1.5f * f, 14.5f * f, 31.0f * f, 10.5f * f, world, x, y, z, aabb, list, entity);
                } else if (metadata == 1) {
                    this.addBox(5.5f * f, 3.0f * f, 1.5f * f, 14.5f * f, 31.0f * f, 14.5f * f, world, x, y, z, aabb, list, entity);
                } else if (metadata == 2) {
                    this.addBox(1.5f * f, 3.0f * f, 5.5f * f, 14.5f * f, 31.0f * f, 14.5f * f, world, x, y, z, aabb, list, entity);
                } else if (metadata == 3) {
                    this.addBox(1.5f * f, 3.0f * f, 1.5f * f, 10.5f * f, 31.0f * f, 14.5f * f, world, x, y, z, aabb, list, entity);
                }
            }
        }
        this.func_149719_a((IBlockAccess)world, x, y, z);
    }

    public void addBox(float minX, float minY, float minZ, float maxX, float maxY, float maxZ, World world, int x, int y, int z, AxisAlignedBB aabb, List list, Entity entity) {
        this.func_149676_a(minX, minY, minZ, maxX, maxY, maxZ);
        super.func_149743_a(world, x, y, z, aabb, list, entity);
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        int metadata = world.func_72805_g(x, y, z);
        if (metadata >= 4) {
            --y;
        }
        TileEntitySithStoneCoffin tile = (TileEntitySithStoneCoffin)world.func_147438_o(x, y, z);
        boolean flag = false;
        if (tile != null) {
            flag = tile.baseplateOnly;
        }
        if (metadata >= 4) {
            if (!flag) {
                this.func_149676_a(0.0f, -1.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            } else {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            }
        } else if (!flag) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 2.0f, 1.0f);
        } else {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.1875f, 1.0f);
        }
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return y < world.func_72800_K() - 1 && super.func_149742_c(world, x, y, z) && super.func_149742_c(world, x, y + 1, z);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack itemstack) {
        int rotation = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 2.5)) & 3;
        world.func_72921_c(x, y, z, rotation, 2);
        world.func_147465_d(x, y + 1, z, (Block)this, rotation + 4, 2);
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileEntitySithStoneCoffin();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.field_149761_L = iconRegister.func_94245_a("hardened_clay_stained_black");
    }
}

