/*
 * Decompiled with CFR 0.152.
 */
package com.fiskmods.lightsabers.common.command;

import com.fiskmods.lightsabers.common.command.StructureLocator;
import com.fiskmods.lightsabers.common.data.ALData;
import com.fiskmods.lightsabers.common.force.Power;
import com.fiskmods.lightsabers.common.force.PowerData;
import com.fiskmods.lightsabers.common.force.PowerManager;
import com.fiskmods.lightsabers.common.generator.WorldGeneratorStructures;
import com.fiskmods.lightsabers.common.generator.structure.EnumStructure;
import com.fiskmods.lightsabers.helper.ALHelper;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.storage.WorldInfo;

public class CommandForce
extends CommandBase {
    public String func_71517_b() {
        return "force";
    }

    public int func_82362_a() {
        return 2;
    }

    public String func_71518_a(ICommandSender sender) {
        return "commands.force.usage";
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        World world = sender.func_130014_f_();
        String usage = this.func_71518_a(sender);
        if (args.length > 0) {
            String func = args[0];
            String arg = "";
            if (args.length > 1) {
                arg = args[1];
            }
            if (func.equals("xp") || func.equals("base")) {
                EntityPlayerMP player;
                if (func.equals("base") && arg.equals("reset") && (args.length == 2 || args.length == 3) && ALData.BASE_POWER.set((EntityPlayer)(player = args.length == 3 ? CommandForce.func_82359_c((ICommandSender)sender, (String)args[2]) : CommandForce.func_71521_c((ICommandSender)sender)), (Byte)ALHelper.getBasePower((EntityPlayer)player))) {
                    CommandForce.func_152373_a((ICommandSender)sender, (ICommand)this, (String)String.format("commands.force.%s.%s.success", func, arg), (Object[])new Object[]{player.func_70005_c_()});
                    return;
                }
                if (args.length == 3 || args.length == 4) {
                    ArrayList translationKeys;
                    float f;
                    player = args.length == 4 ? CommandForce.func_82359_c((ICommandSender)sender, (String)args[3]) : CommandForce.func_71521_c((ICommandSender)sender);
                    float amount = CommandForce.func_71528_a((ICommandSender)sender, (String)args[2], (int)0);
                    float f2 = f = func.equals("xp") ? ALData.FORCE_XP.get((Entity)player).floatValue() : 0.0f;
                    if (arg.equals("give")) {
                        f += amount;
                    } else if (arg.equals("take")) {
                        f -= amount;
                    } else if (arg.equals("set")) {
                        f = amount;
                    }
                    f = Math.max(f, 0.0f);
                    ArrayList arrayList = translationKeys = arg.equals("set") ? Lists.newArrayList((Object[])new Serializable[]{player.func_70005_c_(), Integer.valueOf(MathHelper.func_76141_d((float)amount))}) : Lists.newArrayList((Object[])new Serializable[]{Integer.valueOf(MathHelper.func_76141_d((float)amount)), player.func_70005_c_()});
                    if (func.equals("xp")) {
                        ALData.FORCE_XP.set((EntityPlayer)player, Float.valueOf(f));
                    } else {
                        ALData.BASE_POWER.set((EntityPlayer)player, (Byte)((byte)MathHelper.func_76141_d((float)f)));
                    }
                    CommandForce.func_152373_a((ICommandSender)sender, (ICommand)this, (String)String.format("commands.force.%s.%s.success", func, arg), (Object[])translationKeys.toArray());
                    return;
                }
                throw new WrongUsageException(String.format("commands.force.%s.usage", func), new Object[0]);
            }
            if (func.equals("power")) {
                if (args.length == 3 || args.length == 4) {
                    EntityPlayerMP player = args.length == 4 ? CommandForce.func_82359_c((ICommandSender)sender, (String)args[3]) : CommandForce.func_71521_c((ICommandSender)sender);
                    Power power = Power.getPowerFromName(args[2]);
                    boolean targetAll = args[2].equals("*");
                    if (power == null && !targetAll) {
                        throw new CommandException("commands.force.power.unknown", new Object[]{args[2]});
                    }
                    if (arg.equals("give")) {
                        if (targetAll) {
                            for (PowerData data : ALData.POWERS.get((Entity)player)) {
                                if (data.isUnlocked()) continue;
                                PowerManager.unlockPower((EntityPlayer)player, data.power);
                            }
                            CommandForce.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"commands.force.power.give.success.all", (Object[])new Object[]{player.func_70005_c_()});
                        } else {
                            if (!PowerManager.unlockPower((EntityPlayer)player, power)) {
                                throw new CommandException("commands.force.power.alreadyHave", new Object[]{player.func_70005_c_(), args[2]});
                            }
                            CommandForce.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"commands.force.power.give.success.one", (Object[])new Object[]{player.func_70005_c_(), power.getChatFormattedName()});
                        }
                        ALData.POWERS.sync((EntityPlayer)player);
                        ALData.BASE_POWER.sync((EntityPlayer)player);
                        return;
                    }
                    if (arg.equals("take")) {
                        if (targetAll) {
                            for (PowerData data : ALData.POWERS.get((Entity)player)) {
                                if (!data.isUnlocked()) continue;
                                PowerManager.removePower((EntityPlayer)player, data.power);
                            }
                            CommandForce.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"commands.force.power.take.success.all", (Object[])new Object[]{player.func_70005_c_()});
                        } else {
                            if (!PowerManager.removePower((EntityPlayer)player, power)) {
                                throw new CommandException("commands.force.power.dontHave", new Object[]{player.func_70005_c_(), args[2]});
                            }
                            CommandForce.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"commands.force.power.take.success.one", (Object[])new Object[]{power.getChatFormattedName(), player.func_70005_c_()});
                        }
                        ALData.POWERS.sync((EntityPlayer)player);
                        ALData.BASE_POWER.sync((EntityPlayer)player);
                        return;
                    }
                }
                throw new WrongUsageException("commands.force.power.usage", new Object[0]);
            }
            if (func.equals("structure")) {
                if (sender.func_70003_b(3, this.func_71517_b())) {
                    if (arg.equals("locate") ? args.length == 4 || args.length == 6 : args.length == 3 || args.length == 5) {
                        EnumStructure structure = null;
                        for (EnumStructure structure1 : EnumStructure.values()) {
                            if (!ALHelper.getUnconventionalName(structure1.name()).equals(args[2])) continue;
                            structure = structure1;
                            break;
                        }
                        boolean targetAll = arg.equals("locate") && args[2].equals("*");
                        int x = sender.func_82114_b().field_71574_a;
                        int z = sender.func_82114_b().field_71573_c;
                        if (arg.equals("locate") ? args.length == 6 : args.length == 5) {
                            x = MathHelper.func_76128_c((double)CommandForce.func_110666_a((ICommandSender)sender, (double)x, (String)(arg.equals("locate") ? args[4] : args[3])));
                            z = MathHelper.func_76128_c((double)CommandForce.func_110666_a((ICommandSender)sender, (double)z, (String)(arg.equals("locate") ? args[5] : args[4])));
                        }
                        if (structure == null && !targetAll) {
                            throw new CommandException("commands.force.structure.unknown", new Object[]{args[2]});
                        }
                        if (arg.equals("locate")) {
                            WorldInfo info = world.func_72912_H();
                            if (info.func_76067_t() == WorldType.field_77138_c || !info.func_76089_r() || world.field_73011_w.field_76574_g != 0) {
                                throw new CommandException("commands.force.structure.locate.doesNotGenerate", new Object[]{args[2]});
                            }
                            new Thread(new StructureLocator(this, sender, structure, targetAll, CommandForce.func_71528_a((ICommandSender)sender, (String)args[3], (int)0), x, z)).start();
                            return;
                        }
                        if (arg.equals("generate")) {
                            if (!world.func_72899_e(x, 64, z)) {
                                throw new CommandException("commands.force.structure.generate.outOfWorld", new Object[]{arg});
                            }
                            try {
                                WorldGeneratorStructures.generateStructure(world, x, z, structure);
                                CommandForce.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"commands.force.structure.generate.success", (Object[])new Object[]{ALHelper.getUnconventionalName(structure.name()), x, z});
                                return;
                            }
                            catch (Exception e) {
                                throw new CommandException("commands.force.structure.generate.failure", new Object[0]);
                            }
                        }
                    }
                    if (arg.equals("locate") || arg.equals("generate")) {
                        throw new WrongUsageException(String.format("commands.force.structure.%s.usage", arg), new Object[0]);
                    }
                    throw new WrongUsageException("commands.force.structure.usage", new Object[0]);
                }
                throw new CommandException("commands.generic.permission", new Object[0]);
            }
        }
        throw new WrongUsageException(usage, new Object[0]);
    }

    public List func_71516_a(ICommandSender sender, String[] args) {
        World world = sender.func_130014_f_();
        if (args.length > 0) {
            if (args.length == 1) {
                return CommandForce.func_71530_a((String[])args, (String[])new String[]{"xp", "base", "power", "structure"});
            }
            if (args[0].equals("xp")) {
                if (args.length == 2) {
                    return CommandForce.func_71530_a((String[])args, (String[])new String[]{"give", "take", "set"});
                }
                if (args.length == 4) {
                    return CommandForce.func_71530_a((String[])args, (String[])MinecraftServer.func_71276_C().func_71213_z());
                }
            } else if (args[0].equals("base")) {
                if (args.length == 2) {
                    return CommandForce.func_71530_a((String[])args, (String[])new String[]{"give", "take", "set", "reset"});
                }
                if (args.length == 4 || args.length == 3 && args[1].equals("reset")) {
                    return CommandForce.func_71530_a((String[])args, (String[])MinecraftServer.func_71276_C().func_71213_z());
                }
            } else if (args[0].equals("power")) {
                if (args.length == 2) {
                    return CommandForce.func_71530_a((String[])args, (String[])new String[]{"give", "take"});
                }
                if (args.length == 3) {
                    ArrayList list = Lists.newArrayList();
                    for (Power power : Power.POWERS) {
                        list.add(power.getName());
                    }
                    return CommandForce.func_71530_a((String[])args, (String[])list.toArray(new String[list.size()]));
                }
                if (args.length == 4) {
                    return CommandForce.func_71530_a((String[])args, (String[])MinecraftServer.func_71276_C().func_71213_z());
                }
            } else if (args[0].equals("structure")) {
                if (args.length == 2) {
                    return CommandForce.func_71530_a((String[])args, (String[])new String[]{"locate", "generate"});
                }
                if (args.length == 3) {
                    ArrayList list = Lists.newArrayList();
                    for (EnumStructure structure : EnumStructure.values()) {
                        list.add(ALHelper.getUnconventionalName(structure.name()));
                    }
                    return CommandForce.func_71530_a((String[])args, (String[])list.toArray(new String[list.size()]));
                }
            }
        }
        return null;
    }
}

