/*
 * Decompiled with CFR 0.152.
 */
package com.fiskmods.lightsabers.common.command;

import com.fiskmods.lightsabers.common.generator.WorldGeneratorStructures;
import com.fiskmods.lightsabers.common.generator.structure.EnumStructure;
import com.fiskmods.lightsabers.helper.ALHelper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;

public class StructureLocator
implements Runnable {
    public static WeakHashMap<World, Map<EnumStructure, List<ChunkCoordIntPair>>> cachedStructurePos = new WeakHashMap();
    public static WeakHashMap<World, List<ChunkCoordIntPair>> chunksSearched = new WeakHashMap();
    private final CommandBase command;
    private final ICommandSender sender;
    private final EnumStructure structure;
    private final boolean targetAll;
    private final int maxRange;
    private final int startX;
    private final int startZ;

    public StructureLocator(CommandBase commandBase, ICommandSender commandSender, EnumStructure enumStructure, boolean all, int range, int x, int z) {
        this.command = commandBase;
        this.sender = commandSender;
        this.structure = enumStructure;
        this.targetAll = all;
        this.maxRange = range;
        this.startX = x;
        this.startZ = z;
    }

    @Override
    public void run() {
        List<Object> structures;
        World world = this.sender.func_130014_f_();
        List<ChunkCoordIntPair> searched = StructureLocator.getChunksSearched(world);
        boolean flag = this.structure == null || StructureLocator.getStructures(world, this.structure).isEmpty();
        int range = 0;
        searched.clear();
        while (++range < this.maxRange && flag) {
            for (int i = -range; i <= range; ++i) {
                for (int j = -range; j <= range; ++j) {
                    int chunkX = (this.startX >> 4) + i;
                    int chunkZ = (this.startZ >> 4) + j;
                    ChunkCoordIntPair chunk = new ChunkCoordIntPair(chunkX, chunkZ);
                    if (searched.contains(chunk)) continue;
                    for (EnumStructure structure1 : EnumStructure.values()) {
                        if (!WorldGeneratorStructures.canSpawnStructureAtCoords(world, chunk.func_77273_a(), chunk.func_77274_b(), structure1)) continue;
                        StructureLocator.getStructures(world, structure1).add(chunk);
                        if (this.structure != structure1 && !this.targetAll) continue;
                        flag = false;
                    }
                    searched.add(chunk);
                }
            }
        }
        final Vec3 vec = Vec3.func_72443_a((double)(this.startX >> 4), (double)0.0, (double)(this.startZ >> 4));
        Comparator<ChunkCoordIntPair> coordComparator = new Comparator<ChunkCoordIntPair>(){

            @Override
            public int compare(ChunkCoordIntPair arg0, ChunkCoordIntPair arg1) {
                return Double.valueOf(Vec3.func_72443_a((double)arg0.field_77276_a, (double)0.0, (double)arg0.field_77275_b).func_72438_d(vec)).compareTo(Vec3.func_72443_a((double)arg1.field_77276_a, (double)0.0, (double)arg1.field_77275_b).func_72438_d(vec));
            }
        };
        for (EnumStructure structure1 : EnumStructure.values()) {
            Collections.sort(StructureLocator.getStructures(world, structure1), coordComparator);
        }
        if (this.targetAll) {
            structures = Lists.newArrayList();
            for (EnumStructure structure1 : EnumStructure.values()) {
                if (StructureLocator.getStructures(world, structure1).isEmpty()) continue;
                structures.add(StructureLocator.getStructures(world, structure1).get(0));
            }
            if (structures.isEmpty()) {
                ChatComponentTranslation message = new ChatComponentTranslation("commands.force.structure.locate.failure", new Object[0]);
                message.func_150256_b().func_150238_a(EnumChatFormatting.RED);
                this.sender.func_145747_a((IChatComponent)message);
            } else {
                Collections.sort(structures, coordComparator);
                for (ChatComponentTranslation structure1 : EnumStructure.values()) {
                    if (StructureLocator.getStructures(world, (EnumStructure)structure1).isEmpty() || !((ChunkCoordIntPair)structures.get(0)).equals((Object)StructureLocator.getStructures(world, (EnumStructure)structure1).get(0))) continue;
                    ChunkCoordIntPair chunk = (ChunkCoordIntPair)structures.get(0);
                    CommandBase.func_152373_a((ICommandSender)this.sender, (ICommand)this.command, (String)"commands.force.structure.locate.success", (Object[])new Object[]{ALHelper.getUnconventionalName(structure1.name()), chunk.func_77273_a(), chunk.func_77274_b()});
                    break;
                }
            }
        } else {
            structures = StructureLocator.getStructures(world, this.structure);
            if (structures.isEmpty()) {
                ChatComponentTranslation message = new ChatComponentTranslation("commands.force.structure.locate.failure", new Object[0]);
                message.func_150256_b().func_150238_a(EnumChatFormatting.RED);
                this.sender.func_145747_a((IChatComponent)message);
            } else {
                ChunkCoordIntPair chunk = (ChunkCoordIntPair)structures.get(0);
                CommandBase.func_152373_a((ICommandSender)this.sender, (ICommand)this.command, (String)"commands.force.structure.locate.success", (Object[])new Object[]{ALHelper.getUnconventionalName(this.structure.name()), chunk.func_77273_a(), chunk.func_77274_b()});
            }
        }
    }

    public static List<ChunkCoordIntPair> getChunksSearched(World world) {
        if (chunksSearched.get(world) == null) {
            chunksSearched.put(world, new ArrayList());
        }
        return chunksSearched.get(world);
    }

    public static Map<EnumStructure, List<ChunkCoordIntPair>> getStructures(World world) {
        if (cachedStructurePos.get(world) == null) {
            cachedStructurePos.put(world, new HashMap());
        }
        return cachedStructurePos.get(world);
    }

    public static List<ChunkCoordIntPair> getStructures(World world, EnumStructure structure) {
        Map<EnumStructure, List<ChunkCoordIntPair>> map = StructureLocator.getStructures(world);
        if (map.get((Object)structure) == null) {
            map.put(structure, new ArrayList());
        }
        return map.get((Object)structure);
    }
}

