/*
 * Decompiled with CFR 0.152.
 */
package com.fiskmods.lightsabers.common.container;

import com.fiskmods.lightsabers.common.block.ModBlocks;
import com.fiskmods.lightsabers.common.item.ItemCrystal;
import com.fiskmods.lightsabers.common.item.ItemCrystalPouch;
import com.fiskmods.lightsabers.common.lightsaber.CrystalColor;
import fiskfille.utils.helper.FiskServerUtils;
import java.util.UUID;
import java.util.concurrent.Callable;
import net.minecraft.block.Block;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ReportedException;

public class InventoryCrystalPouch
implements IInventory {
    public final EntityPlayer thePlayer;
    public final UUID uuid;
    public final int itemSlot;
    private ItemStack[] itemstacks = new ItemStack[CrystalColor.values().length];

    public InventoryCrystalPouch(EntityPlayer player, int slot) {
        this.thePlayer = player;
        this.itemSlot = slot;
        ItemStack stack = this.getPouchStack();
        this.uuid = ItemCrystalPouch.getUUID(stack);
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        this.readFromNBT(stack.func_77978_p());
    }

    public ItemStack getPouchStack() {
        return FiskServerUtils.getStackInSlot(this.thePlayer, this.itemSlot);
    }

    public boolean addItemStackToInventory(ItemStack itemstack) {
        if (this.addItemStackToInventoryTemp(itemstack)) {
            this.func_70296_d();
            return true;
        }
        return false;
    }

    private boolean addItemStackToInventoryTemp(final ItemStack itemstack) {
        if (itemstack != null && itemstack.field_77994_a != 0 && itemstack.func_77973_b() != null) {
            try {
                int stackSize;
                if (itemstack.func_77951_h()) {
                    int slot = this.getFirstEmptyStack(itemstack);
                    if (slot >= 0) {
                        this.itemstacks[slot] = ItemStack.func_77944_b((ItemStack)itemstack);
                        this.itemstacks[slot].field_77992_b = 5;
                        itemstack.field_77994_a = 0;
                        return true;
                    }
                    return false;
                }
                do {
                    stackSize = itemstack.field_77994_a;
                    itemstack.field_77994_a = this.storePartialItemStack(itemstack);
                } while (itemstack.field_77994_a > 0 && itemstack.field_77994_a < stackSize);
                return itemstack.field_77994_a < stackSize;
            }
            catch (Throwable throwable) {
                CrashReport crash = CrashReport.func_85055_a((Throwable)throwable, (String)"Adding item to quiver");
                CrashReportCategory category = crash.func_85058_a("Item being added");
                category.func_71507_a("Item ID", (Object)Item.func_150891_b((Item)itemstack.func_77973_b()));
                category.func_71507_a("Item data", (Object)itemstack.func_77960_j());
                category.func_71500_a("Item name", new Callable(){

                    public String call() {
                        return itemstack.func_82833_r();
                    }
                });
                throw new ReportedException(crash);
            }
        }
        return false;
    }

    public int getFirstEmptyStack(ItemStack itemstack) {
        for (int i = 0; i < this.itemstacks.length; ++i) {
            if (this.itemstacks[i] != null || !this.func_94041_b(i, itemstack)) continue;
            return i;
        }
        return -1;
    }

    private int storePartialItemStack(ItemStack itemstack) {
        Item item = itemstack.func_77973_b();
        int toAdd = itemstack.field_77994_a;
        if (itemstack.func_77976_d() == 1) {
            int slot = this.getFirstEmptyStack(itemstack);
            if (slot < 0) {
                return toAdd;
            }
            if (this.itemstacks[slot] == null) {
                this.itemstacks[slot] = ItemStack.func_77944_b((ItemStack)itemstack);
            }
            return 0;
        }
        int slot = this.storeItemStack(itemstack);
        if (slot < 0) {
            slot = this.getFirstEmptyStack(itemstack);
        }
        if (slot < 0) {
            return toAdd;
        }
        if (this.itemstacks[slot] == null) {
            this.itemstacks[slot] = new ItemStack(item, 0, itemstack.func_77960_j());
            if (itemstack.func_77942_o()) {
                this.itemstacks[slot].func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
            }
        }
        int i = toAdd;
        if (toAdd > this.itemstacks[slot].func_77976_d() - this.itemstacks[slot].field_77994_a) {
            i = this.itemstacks[slot].func_77976_d() - this.itemstacks[slot].field_77994_a;
        }
        if (i > this.func_70297_j_() - this.itemstacks[slot].field_77994_a) {
            i = this.func_70297_j_() - this.itemstacks[slot].field_77994_a;
        }
        if (i == 0) {
            return toAdd;
        }
        this.itemstacks[slot].field_77994_a += i;
        this.itemstacks[slot].field_77992_b = 5;
        return toAdd - i;
    }

    private int storeItemStack(ItemStack itemstack) {
        for (int i = 0; i < this.itemstacks.length; ++i) {
            if (this.itemstacks[i] == null || this.itemstacks[i].func_77973_b() != itemstack.func_77973_b() || !this.itemstacks[i].func_77985_e() || this.itemstacks[i].field_77994_a >= this.itemstacks[i].func_77976_d() || this.itemstacks[i].field_77994_a >= this.func_70297_j_() || this.itemstacks[i].func_77981_g() && this.itemstacks[i].func_77960_j() != itemstack.func_77960_j() || !ItemStack.func_77970_a((ItemStack)this.itemstacks[i], (ItemStack)itemstack)) continue;
            return i;
        }
        return -1;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        NBTTagList list = nbt.func_150295_c("Slots", 10);
        this.itemstacks = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < Math.min(list.func_74745_c(), this.func_70302_i_()); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            this.itemstacks[tag.func_74771_c((String)"Slot")] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.itemstacks[i] == null) continue;
            NBTTagCompound tag = this.itemstacks[i].func_77955_b(new NBTTagCompound());
            tag.func_74774_a("Slot", (byte)i);
            list.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("Slots", (NBTBase)list);
        return nbt;
    }

    public int func_70302_i_() {
        return this.itemstacks.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.itemstacks[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            if (stack.field_77994_a > amount) {
                stack = stack.func_77979_a(amount);
                this.func_70296_d();
            } else {
                this.func_70299_a(slot, null);
            }
        }
        return stack;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack stack = this.func_70301_a(slot);
        this.func_70299_a(slot, null);
        return stack;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.itemstacks[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public String func_145825_b() {
        return "Crystal Pouch";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 16;
    }

    public void func_70296_d() {
        if (!this.thePlayer.field_70170_p.field_72995_K && this.func_70300_a(this.thePlayer)) {
            this.writeToNBT(this.getPouchStack().func_77978_p());
        }
    }

    public boolean func_70300_a(EntityPlayer player) {
        return ItemCrystalPouch.getUUID(this.getPouchStack()).equals(this.uuid);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return stack.func_77973_b() == Item.func_150898_a((Block)ModBlocks.lightsaberCrystal) && slot == ItemCrystal.getId(stack);
    }
}

