/*
 * Decompiled with CFR 0.152.
 */
package com.fiskmods.lightsabers.common.data;

import com.fiskmods.lightsabers.common.data.ALDataInterp;
import com.fiskmods.lightsabers.common.data.ALDataPowers;
import com.fiskmods.lightsabers.common.data.ALPlayerData;
import com.fiskmods.lightsabers.common.data.IDataHolder;
import com.fiskmods.lightsabers.common.force.Power;
import com.fiskmods.lightsabers.common.force.PowerData;
import com.fiskmods.lightsabers.common.lightsaber.LightsaberData;
import com.fiskmods.lightsabers.common.network.ALNetworkManager;
import com.fiskmods.lightsabers.common.network.MessagePlayerData;
import com.fiskmods.lightsabers.helper.ALFormatHelper;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import fiskfille.utils.helper.NBTHelper;
import fiskfille.utils.registry.FiskRegistryEntry;
import fiskfille.utils.registry.FiskRegistryNamespaced;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;

public class ALData<T>
extends FiskRegistryEntry<ALData<?>> {
    public static final FiskRegistryNamespaced<ALData<?>> REGISTRY = new FiskRegistryNamespaced("lightsabers", null);
    protected static final int SAVE_NBT = 1;
    protected static final int SYNC_BYTES = 2;
    protected static final int RESET_ON_DEATH = 4;
    protected static final int RESET_WO_PRED = 8;
    public static final ALData<Float> FORCE_XP = new ALData<Float>(Float.valueOf(0.0f)).setExempt(4);
    public static final ALData<Byte> BASE_POWER = new ALData<Byte>((byte)-1).setExempt(4);
    public static final ALData<String> DRAINING_XP_TO = new ALData<String>("").setExempt(1);
    public static final ALData<Integer> PREV_XP = new ALData<Integer>(0).setExempt(4);
    public static final ALData<Byte> SELECTED_POWER = new ALData<Byte>((byte)0).setExempt(4);
    public static final ALData<Boolean> USING_POWER = new ALData<Boolean>(false);
    public static final ALData<Boolean> PREV_USING_POWER = new ALData<Boolean>(false);
    public static final ALData<Integer> TICKS_USING_POWER = new ALData<Integer>(0);
    public static final ALData<Integer> USE_POWER_COOLDOWN = new ALData<Integer>(0);
    public static final ALData<PowerData.Container> POWERS = new ALDataPowers().setExempt(4);
    public static final ALData<List<Power>> SELECTED_POWERS = new ALData<DataFactory<List<Power>>>(Power.factory()).setExempt(4);
    public static final ALData<LightsaberData> LIGHTSABER = new ALData().setExempt(1);
    public static final ALDataInterp<Float> FORCE_POWER = new ALDataInterp<Float>(Float.valueOf(0.0f));
    public static final ALDataInterp<Float> FORCE_POWER_DIFF = new ALDataInterp<Float>(Float.valueOf(0.0f)).setExempt(1);
    public static final ALDataInterp<Float> FORCE_PUSHING_TIMER = new ALDataInterp<Float>(Float.valueOf(0.0f));
    public static final ALDataInterp<Float> DRAIN_LIFE_TIMER = new ALDataInterp<Float>(Float.valueOf(0.0f));
    public static final ALDataInterp<Float> RIGHT_ARM_TIMER = new ALDataInterp<Float>(Float.valueOf(0.0f));
    public static final ALDataInterp<Float> LEFT_ARM_TIMER = new ALDataInterp<Float>(Float.valueOf(0.0f));
    final DataFactory<T> defaultValue;
    public final Predicate<Entity> canSet;
    public String id;
    public ClassType<T> typeClass;
    protected int flags = -1;
    protected int permissions = -1;

    public static void register(String key, ALData value) {
        REGISTRY.putObject(key, value);
    }

    public static ALData getDataFromName(String key) {
        return (ALData)REGISTRY.getObject(key);
    }

    public static String getNameForData(ALData value) {
        return REGISTRY.getNameForObject(value);
    }

    protected ALData(DataFactory<T> defaultVal, Predicate<Entity> p) {
        this.defaultValue = defaultVal;
        this.canSet = p;
    }

    protected ALData(final T defaultVal, Predicate<Entity> p) {
        this(new DataFactory<T>(){

            @Override
            public T construct() {
                return defaultVal;
            }
        }, p);
    }

    protected ALData(DataFactory<T> defaultVal) {
        this(defaultVal, (Predicate<Entity>)null);
    }

    protected ALData(T defaultVal) {
        this(defaultVal, null);
    }

    protected ALData(Predicate<Entity> p) {
        this(null, p);
    }

    protected ALData() {
        this(null);
    }

    protected ALData setExempt(int exempt) {
        this.flags &= ~exempt;
        return this;
    }

    protected ALData revokePerms(Side side) {
        this.permissions &= ~(1 << side.ordinal());
        return this;
    }

    protected ALData revokePerms() {
        this.revokePerms(Side.CLIENT);
        this.revokePerms(Side.SERVER);
        return this;
    }

    protected boolean hasFlag(int flags, int flag) {
        return (flags & flag) == flag;
    }

    public boolean shouldSaveNBT() {
        return this.hasFlag(this.flags, 1);
    }

    public boolean shouldSyncBytes() {
        return this.hasFlag(this.flags, 2);
    }

    public boolean shouldResetOnDeath() {
        return this.hasFlag(this.flags, 4);
    }

    public boolean shouldResetWithoutPredicate() {
        return this.hasFlag(this.flags, 8);
    }

    public boolean hasPerms(Side side) {
        return this.hasFlag(this.permissions, 1 << side.ordinal());
    }

    public Predicate<Entity> isValue(final T value) {
        return new Predicate<Entity>(){

            public boolean apply(Entity input) {
                return Objects.equal((Object)value, ALData.this.get(input));
            }
        };
    }

    public boolean ofType(Class clazz) {
        return this.typeClass.getType() == clazz;
    }

    protected boolean validUpdate(Entity entity, T value) {
        if (this.ofType(ItemStack.class)) {
            return !ItemStack.func_77989_b((ItemStack)((ItemStack)this.get(entity)), (ItemStack)((ItemStack)value));
        }
        return !Objects.equal(value, this.get(entity));
    }

    protected boolean legalUpdate(Entity entity) {
        return this.canSet == null || this.canSet.apply((Object)entity);
    }

    public T getDefault() {
        return this.defaultValue.construct();
    }

    public boolean set(Entity entity, T value) {
        if (entity instanceof IDataHolder) {
            return this.setWithoutNotify(entity, value);
        }
        if (entity instanceof EntityPlayer) {
            return this.set((EntityPlayer)entity, value);
        }
        return false;
    }

    public boolean setWithoutNotify(Entity entity, T value) {
        return this.legalUpdate(entity) && this.setWithBypass(entity, value);
    }

    private boolean setWithBypass(Entity entity, T value) {
        if (this.validUpdate(entity, value)) {
            if (entity instanceof IDataHolder) {
                ((IDataHolder)entity).set(this, value);
                this.onValueChanged(entity, value);
            } else if (entity instanceof EntityPlayer) {
                ALPlayerData.getData((EntityPlayer)entity).putData(this, value);
                this.onValueChanged(entity, value);
            }
            return true;
        }
        return false;
    }

    private boolean reset(Entity entity) {
        return this.setWithBypass(entity, this.getDefault());
    }

    public boolean incr(Entity entity, T value) {
        if (entity instanceof IDataHolder) {
            return this.incrWithoutNotify(entity, value);
        }
        if (entity instanceof EntityPlayer) {
            return this.incr((EntityPlayer)entity, value);
        }
        return false;
    }

    public boolean incrWithoutNotify(Entity entity, T value) {
        if (value instanceof Byte) {
            return this.setWithoutNotify(entity, (byte)((Byte)this.get(entity) + (Byte)value));
        }
        if (value instanceof Short) {
            return this.setWithoutNotify(entity, (short)((Short)this.get(entity) + (Short)value));
        }
        if (value instanceof Integer) {
            return this.setWithoutNotify(entity, (Integer)this.get(entity) + (Integer)value);
        }
        if (value instanceof Long) {
            return this.setWithoutNotify(entity, (Long)this.get(entity) + (Long)value);
        }
        if (value instanceof Float) {
            return this.setWithoutNotify(entity, Float.valueOf(((Float)this.get(entity)).floatValue() + ((Float)value).floatValue()));
        }
        if (value instanceof Double) {
            return this.setWithoutNotify(entity, (Double)this.get(entity) + (Double)value);
        }
        if (value instanceof String) {
            return this.setWithoutNotify(entity, String.valueOf((String)this.get(entity) + (String)value));
        }
        throw new RuntimeException("Cannot increment a non-numerical data type unless a String!");
    }

    public boolean clamp(Entity entity, T min, T max) {
        if (entity instanceof IDataHolder) {
            return this.clampWithoutNotify(entity, min, max);
        }
        if (entity instanceof EntityPlayer) {
            return this.clamp((EntityPlayer)entity, min, max);
        }
        return false;
    }

    public boolean clampWithoutNotify(Entity entity, T min, T max) {
        if (min instanceof Byte) {
            return this.setWithoutNotify(entity, (byte)MathHelper.func_76125_a((int)((Byte)this.get(entity)).byteValue(), (int)((Byte)min).byteValue(), (int)((Byte)max).byteValue()));
        }
        if (min instanceof Short) {
            return this.setWithoutNotify(entity, (short)MathHelper.func_76125_a((int)((Short)this.get(entity)).shortValue(), (int)((Short)min).shortValue(), (int)((Short)max).shortValue()));
        }
        if (min instanceof Integer) {
            return this.setWithoutNotify(entity, MathHelper.func_76125_a((int)((Integer)this.get(entity)), (int)((Integer)min), (int)((Integer)max)));
        }
        if (min instanceof Long) {
            long l = (Long)this.get(entity);
            return this.setWithoutNotify(entity, l < (Long)min ? (Long)min : (l > (Long)max ? (Long)max : l));
        }
        if (min instanceof Float) {
            return this.setWithoutNotify(entity, Float.valueOf(MathHelper.func_76131_a((float)((Float)this.get(entity)).floatValue(), (float)((Float)min).floatValue(), (float)((Float)max).floatValue())));
        }
        if (min instanceof Double) {
            return this.setWithoutNotify(entity, MathHelper.func_151237_a((double)((Double)this.get(entity)), (double)((Double)min), (double)((Double)max)));
        }
        throw new RuntimeException("Cannot clamp a non-numerical data type!");
    }

    public T get(Entity entity) {
        if (entity instanceof IDataHolder) {
            return ((IDataHolder)entity).get(this);
        }
        if (entity instanceof EntityPlayer) {
            return ALPlayerData.getData((EntityPlayer)entity).getData(this);
        }
        return this.getDefault();
    }

    public boolean sync(EntityPlayer player) {
        if (this.hasPerms(player.field_70170_p.field_72995_K ? Side.CLIENT : Side.SERVER) && this.legalUpdate((Entity)player)) {
            if (player.field_70170_p.field_72995_K) {
                ALNetworkManager.wrapper.sendToServer((IMessage)new MessagePlayerData(player, this, this.get((Entity)player)));
            } else {
                ALNetworkManager.wrapper.sendToDimension((IMessage)new MessagePlayerData(player, this, this.get((Entity)player)), player.field_71093_bK);
            }
            return true;
        }
        return false;
    }

    public boolean set(EntityPlayer player, T value) {
        return this.setWithoutNotify((Entity)player, value) && this.sync(player);
    }

    public boolean incr(EntityPlayer player, T value) {
        return this.incrWithoutNotify((Entity)player, value) && this.sync(player);
    }

    public boolean clamp(EntityPlayer player, T min, T max) {
        return this.clampWithoutNotify((Entity)player, min, max) && this.sync(player);
    }

    public static NBTTagCompound writeToNBT(NBTTagCompound nbt, Map<ALData, Object> data) {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        for (Map.Entry<ALData, Object> e : data.entrySet()) {
            NBTBase nbtbase;
            if (!e.getKey().shouldSaveNBT() || (nbtbase = NBTHelper.writeToNBT(e.getValue())) == null) continue;
            nbttagcompound.func_74782_a(e.getKey().id, nbtbase);
        }
        nbt.func_74782_a("DataArray", (NBTBase)nbttagcompound);
        return nbt;
    }

    public static Map<ALData, Object> readFromNBT(NBTTagCompound nbt, Map<ALData, Object> data) {
        NBTTagCompound nbttagcompound = nbt.func_74775_l("DataArray");
        for (ALData aLData : REGISTRY) {
            if (!aLData.shouldSaveNBT()) continue;
            NBTBase tag = nbttagcompound.func_74781_a(aLData.id);
            Object obj = null;
            if (tag != null) {
                obj = NBTHelper.readFromNBT(tag, aLData.typeClass);
            } else {
                tag = nbt.func_74781_a(aLData.id);
                if (tag == null) continue;
                obj = NBTHelper.readFromNBT(tag, aLData.typeClass);
            }
            data.put(aLData, obj);
        }
        return data;
    }

    public static void toBytes(ByteBuf buf, Map<ALData, Object> data) {
        buf.writeInt(REGISTRY.func_148742_b().size());
        for (ALData aLData : REGISTRY) {
            if (!aLData.shouldSyncBytes()) continue;
            boolean flag = data.containsKey(aLData);
            if (flag && aLData.defaultValue.canEqual()) {
                Object b;
                Object a = aLData.getDefault();
                flag = !Objects.equal(a, (Object)(b = data.get(aLData)));
            }
            buf.writeBoolean(flag);
            if (!flag) continue;
            NBTHelper.toBytes(buf, data.get(aLData));
        }
    }

    public static Map<ALData, Object> fromBytes(ByteBuf buf, Map<ALData, Object> data) {
        int size = buf.readInt();
        if (size != REGISTRY.func_148742_b().size()) {
            throw new RuntimeException(String.format("Incompatible data registries - this is really bad! Received %s, expected: %s", size, REGISTRY.func_148742_b().size()));
        }
        for (ALData aLData : REGISTRY) {
            if (!aLData.shouldSyncBytes() || !buf.readBoolean()) continue;
            data.put(aLData, NBTHelper.fromBytes(buf, aLData.typeClass));
        }
        return data;
    }

    public static void onUpdate(Entity entity) {
        for (ALData aLData : REGISTRY) {
            aLData.update(entity);
            if (!aLData.shouldResetWithoutPredicate() || aLData.legalUpdate(entity)) continue;
            aLData.reset(entity);
        }
    }

    public static void onDeath(Entity entity) {
        for (ALData aLData : REGISTRY) {
            if (!aLData.shouldResetOnDeath()) continue;
            aLData.reset(entity);
        }
    }

    protected void init(Field field, String name) throws ClassNotFoundException {
        this.id = ALFormatHelper.getUnconventionalName(name);
        this.typeClass = ClassType.construct(field.getGenericType().getTypeName()).getParam();
        ALData.register(name.toLowerCase(Locale.ROOT), this);
    }

    protected void update(Entity entity) {
    }

    protected void onValueChanged(Entity entity, T value) {
    }

    @Override
    public String toString() {
        return this.id;
    }

    public static void init() {
        for (Field field : ALData.class.getFields()) {
            if (!ALData.class.isAssignableFrom(field.getType())) continue;
            try {
                ((ALData)field.get(null)).init(field, field.getName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static abstract class DataFactory<T> {
        public abstract T construct();

        public boolean canEqual() {
            return true;
        }
    }

    public static class ClassType<C> {
        private final Class<C> type;
        private ClassType param;

        public ClassType(Class<C> c) {
            this.type = c;
        }

        private ClassType<C> setParam(ClassType type) {
            this.param = type;
            return this;
        }

        public ClassType getParam() {
            return this.param;
        }

        public ClassType getParamSafe() {
            return this.param == null ? new ClassType<Object>(Object.class) : this.param;
        }

        public Class<C> getType() {
            return this.type;
        }

        public String toString() {
            String s = this.getType().getCanonicalName();
            if (this.getParam() != null) {
                return s + "<" + this.getParam() + ">";
            }
            return s;
        }

        private static ClassType construct(String typeName) throws ClassNotFoundException {
            if (typeName.contains("<")) {
                ClassType type = new ClassType(Class.forName(typeName.substring(0, typeName.indexOf(60))));
                ClassType type1 = ClassType.construct(typeName.substring(typeName.indexOf(60) + 1, typeName.length() - 1));
                return super.setParam(type1);
            }
            return new ClassType(Class.forName(typeName));
        }
    }
}

