/*
 * Decompiled with CFR 0.152.
 */
package com.fiskmods.lightsabers.common.data;

import com.fiskmods.lightsabers.Lightsabers;
import com.fiskmods.lightsabers.common.data.ALData;
import com.google.common.base.Predicate;
import cpw.mods.fml.relauncher.Side;
import fiskfille.utils.helper.FiskServerUtils;
import java.lang.reflect.Field;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;

public class ALDataInterp<T>
extends ALData<T> {
    protected final ALData<T> prevData;

    protected ALDataInterp(T defaultValue) {
        super(defaultValue);
        this.prevData = new ALData<T>(defaultValue).setExempt(3);
    }

    protected ALDataInterp(T defaultValue, Predicate<Entity> canSet) {
        super(defaultValue, canSet);
        this.prevData = new ALData<T>(defaultValue, canSet).setExempt(3);
    }

    @Override
    protected ALDataInterp setExempt(int exempt) {
        this.prevData.setExempt(exempt);
        return (ALDataInterp)super.setExempt(exempt);
    }

    @Override
    protected ALDataInterp revokePerms(Side side) {
        this.prevData.revokePerms(side);
        return (ALDataInterp)super.revokePerms(side);
    }

    @Override
    public void update(Entity entity) {
        this.prevData.setWithoutNotify(entity, this.get(entity));
    }

    public ALData<T> getPrevData() {
        return this.prevData;
    }

    public T getPrev(EntityPlayer player) {
        return this.prevData.get((Entity)player);
    }

    public T getPrev(Entity entity) {
        return this.prevData.get(entity);
    }

    public T interpolate(Entity entity, float progress) {
        if (progress == 1.0f) {
            return this.get(entity);
        }
        if (this.ofType(Float.class)) {
            return (T)Float.valueOf(FiskServerUtils.interpolate(((Float)this.getPrev(entity)).floatValue(), ((Float)this.get(entity)).floatValue(), progress));
        }
        if (this.ofType(Double.class)) {
            return (T)Double.valueOf(FiskServerUtils.interpolate((Double)this.getPrev(entity), (Double)this.get(entity), (double)progress));
        }
        throw new RuntimeException("Cannot interpolate a non-decimal data type!");
    }

    public T interpolate(Entity entity) {
        return this.interpolate(entity, Lightsabers.proxy.getRenderTick());
    }

    @Override
    protected void init(Field field, String name) throws ClassNotFoundException {
        super.init(field, name);
        this.prevData.init(field, "PREV_" + name);
    }
}

