/*
 * Decompiled with CFR 0.152.
 */
package com.fiskmods.lightsabers.common.data;

import com.fiskmods.lightsabers.common.data.effect.StatusEffect;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class ALEntityData
implements IExtendedEntityProperties {
    public static final String IDENTIFIER = "ALEntity";
    public List<StatusEffect> activeEffects = Lists.newArrayList();
    public boolean forcePushed;

    public static ALEntityData getData(EntityLivingBase entity) {
        return (ALEntityData)entity.getExtendedProperties(IDENTIFIER);
    }

    public void saveNBTData(NBTTagCompound nbt) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74757_a("Saved", true);
        compound.func_74757_a("ForcePushed", this.forcePushed);
        if (!this.activeEffects.isEmpty()) {
            NBTTagList nbttaglist = new NBTTagList();
            for (StatusEffect effect : this.activeEffects) {
                nbttaglist.func_74742_a((NBTBase)effect.writeToNBT(new NBTTagCompound()));
            }
            compound.func_74782_a("Effects", (NBTBase)nbttaglist);
        }
        nbt.func_74782_a(IDENTIFIER, (NBTBase)compound);
    }

    public void loadNBTData(NBTTagCompound nbt) {
        NBTTagCompound compound = nbt.func_74775_l(IDENTIFIER);
        if (compound.func_74767_n("Saved")) {
            this.forcePushed = compound.func_74767_n("ForcePushed");
            if (compound.func_150297_b("Effects", 9)) {
                NBTTagList nbttaglist = compound.func_150295_c("Effects", 10);
                this.activeEffects.clear();
                for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                    StatusEffect effect = StatusEffect.readFromNBT(nbttaglist.func_150305_b(i));
                    if (effect == null) continue;
                    this.activeEffects.add(effect);
                }
            }
        }
    }

    public void init(Entity entity, World world) {
    }
}

