/*
 * Decompiled with CFR 0.152.
 */
package com.fiskmods.lightsabers.common.data;

import com.fiskmods.lightsabers.common.data.ALData;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class ALPlayerData
implements IExtendedEntityProperties {
    public static final String IDENTIFIER = "ALPlayer";
    public Map<ALData, Object> data = Maps.newHashMap();

    public static ALPlayerData getData(EntityPlayer player) {
        return (ALPlayerData)player.getExtendedProperties(IDENTIFIER);
    }

    public void saveNBTData(NBTTagCompound nbt) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74757_a("Saved", true);
        ALData.writeToNBT(compound, this.data);
        nbt.func_74782_a(IDENTIFIER, (NBTBase)compound);
    }

    public void loadNBTData(NBTTagCompound nbt) {
        NBTTagCompound compound = nbt.func_74775_l(IDENTIFIER);
        if (compound.func_74767_n("Saved")) {
            this.data = ALData.readFromNBT(compound, this.data);
        }
    }

    public void init(Entity entity, World world) {
    }

    public void copy(ALPlayerData props) {
        this.data = props.data;
    }

    public <T> void putData(ALData<T> type, T value) {
        this.data.put(type, value);
    }

    public <T> T getData(ALData<T> type) {
        if (this.data.containsKey(type)) {
            return (T)this.data.get(type);
        }
        if (!type.defaultValue.canEqual()) {
            this.putData(type, type.getDefault());
            return this.getData(type);
        }
        return type.getDefault();
    }
}

