/*
 * Decompiled with CFR 0.152.
 */
package com.fiskmods.lightsabers.common.data.effect;

import com.fiskmods.lightsabers.common.data.effect.StatusEffect;
import com.fiskmods.lightsabers.common.force.Power;
import com.google.common.collect.Lists;
import fiskfille.utils.registry.FiskRegistryEntry;
import fiskfille.utils.registry.FiskRegistryNamespaced;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.util.StringUtils;

public class Effect
extends FiskRegistryEntry<Effect> {
    public static final FiskRegistryNamespaced<Effect> REGISTRY = new FiskRegistryNamespaced("lightsabers", null);
    public static final Effect FORTIFY = new Effect(false);
    public static final Effect STUN = new Effect(false);
    public static final Effect DRAIN = new Effect(true);
    public static final Effect LIGHTNING = new Effect(false);
    public static final Effect CHOKE = new Effect(true);
    public static final Effect STEALTH = new Effect(false);
    public static final Effect SPEED = new Effect(false);
    public static final Effect GAZE = new Effect(false);
    public static final Effect MEDITATION = new Effect(false);
    public static final Effect RESIST = new Effect(false);
    private final boolean negativeEffect;
    public List<Power> powers = Lists.newArrayList();

    public static void register(int id, String key, Effect value) {
        REGISTRY.addObject(id, key, value);
    }

    public static void register(String key, Effect value) {
        REGISTRY.putObject(key, value);
    }

    public static Effect getEffectFromName(String key) {
        return (Effect)REGISTRY.getObject(key);
    }

    public static String getNameForEffect(Effect value) {
        return REGISTRY.getNameForObject(value);
    }

    public static int getIdFromEffect(Effect value) {
        return value == null ? 0 : REGISTRY.getIDForObject(value);
    }

    public static Effect getEffectById(int id) {
        return REGISTRY.getObjectById(id);
    }

    public Effect(boolean negative) {
        this.negativeEffect = negative;
    }

    public boolean isNegative() {
        return this.negativeEffect;
    }

    public String getUnlocalizedName() {
        return "statusEffect." + this.delegate.name().replace(':', '.');
    }

    public String getLocalizedName() {
        return StatCollector.func_74838_a((String)this.getUnlocalizedName());
    }

    public String getFormattedString(StatusEffect effect) {
        String s = this.getLocalizedName();
        if (effect.amplifier > 0 && effect.amplifier < 10) {
            s = s + " " + StatCollector.func_74838_a((String)("enchantment.level." + (effect.amplifier + 1)));
        }
        return s;
    }

    public String getDurationString(StatusEffect effect) {
        if (effect.isMaxDuration()) {
            return "**:**";
        }
        return StringUtils.func_76337_a((int)effect.duration);
    }

    public Power getPower(int i) {
        return !this.powers.isEmpty() ? this.powers.get(MathHelper.func_76125_a((int)i, (int)0, (int)(this.powers.size() - 1))) : null;
    }

    public static void register() {
        for (Field field : Effect.class.getFields()) {
            if (!Effect.class.isAssignableFrom(field.getType())) continue;
            try {
                Effect.register(field.getName().toLowerCase(Locale.ROOT), (Effect)field.get(null));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static List<Effect> getEffectsForPower(Power power) {
        ArrayList list = Lists.newArrayList();
        for (Effect effect : REGISTRY) {
            if (!effect.powers.contains(power)) continue;
            list.add(effect);
        }
        return list;
    }
}

