/*
 * Decompiled with CFR 0.152.
 */
package com.fiskmods.lightsabers.common.data.effect;

import com.fiskmods.lightsabers.common.data.ALEntityData;
import com.fiskmods.lightsabers.common.data.effect.Effect;
import com.fiskmods.lightsabers.common.network.ALNetworkManager;
import com.fiskmods.lightsabers.common.network.MessageUpdateEffects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.primitives.Doubles;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;

public class StatusEffect
implements Comparable<StatusEffect> {
    public Effect effect;
    public short duration;
    public byte amplifier;
    public UUID casterUUID;

    public StatusEffect(Effect effect, int duration, int amplifier) {
        this.effect = effect;
        this.duration = (short)duration;
        this.amplifier = (byte)amplifier;
    }

    public StatusEffect(Effect effect, int duration, int amplifier, UUID uuid) {
        this(effect, duration, amplifier);
        this.casterUUID = uuid;
    }

    public StatusEffect(Effect effect, int duration, int amplifier, EntityLivingBase entity) {
        this(effect, duration, amplifier, entity != null ? entity.func_110124_au() : null);
    }

    public static StatusEffect fromBytes(ByteBuf buf) {
        Effect e = Effect.getEffectById(buf.readByte());
        if (e != null) {
            StatusEffect effect = new StatusEffect(e, buf.readShort(), buf.readByte());
            if (buf.readBoolean()) {
                UUID uuid;
                effect.casterUUID = uuid = new UUID(buf.readLong(), buf.readLong());
            }
            return effect;
        }
        return null;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte((int)((byte)Effect.getIdFromEffect(this.effect)));
        buf.writeShort((int)this.duration);
        buf.writeByte((int)this.amplifier);
        if (this.casterUUID != null) {
            buf.writeBoolean(true);
            buf.writeLong(this.casterUUID.getMostSignificantBits());
            buf.writeLong(this.casterUUID.getLeastSignificantBits());
        } else {
            buf.writeBoolean(false);
        }
    }

    public static StatusEffect readFromNBT(NBTTagCompound tag) {
        Effect effect = Effect.getEffectFromName(tag.func_74779_i("Id"));
        if (effect != null) {
            UUID uuid = null;
            if (tag.func_150297_b("CasterUUIDMost", 99) && tag.func_150297_b("CasterUUIDLeast", 99)) {
                uuid = new UUID(tag.func_74763_f("CasterUUIDMost"), tag.func_74763_f("CasterUUIDLeast"));
            }
            return new StatusEffect(effect, tag.func_74762_e("Duration"), tag.func_74762_e("Amplifier"), uuid);
        }
        return null;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74778_a("Id", this.effect.delegate.name());
        tag.func_74768_a("Duration", (int)this.duration);
        tag.func_74768_a("Amplifier", (int)this.amplifier);
        if (this.casterUUID != null) {
            tag.func_74772_a("CasterUUIDMost", this.casterUUID.getMostSignificantBits());
            tag.func_74772_a("CasterUUIDLeast", this.casterUUID.getLeastSignificantBits());
        }
        return tag;
    }

    public boolean isMaxDuration() {
        return this.duration >= Short.MAX_VALUE;
    }

    public static void add(EntityLivingBase entity, Effect effect, int duration, int amplifier) {
        StatusEffect.add(entity, null, effect, duration, amplifier);
    }

    public static void add(EntityLivingBase entity, Entity caster, Effect effect, int duration, int amplifier) {
        StatusEffect.add(entity, caster instanceof EntityLivingBase ? (EntityLivingBase)caster : null, effect, duration, amplifier);
    }

    public static void add(EntityLivingBase entity, EntityLivingBase caster, Effect effect, int duration, int amplifier) {
        List<StatusEffect> list = StatusEffect.get(entity);
        duration = MathHelper.func_76125_a((int)duration, (int)Short.MIN_VALUE, (int)Short.MAX_VALUE);
        for (StatusEffect status : list) {
            if (status.effect != effect) continue;
            short prevDuration = status.duration;
            byte prevAmplifier = status.amplifier;
            status.duration = (short)Math.max(status.duration, duration);
            status.amplifier = (byte)Math.max(status.amplifier, amplifier);
            if (caster != null) {
                status.casterUUID = caster.func_110124_au();
            }
            if (prevDuration != status.duration || prevAmplifier != status.amplifier) {
                if (!entity.field_70170_p.field_72995_K) {
                    ALNetworkManager.wrapper.sendToDimension((IMessage)new MessageUpdateEffects(entity, list), entity.field_71093_bK);
                }
                Collections.sort(list);
            }
            return;
        }
        list.add(new StatusEffect(effect, duration, amplifier, caster));
        Collections.sort(list);
        if (!entity.field_70170_p.field_72995_K) {
            ALNetworkManager.wrapper.sendToDimension((IMessage)new MessageUpdateEffects(entity, list), entity.field_71093_bK);
        }
    }

    public static List<StatusEffect> get(EntityLivingBase entity) {
        return ALEntityData.getData((EntityLivingBase)entity).activeEffects;
    }

    public static StatusEffect get(EntityLivingBase entity, Effect effect) {
        for (StatusEffect status : StatusEffect.get(entity)) {
            if (status.effect != effect) continue;
            return status;
        }
        return null;
    }

    public static boolean has(EntityLivingBase entity, Effect effect) {
        return StatusEffect.get(entity, effect) != null;
    }

    public static void clear(EntityLivingBase entity) {
        List<StatusEffect> list;
        if (!entity.field_70170_p.field_72995_K && !(list = StatusEffect.get(entity)).isEmpty()) {
            list.clear();
            ALNetworkManager.wrapper.sendToDimension((IMessage)new MessageUpdateEffects(entity, list), entity.field_71093_bK);
        }
    }

    public static void clear(EntityLivingBase entity, Effect effect) {
        if (!entity.field_70170_p.field_72995_K && StatusEffect.has(entity, effect)) {
            List<StatusEffect> list = StatusEffect.get(entity);
            Iterator<StatusEffect> iter = list.iterator();
            while (iter.hasNext()) {
                if (iter.next().effect != effect) continue;
                iter.remove();
            }
            ALNetworkManager.wrapper.sendToDimension((IMessage)new MessageUpdateEffects(entity, list), entity.field_71093_bK);
            if (!list.isEmpty()) {
                Collections.sort(list);
            }
        }
    }

    public static List<EntityLivingBase> getTargets(EntityLivingBase caster, Effect effect, int amplifier) {
        ArrayList targets = Lists.newArrayList();
        for (EntityLivingBase entity : Iterables.filter((Iterable)caster.field_70170_p.field_72996_f, EntityLivingBase.class)) {
            StatusEffect status = StatusEffect.get(entity, effect);
            if (status == null || amplifier >= 0 && amplifier != status.amplifier || status.casterUUID == null || !status.casterUUID.equals(caster.func_110124_au())) continue;
            targets.add(entity);
        }
        return targets;
    }

    public static List<EntityLivingBase> getTargets(EntityLivingBase caster, Effect effect) {
        return StatusEffect.getTargets(caster, effect, -1);
    }

    public String toString() {
        return String.format("Effect[id=%s,d=%s,a=%s]", this.effect, this.duration, this.amplifier);
    }

    @Override
    public int compareTo(StatusEffect o) {
        return Doubles.compare((double)o.duration, (double)this.duration);
    }
}

