/*
 * Decompiled with CFR 0.152.
 */
package com.fiskmods.lightsabers.common.entity;

import com.fiskmods.lightsabers.client.sound.ALSounds;
import com.fiskmods.lightsabers.common.damage.ALDamageSources;
import com.fiskmods.lightsabers.common.entity.EntitySithGhost;
import com.fiskmods.lightsabers.common.item.ItemDoubleLightsaber;
import com.fiskmods.lightsabers.common.item.ModItems;
import com.fiskmods.lightsabers.common.lightsaber.LightsaberData;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import fiskfille.utils.common.entity.attribute.AttributeWrapper;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityLightsaber
extends EntityThrowable
implements IEntityAdditionalSpawnData {
    private ItemStack lightsaber;
    private int amplifier;
    public Object data;

    public EntityLightsaber(World world, EntityLivingBase entity, ItemStack itemstack, int amplifier) {
        super(world, entity);
        this.amplifier = amplifier;
        this.setItem(itemstack);
    }

    public EntityLightsaber(World world) {
        super(world);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(2, (Object)0);
    }

    public boolean getShouldReturn() {
        return this.field_70180_af.func_75683_a(2) > 0;
    }

    public void setShouldReturn(boolean flag) {
        this.field_70180_af.func_75692_b(2, (Object)((byte)(flag ? 1 : 0)));
    }

    public ItemStack getItem() {
        return this.lightsaber;
    }

    public void setItem(ItemStack itemstack) {
        this.lightsaber = itemstack;
        this.data = null;
        if (itemstack != null) {
            if (itemstack.func_77973_b() == ModItems.doubleLightsaber) {
                this.func_70105_a(3.15f / (float)(2 - this.amplifier), 0.0625f);
                this.data = ItemDoubleLightsaber.get(itemstack);
            } else {
                this.func_70105_a(2.0f / (float)(2 - this.amplifier), 0.0625f);
                this.data = LightsaberData.get(itemstack);
            }
        }
    }

    protected float func_70185_h() {
        return 0.01f;
    }

    protected float func_70182_d() {
        return 2.0f;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        if (this.getItem() != null) {
            nbt.func_74782_a("Item", (NBTBase)this.getItem().func_77955_b(new NBTTagCompound()));
        }
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setItem(ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("LightsaberItem")));
    }

    public void func_70071_h_() {
        this.field_70142_S = this.field_70165_t;
        this.field_70137_T = this.field_70163_u;
        this.field_70136_U = this.field_70161_v;
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        if (!this.field_70170_p.field_72995_K) {
            EntityLivingBase thrower = this.func_85052_h();
            if (thrower == null || !thrower.func_70089_S()) {
                if (!(thrower instanceof EntitySithGhost)) {
                    this.dropItem((Entity)this);
                }
                this.func_70106_y();
                return;
            }
            if (this.field_70173_aa % 3 == 0) {
                this.field_70170_p.func_72956_a((Entity)this, thrower instanceof EntityPlayer ? ALSounds.player_lightsaber_swing : ALSounds.mob_lightsaber_swing, 1.0f, 1.0f);
            }
            if (this.field_70173_aa > 20) {
                this.setShouldReturn(true);
            }
            if (thrower != null && this.getShouldReturn()) {
                if (this.func_70032_d((Entity)thrower) <= 2.0f) {
                    if (thrower instanceof EntityPlayer) {
                        EntityPlayer player = (EntityPlayer)thrower;
                        if (player.field_71071_by.func_70448_g() == null) {
                            player.func_70062_b(0, this.getItem());
                        } else if (!player.field_71071_by.func_70441_a(this.getItem())) {
                            this.dropItem((Entity)player);
                        }
                    } else {
                        thrower.func_70062_b(0, this.getItem());
                    }
                    this.func_70106_y();
                } else {
                    Vec3 vec3 = Vec3.func_72443_a((double)(thrower.field_70165_t - this.field_70165_t), (double)(thrower.field_70163_u - this.field_70163_u + (double)thrower.field_70131_O * 0.6), (double)(thrower.field_70161_v - this.field_70161_v)).func_72432_b();
                    double d = 2.0;
                    this.field_70159_w = vec3.field_72450_a * d;
                    this.field_70181_x = vec3.field_72448_b * d;
                    this.field_70179_y = vec3.field_72449_c * d;
                }
            }
        }
        if (!this.getShouldReturn()) {
            super.func_70071_h_();
        } else {
            super.func_70030_z();
            Vec3 pos = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
            Vec3 nextPos = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
            MovingObjectPosition mop = this.field_70170_p.func_72933_a(pos, nextPos);
            pos = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
            nextPos = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
            if (mop != null) {
                nextPos = Vec3.func_72443_a((double)mop.field_72307_f.field_72450_a, (double)mop.field_72307_f.field_72448_b, (double)mop.field_72307_f.field_72449_c);
            }
            if (!this.field_70170_p.field_72995_K) {
                Entity entity = null;
                List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
                double minDist = 0.0;
                for (int i = 0; i < list.size(); ++i) {
                    double dist;
                    AxisAlignedBB aabb;
                    MovingObjectPosition mop1;
                    Entity entity1 = (Entity)list.get(i);
                    if (!entity1.func_70067_L() || entity1 == this.func_85052_h() && this.field_70173_aa < 5 || (mop1 = (aabb = entity1.field_70121_D.func_72314_b((double)0.3f, (double)0.3f, (double)0.3f)).func_72327_a(pos, nextPos)) == null || !((dist = pos.func_72438_d(mop1.field_72307_f)) < minDist) && minDist != 0.0) continue;
                    entity = entity1;
                    minDist = dist;
                }
                if (entity != null) {
                    mop = new MovingObjectPosition(entity);
                }
            }
            if (mop != null) {
                if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && this.field_70170_p.func_147439_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d) == Blocks.field_150427_aO) {
                    this.func_70063_aa();
                } else {
                    this.func_70184_a(mop);
                }
            }
            float motion = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
            this.field_70125_A = (float)(Math.atan2(this.field_70181_x, motion) * 180.0 / Math.PI);
            while (this.field_70125_A - this.field_70127_C < -180.0f) {
                this.field_70127_C -= 360.0f;
            }
            while (this.field_70125_A - this.field_70127_C >= 180.0f) {
                this.field_70127_C += 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B < -180.0f) {
                this.field_70126_B -= 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B >= 180.0f) {
                this.field_70126_B += 360.0f;
            }
            this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
            this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
            if (this.func_70090_H()) {
                for (int i = 0; i < 4; ++i) {
                    float f = 0.25f;
                    this.field_70170_p.func_72869_a("bubble", this.field_70165_t - this.field_70159_w * (double)f, this.field_70163_u - this.field_70181_x * (double)f, this.field_70161_v - this.field_70179_y * (double)f, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                }
            }
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
    }

    public void dropItem(Entity location) {
        EntityItem item = new EntityItem(this.field_70170_p);
        item.func_70012_b(location.field_70165_t, location.field_70163_u, location.field_70161_v, 0.0f, 0.0f);
        item.func_92058_a(this.lightsaber);
        this.field_70170_p.func_72838_d((Entity)item);
    }

    protected void func_70184_a(MovingObjectPosition mop) {
        EntityLivingBase thrower = this.func_85052_h();
        if (thrower != null) {
            if (thrower instanceof EntitySithGhost && mop.field_72308_g instanceof EntitySithGhost) {
                return;
            }
            if (mop.field_72308_g != null && mop.field_72308_g != thrower) {
                if (this.lightsaber != null) {
                    float damage;
                    Collection c = this.lightsaber.func_111283_C().get((Object)SharedMonsterAttributes.field_111264_e.func_111108_a());
                    AttributeWrapper wrapper = new AttributeWrapper(SharedMonsterAttributes.field_111264_e);
                    if (!c.isEmpty()) {
                        for (AttributeModifier modifier : c) {
                            wrapper.apply(modifier.func_111164_d(), modifier.func_111169_c());
                        }
                    }
                    if ((damage = wrapper.getValue(1.0f)) > 0.0f) {
                        mop.field_72308_g.func_70097_a(ALDamageSources.causeLightsaberDamage((Entity)thrower), damage);
                    }
                }
            } else {
                this.setShouldReturn(true);
                this.field_70181_x += 0.2;
            }
        }
    }

    public void writeSpawnData(ByteBuf buffer) {
        ByteBufUtils.writeItemStack((ByteBuf)buffer, (ItemStack)this.getItem());
    }

    public void readSpawnData(ByteBuf buffer) {
        this.setItem(ByteBufUtils.readItemStack((ByteBuf)buffer));
    }
}

