/*
 * Decompiled with CFR 0.152.
 */
package com.fiskmods.lightsabers.common.event;

import com.fiskmods.lightsabers.client.sound.ALSounds;
import com.fiskmods.lightsabers.client.sound.SoundAL;
import com.fiskmods.lightsabers.common.config.ModConfig;
import com.fiskmods.lightsabers.common.data.ALData;
import com.fiskmods.lightsabers.common.data.ALPlayerData;
import com.fiskmods.lightsabers.common.data.effect.Effect;
import com.fiskmods.lightsabers.common.data.effect.StatusEffect;
import com.fiskmods.lightsabers.common.force.Power;
import com.fiskmods.lightsabers.common.force.PowerManager;
import com.fiskmods.lightsabers.common.force.PowerType;
import com.fiskmods.lightsabers.common.force.effect.PowerEffect;
import com.fiskmods.lightsabers.common.force.effect.PowerEffectActive;
import com.fiskmods.lightsabers.common.item.ModItems;
import com.fiskmods.lightsabers.common.keybinds.ALKeyBinds;
import com.fiskmods.lightsabers.common.lightsaber.LightsaberData;
import com.fiskmods.lightsabers.common.lightsaber.PartType;
import com.fiskmods.lightsabers.helper.ALHelper;
import com.fiskmods.lightsabers.helper.ALRenderHelper;
import com.google.common.collect.Maps;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent17;
import net.minecraftforge.event.entity.living.LivingEvent;
import org.lwjgl.opengl.GL11;

public class ClientEventHandler {
    private Minecraft mc = Minecraft.func_71410_x();
    public static float renderTick;
    private Map<String, ItemStack> prevLightsaber1 = Maps.newHashMap();
    private Map<String, Boolean> hasPlayedSound = Maps.newHashMap();

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals("lightsabers")) {
            ModConfig.load(ModConfig.configFile);
            ModConfig.configFile.save();
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.entityLiving;
        ItemStack itemstack = entity.func_70694_bm();
        World world = entity.field_70170_p;
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        World world = player.field_70170_p;
        ALPlayerData data = ALPlayerData.getData(player);
        if (event.phase == TickEvent.Phase.END && player == this.mc.field_71439_g) {
            InventoryPlayer inventory = player.field_71071_by;
            ItemStack lightsaber = null;
            for (int i = 0; i < inventory.field_70462_a.length; ++i) {
                if (inventory.field_70462_a[i] == null || inventory.field_70462_a[i].func_77973_b() != ModItems.lightsaber) continue;
                lightsaber = inventory.field_70462_a[i];
                break;
            }
            ALData.LIGHTSABER.set(player, LightsaberData.get(lightsaber));
            Power power = PowerManager.getSelectedPower(player);
            boolean flag = false;
            if (power != null && ALData.USE_POWER_COOLDOWN.get((Entity)player) == 0 && ALHelper.getForcePowerMax(player) > 0 && power.powerStats.powerType == PowerType.PER_SECOND && this.mc.field_71462_r == null && GameSettings.func_100015_a((KeyBinding)ALKeyBinds.ACTIVATE_POWER)) {
                boolean bl = flag = ((Float)ALData.FORCE_POWER.get((Entity)player)).floatValue() >= power.getUseCost(player);
            }
            if (!flag && ALData.USING_POWER.get((Entity)player).booleanValue()) {
                ALData.USE_POWER_COOLDOWN.set(player, (Integer)20);
            }
            ALData.USING_POWER.set(player, (Boolean)flag);
            flag = false;
            if (ModConfig.enableShaders) {
                if (StatusEffect.get((EntityLivingBase)player, Effect.GAZE) != null) {
                    ALRenderHelper.startShaders(ALRenderHelper.SHADER_BLUE);
                    flag = true;
                } else if (StatusEffect.get((EntityLivingBase)player, Effect.STEALTH) != null) {
                    ALRenderHelper.startShaders(ALRenderHelper.SHADER_GRAY);
                    flag = true;
                } else if (StatusEffect.get((EntityLivingBase)player, Effect.SPEED) != null) {
                    ALRenderHelper.startShaders(ALRenderHelper.SHADER_BLUR);
                    flag = true;
                }
            }
            if (!flag && this.mc.field_71460_t.func_147706_e() != null) {
                ResourceLocation[] shaders;
                String s = this.mc.field_71460_t.func_147706_e().func_148022_b();
                for (ResourceLocation shader : shaders = new ResourceLocation[]{ALRenderHelper.SHADER_BLUE, ALRenderHelper.SHADER_GRAY, ALRenderHelper.SHADER_BLUR}) {
                    if (!s.equals(shader.toString())) continue;
                    ALRenderHelper.stopShaders();
                }
            }
        }
    }

    @SubscribeEvent
    public void onRenderPlayerSpecialsPre(RenderPlayerEvent.Specials.Pre event) {
        EntityPlayer player = event.entityPlayer;
        LightsaberData data = ALData.LIGHTSABER.get((Entity)player);
        if (data != null && data != LightsaberData.EMPTY && (player.func_70694_bm() == null || player.func_70694_bm().func_77973_b() != ModItems.lightsaber)) {
            GL11.glPushMatrix();
            event.renderer.field_77109_a.field_78115_e.func_78794_c(0.0625f);
            GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glTranslatef((float)0.2f, (float)-0.55f, (float)0.15f);
            GL11.glRotatef((float)15.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)10.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            float scale = 0.15f;
            GL11.glScalef((float)scale, (float)scale, (float)scale);
            GL11.glTranslatef((float)0.0f, (float)(-(data.getPart((PartType)PartType.BODY).height + data.getPart((PartType)PartType.POMMEL).height / 2.0f) * 0.0625f), (float)0.0f);
            ALRenderHelper.renderLightsaberHilt(data);
            GL11.glPopMatrix();
        }
        for (StatusEffect status : StatusEffect.get((EntityLivingBase)player)) {
            Power power = status.effect.getPower(status.amplifier);
            PowerEffect powerEffect = power.powerEffect;
            if (!(powerEffect instanceof PowerEffectActive)) continue;
            ((PowerEffectActive)powerEffect).render(player, event.partialRenderTick);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onRenderLivingSpecialsPre(RenderLivingEvent.Pre event) {
        EntityLivingBase entity = event.entity;
        StatusEffect effectStun = StatusEffect.get(entity, Effect.STUN);
        if (effectStun != null) {
            boolean prevLighting = GL11.glGetBoolean((int)2896);
            boolean prevTex2D = GL11.glGetBoolean((int)3553);
            boolean prevBlend = GL11.glGetBoolean((int)3042);
            float prevWidth = GL11.glGetFloat((int)2849);
            GL11.glPushMatrix();
            GL11.glTranslated((double)event.x, (double)(event.y + (double)(entity.field_70131_O / 2.0f)), (double)event.z);
            Tessellator tessellator = Tessellator.field_78398_a;
            ALRenderHelper.setLighting(61680);
            GL11.glLineWidth((float)5.0f);
            GL11.glDepthMask((boolean)false);
            GL11.glDisable((int)3553);
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            GL11.glAlphaFunc((int)516, (float)0.99f);
            GL11.glDisable((int)3008);
            GL11.glBlendFunc((int)770, (int)32772);
            float f = (float)entity.field_70173_aa + renderTick;
            float range = Math.max(entity.field_70130_N, entity.field_70131_O) * 0.75f;
            float angleIncr = 10.0f;
            float coverage = 90.0f;
            int amount = 8;
            float spread = 8.0f;
            for (int i = 0; i < 2; ++i) {
                for (int j = -amount; j <= amount; ++j) {
                    for (int k = -amount; k <= amount; ++k) {
                        GL11.glPushMatrix();
                        if (i == 0) {
                            GL11.glScalef((float)-1.0f, (float)-1.0f, (float)-1.0f);
                        }
                        tessellator.func_78371_b(3);
                        tessellator.func_78370_a(54, 84, 181, (int)(50.0f * Math.min(((float)effectStun.duration - renderTick) / 20.0f, 1.0f)));
                        int l = 0;
                        while ((float)l <= coverage / angleIncr) {
                            Vec3 vec3 = Vec3.func_72443_a((double)0.0, (double)range, (double)0.0);
                            float pitch = (float)l * angleIncr;
                            float yaw = 180.0f + (float)j * spread + MathHelper.func_76126_a((float)(f / 10.0f)) * 100.0f;
                            float roll = (float)k * spread + MathHelper.func_76134_b((float)(f / 10.0f)) * 100.0f;
                            vec3.func_72440_a(-pitch * (float)Math.PI / 180.0f);
                            vec3.func_72442_b(-yaw * (float)Math.PI / 180.0f);
                            vec3.func_72446_c(-roll * (float)Math.PI / 180.0f);
                            tessellator.func_78377_a(vec3.field_72450_a, vec3.field_72448_b, vec3.field_72449_c);
                            ++l;
                        }
                        tessellator.func_78381_a();
                        GL11.glPopMatrix();
                    }
                }
            }
            GL11.glLineWidth((float)prevWidth);
            GL11.glAlphaFunc((int)516, (float)0.1f);
            GL11.glEnable((int)3008);
            GL11.glDepthMask((boolean)true);
            if (prevLighting) {
                GL11.glEnable((int)2896);
            }
            if (prevTex2D) {
                GL11.glEnable((int)3553);
            }
            if (!prevBlend) {
                GL11.glDisable((int)3042);
            }
            ALRenderHelper.resetLighting();
            GL11.glPopMatrix();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onRenderLivingPre(RenderLivingEvent.Pre event) {
        boolean prevLighting;
        float f;
        short i;
        EntityLivingBase entity = event.entity;
        StatusEffect effectGaze = StatusEffect.get((EntityLivingBase)this.mc.field_71439_g, Effect.GAZE);
        StatusEffect effectMeditation = StatusEffect.get(entity, Effect.MEDITATION);
        StatusEffect effectEnergyResist = StatusEffect.get(entity, Effect.RESIST);
        if (!(StatusEffect.get(entity, Effect.STEALTH) == null || effectGaze != null && ALRenderHelper.canGazeEntity((EntityPlayer)this.mc.field_71439_g, entity, effectGaze.amplifier))) {
            event.setCanceled(true);
            return;
        }
        boolean flag1 = false;
        float f5 = entity.field_70126_B + (entity.field_70177_z - entity.field_70126_B) * renderTick;
        if (entity != this.mc.field_71439_g && entity != this.mc.field_71439_g.field_70154_o && effectGaze != null && ALRenderHelper.canGazeEntity((EntityPlayer)this.mc.field_71439_g, entity, effectGaze.amplifier) && entity.field_70138_W > 0.0f) {
            i = effectGaze.duration;
            f = i > 100 ? 1.0f : 0.2f + MathHelper.func_76126_a((float)(((float)i - renderTick) * (float)Math.PI * 0.2f)) * 0.2f;
            prevLighting = GL11.glGetBoolean((int)2896);
            boolean flag = entity.func_82150_aj();
            entity.field_70138_W = -entity.field_70138_W;
            entity.func_82142_c(false);
            ALRenderHelper.setLighting(61680);
            if (!flag1) {
                RenderManager.field_78727_a.func_147940_a((Entity)entity, event.x, event.y + (double)(entity == this.mc.field_71439_g ? entity.field_70129_M : 0.0f), event.z, f5, renderTick);
                flag1 = true;
            }
            GL11.glPushMatrix();
            GL11.glDepthMask((boolean)false);
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            GL11.glDisable((int)3553);
            GL11.glAlphaFunc((int)516, (float)0.01f);
            GL11.glDisable((int)3008);
            GL11.glBlendFunc((int)770, (int)32772);
            GL11.glDisable((int)2929);
            GL11.glDepthFunc((int)514);
            if (flag) {
                GL11.glColor4f((float)1.0f, (float)0.0f, (float)1.0f, (float)f);
            } else {
                GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)f);
            }
            ALRenderHelper.overrideColor(true);
            RenderManager.field_78727_a.func_147940_a((Entity)entity, event.x, event.y + (double)(entity == this.mc.field_71439_g ? entity.field_70129_M : 0.0f), event.z, f5, renderTick);
            ALRenderHelper.overrideColor(false);
            GL11.glDepthFunc((int)515);
            GL11.glDisable((int)32826);
            GL11.glAlphaFunc((int)516, (float)0.1f);
            GL11.glEnable((int)3008);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glEnable((int)3553);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)2929);
            GL11.glDepthMask((boolean)true);
            entity.func_82142_c(flag);
            ALRenderHelper.resetLighting();
            if (prevLighting) {
                GL11.glEnable((int)2896);
            }
            GL11.glPopMatrix();
            entity.field_70138_W = -entity.field_70138_W;
            event.setCanceled(true);
        }
        if (effectMeditation != null && !entity.func_98034_c((EntityPlayer)this.mc.field_71439_g) && entity.field_70138_W > 0.0f) {
            i = effectMeditation.duration;
            f = 0.7f + MathHelper.func_76126_a((float)(((float)i - renderTick) * (float)Math.PI * 0.1f)) * 0.3f;
            prevLighting = GL11.glGetBoolean((int)2896);
            entity.field_70138_W = -entity.field_70138_W;
            ALRenderHelper.setLighting(61680);
            if (!flag1) {
                RenderManager.field_78727_a.func_147940_a((Entity)entity, event.x, event.y + (double)(entity == this.mc.field_71439_g ? entity.field_70129_M : 0.0f), event.z, f5, renderTick);
                flag1 = true;
            }
            GL11.glPushMatrix();
            GL11.glDepthMask((boolean)false);
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            GL11.glDisable((int)3553);
            GL11.glAlphaFunc((int)516, (float)0.01f);
            GL11.glDisable((int)3008);
            GL11.glBlendFunc((int)770, (int)32772);
            GL11.glDepthFunc((int)514);
            GL11.glColor4f((float)1.0f, (float)0.5f, (float)0.0f, (float)f);
            ALRenderHelper.overrideColor(true);
            RenderManager.field_78727_a.func_147940_a((Entity)entity, event.x, event.y + (double)(entity == this.mc.field_71439_g ? entity.field_70129_M : 0.0f), event.z, f5, renderTick);
            ALRenderHelper.overrideColor(false);
            GL11.glDepthFunc((int)515);
            GL11.glDisable((int)32826);
            GL11.glAlphaFunc((int)516, (float)0.1f);
            GL11.glEnable((int)3008);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glEnable((int)3553);
            GL11.glDisable((int)3042);
            GL11.glDepthMask((boolean)true);
            ALRenderHelper.resetLighting();
            if (prevLighting) {
                GL11.glEnable((int)2896);
            }
            GL11.glPopMatrix();
            entity.field_70138_W = -entity.field_70138_W;
            event.setCanceled(true);
        }
        if (effectEnergyResist != null && !entity.func_98034_c((EntityPlayer)this.mc.field_71439_g) && entity.field_70138_W > 0.0f) {
            i = effectEnergyResist.duration;
            f = 0.7f + MathHelper.func_76126_a((float)(((float)i - renderTick) * (float)Math.PI * 0.1f)) * 0.3f;
            prevLighting = GL11.glGetBoolean((int)2896);
            entity.field_70138_W = -entity.field_70138_W;
            ALRenderHelper.setLighting(61680);
            if (!flag1) {
                RenderManager.field_78727_a.func_147940_a((Entity)entity, event.x, event.y + (double)(entity == this.mc.field_71439_g ? entity.field_70129_M : 0.0f), event.z, f5, renderTick);
                flag1 = true;
            }
            GL11.glPushMatrix();
            GL11.glDepthMask((boolean)false);
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            GL11.glDisable((int)3553);
            GL11.glAlphaFunc((int)516, (float)0.01f);
            GL11.glDisable((int)3008);
            GL11.glBlendFunc((int)770, (int)32772);
            GL11.glDepthFunc((int)514);
            GL11.glColor4f((float)0.0f, (float)0.5f, (float)1.0f, (float)f);
            ALRenderHelper.overrideColor(true);
            RenderManager.field_78727_a.func_147940_a((Entity)entity, event.x, event.y + (double)(entity == this.mc.field_71439_g ? entity.field_70129_M : 0.0f), event.z, f5, renderTick);
            ALRenderHelper.overrideColor(false);
            GL11.glDepthFunc((int)515);
            GL11.glDisable((int)32826);
            GL11.glAlphaFunc((int)516, (float)0.1f);
            GL11.glEnable((int)3008);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glEnable((int)3553);
            GL11.glDisable((int)3042);
            GL11.glDepthMask((boolean)true);
            ALRenderHelper.resetLighting();
            if (prevLighting) {
                GL11.glEnable((int)2896);
            }
            GL11.glPopMatrix();
            entity.field_70138_W = -entity.field_70138_W;
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onSound(PlaySoundEvent17 event) {
        String name;
        if (!(this.mc.field_71439_g == null || (name = "lightsabers:" + event.name).equals(ALSounds.player_force_stealth_on) || name.equals(ALSounds.player_force_stealth_off) || name.startsWith(ALSounds.ambient_stealth) || StatusEffect.get((EntityLivingBase)this.mc.field_71439_g, Effect.STEALTH) == null)) {
            ISound sound = event.sound;
            event.result = new SoundAL(sound.func_147650_b(), sound.func_147653_e() * 0.05f, sound.func_147655_f(), sound.func_147657_c(), sound.func_147652_d(), sound.func_147656_j(), sound.func_147649_g(), sound.func_147654_h(), sound.func_147651_i());
        }
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        renderTick = event.renderTickTime;
    }
}

