/*
 * Decompiled with CFR 0.152.
 */
package com.fiskmods.lightsabers.common.event;

import com.fiskmods.lightsabers.Lightsabers;
import com.fiskmods.lightsabers.client.sound.ALSounds;
import com.fiskmods.lightsabers.common.block.ModBlocks;
import com.fiskmods.lightsabers.common.container.ContainerCrystalPouch;
import com.fiskmods.lightsabers.common.container.InventoryCrystalPouch;
import com.fiskmods.lightsabers.common.damage.ALDamageSources;
import com.fiskmods.lightsabers.common.damage.ALDamageTypes;
import com.fiskmods.lightsabers.common.data.ALData;
import com.fiskmods.lightsabers.common.data.ALEntityData;
import com.fiskmods.lightsabers.common.data.ALPlayerData;
import com.fiskmods.lightsabers.common.data.effect.Effect;
import com.fiskmods.lightsabers.common.data.effect.StatusEffect;
import com.fiskmods.lightsabers.common.entity.EntityForceLightning;
import com.fiskmods.lightsabers.common.force.Power;
import com.fiskmods.lightsabers.common.force.PowerData;
import com.fiskmods.lightsabers.common.force.PowerManager;
import com.fiskmods.lightsabers.common.force.PowerType;
import com.fiskmods.lightsabers.common.force.effect.PowerEffectActive;
import com.fiskmods.lightsabers.common.force.effect.PowerEffectChoke;
import com.fiskmods.lightsabers.common.force.effect.PowerEffectFortify;
import com.fiskmods.lightsabers.common.force.effect.PowerEffectMeditation;
import com.fiskmods.lightsabers.common.force.effect.PowerEffectResist;
import com.fiskmods.lightsabers.common.item.ModItems;
import com.fiskmods.lightsabers.common.network.ALNetworkManager;
import com.fiskmods.lightsabers.common.network.MessageBroadcastState;
import com.fiskmods.lightsabers.common.network.MessagePlayerJoin;
import com.fiskmods.lightsabers.helper.ALHelper;
import com.google.common.collect.Iterables;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import fiskfille.utils.helper.FiskServerUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StringUtils;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class CommonEventHandler {
    private List<EntityPlayer> playersToSync = new ArrayList<EntityPlayer>();

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        Entity entity = event.entity;
        World world = entity.field_70170_p;
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (!world.field_72995_K) {
                this.playersToSync.add(player);
            }
        }
    }

    @SubscribeEvent
    public void onEntityConstruct(EntityEvent.EntityConstructing event) {
        event.entity.registerExtendedProperties("ALEntity", (IExtendedEntityProperties)new ALEntityData());
        if (event.entity instanceof EntityPlayer) {
            event.entity.registerExtendedProperties("ALPlayer", (IExtendedEntityProperties)new ALPlayerData());
        }
    }

    @SubscribeEvent
    public void onStartTracking(PlayerEvent.StartTracking event) {
        EntityPlayer player = event.entityPlayer;
        if (player != null && !player.field_70170_p.field_72995_K && event.target instanceof EntityPlayer) {
            EntityPlayerMP tracked = (EntityPlayerMP)event.target;
            ALNetworkManager.wrapper.sendTo((IMessage)new MessageBroadcastState(player), tracked);
            ALNetworkManager.wrapper.sendTo((IMessage)new MessageBroadcastState((EntityPlayer)tracked), (EntityPlayerMP)player);
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        ALPlayerData.getData(event.entityPlayer).copy(ALPlayerData.getData(event.original));
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        World world = player.field_70170_p;
        if (event.phase == TickEvent.Phase.END) {
            boolean leftArm;
            float f;
            Object effect;
            List list1;
            List<Power> selectedPowers = ALData.SELECTED_POWERS.get((Entity)player);
            for (int i = 0; i < selectedPowers.size(); ++i) {
                Set<Power> set;
                Power power = selectedPowers.get(i);
                if (power == null) continue;
                while (!(set = ALHelper.getUnlockedChildren(player, power)).isEmpty()) {
                    power = (Power)Iterables.get(set, (int)0);
                }
                while (power != null && !PowerManager.hasPowerUnlocked(player, power)) {
                    power = power.parent;
                }
                selectedPowers.set(i, power);
            }
            if (ALData.USING_POWER.get((Entity)player).booleanValue()) {
                ALData.TICKS_USING_POWER.incrWithoutNotify((Entity)player, 1);
            } else {
                ALData.TICKS_USING_POWER.setWithoutNotify((Entity)player, 0);
            }
            Power power = PowerManager.getSelectedPower(player);
            if (player.func_70089_S()) {
                PowerData data;
                Power power1;
                String drainingTo;
                int max = ALHelper.getForcePowerMax(player);
                if (max > 0) {
                    if (ALData.USE_POWER_COOLDOWN.get((Entity)player) > 0) {
                        ALData.USE_POWER_COOLDOWN.incrWithoutNotify((Entity)player, -1);
                    }
                    if (power != null && ALData.USING_POWER.get((Entity)player).booleanValue()) {
                        if (power.powerStats.powerType == PowerType.PER_SECOND && ((Float)ALData.FORCE_POWER.get((Entity)player)).floatValue() >= power.getUseCost(player) && power.powerEffect.execute(player, event.side)) {
                            ALData.FORCE_POWER.incrWithoutNotify((Entity)player, Float.valueOf(-power.getUseCost(player) / 20.0f));
                        }
                    } else if (((Float)ALData.FORCE_POWER_DIFF.get((Entity)player)).floatValue() <= ((Float)ALData.FORCE_POWER.get((Entity)player)).floatValue()) {
                        ALData.FORCE_POWER.incrWithoutNotify((Entity)player, Float.valueOf(ALHelper.getForcePowerRegen(player) / 20.0f));
                    }
                    ALData.FORCE_POWER.clampWithoutNotify((Entity)player, Float.valueOf(0.0f), Float.valueOf(max));
                }
                if (!StringUtils.func_151246_b((String)(drainingTo = ALData.DRAINING_XP_TO.get((Entity)player))) && (power1 = Power.getPowerFromName(drainingTo)) != null && (data = PowerManager.getPowerData(player, power1)) != null && !data.isUnlocked()) {
                    if (data.xpInvested >= power1.getActualXpCost(player)) {
                        data.setUnlocked((Entity)player, true);
                        ALData.BASE_POWER.incrWithoutNotify((Entity)player, (byte)(power1.powerStats.baseBonus - power1.powerStats.baseRequirement));
                        if (Lightsabers.proxy.isClientPlayer((EntityLivingBase)player)) {
                            player.func_85030_a(ALSounds.block_holocron_unlock, 1.0f, 1.0f);
                        }
                    } else {
                        int i = power1.getActualXpCost(player) / 40;
                        if (i > MathHelper.func_76141_d((float)ALData.FORCE_XP.get((Entity)player).floatValue())) {
                            i = MathHelper.func_76141_d((float)ALData.FORCE_XP.get((Entity)player).floatValue());
                        }
                        if (i > power1.getActualXpCost(player) - data.xpInvested) {
                            i = power1.getActualXpCost(player) - data.xpInvested;
                        }
                        data.xpInvested += i;
                        ALData.FORCE_XP.incrWithoutNotify((Entity)player, Float.valueOf(-((float)i)));
                        if (Lightsabers.proxy.isClientPlayer((EntityLivingBase)player)) {
                            Random rand = new Random();
                            player.func_85030_a(ALSounds.block_holocron_invest, 1.0f, 1.1f + (rand.nextFloat() - rand.nextFloat()) * 0.2f);
                        }
                    }
                }
            }
            if (((Float)ALData.FORCE_POWER_DIFF.get((Entity)player)).floatValue() > ((Float)ALData.FORCE_POWER.get((Entity)player)).floatValue()) {
                ALData.FORCE_POWER_DIFF.incrWithoutNotify((Entity)player, Float.valueOf(-7.5f));
                ALData.FORCE_POWER_DIFF.clampWithoutNotify((Entity)player, Float.valueOf(0.0f), (Float)ALData.FORCE_POWER_DIFF.get((Entity)player));
            } else {
                ALData.FORCE_POWER_DIFF.setWithoutNotify((Entity)player, (Float)ALData.FORCE_POWER.get((Entity)player));
            }
            if (((Float)ALData.FORCE_PUSHING_TIMER.get((Entity)player)).floatValue() > 0.0f) {
                ALData.FORCE_PUSHING_TIMER.incrWithoutNotify((Entity)player, Float.valueOf(-0.075f));
                ALData.FORCE_PUSHING_TIMER.clampWithoutNotify((Entity)player, Float.valueOf(0.0f), Float.valueOf(1.0f));
            } else {
                ALData.FORCE_PUSHING_TIMER.setWithoutNotify((Entity)player, Float.valueOf(0.0f));
            }
            StatusEffect effectLightning = StatusEffect.get((EntityLivingBase)player, Effect.LIGHTNING);
            if ((((Float)ALData.DRAIN_LIFE_TIMER.get((Entity)player)).floatValue() > 0.0f || effectLightning != null) && world.field_72995_K) {
                world.func_72838_d((Entity)new EntityForceLightning(world, (EntityLivingBase)player));
            }
            if (((Float)ALData.DRAIN_LIFE_TIMER.get((Entity)player)).floatValue() > 0.0f) {
                float decr = 0.033333335f;
                ALData.DRAIN_LIFE_TIMER.incrWithoutNotify((Entity)player, Float.valueOf(-decr));
                ALData.DRAIN_LIFE_TIMER.clampWithoutNotify((Entity)player, Float.valueOf(0.0f), Float.valueOf(1.0f));
                list1 = world.field_72996_f;
                for (int i = 0; i < list1.size(); ++i) {
                    EntityLivingBase entity;
                    if (!(list1.get(i) instanceof EntityLivingBase) || (effect = StatusEffect.get(entity = (EntityLivingBase)list1.get(i), Effect.DRAIN)) == null || ((StatusEffect)effect).casterUUID == null || !((StatusEffect)effect).casterUUID.equals(player.func_110124_au())) continue;
                    f = decr * (float)(4 + ((StatusEffect)effect).amplifier * 2) * 5.0f;
                    float prevHealth = entity.func_110143_aJ();
                    if (((StatusEffect)effect).duration % 5 == 0) {
                        entity.field_70172_ad = 0;
                        entity.func_70097_a(ALDamageSources.causeForceLightningDamage((Entity)player), f);
                        player.func_70691_i(Math.max(prevHealth - entity.func_110143_aJ(), 0.0f));
                    }
                    entity.field_70159_w = 0.0;
                    entity.field_70181_x = 0.05f;
                    entity.field_70179_y = 0.0;
                }
            } else {
                ALData.DRAIN_LIFE_TIMER.setWithoutNotify((Entity)player, Float.valueOf(0.0f));
            }
            if (!StatusEffect.getTargets((EntityLivingBase)player, Effect.CHOKE).isEmpty()) {
                float decr = 0.016666668f;
                list1 = world.field_72996_f;
                for (int i = 0; i < list1.size(); ++i) {
                    EntityLivingBase entity;
                    if (!(list1.get(i) instanceof EntityLivingBase) || (effect = StatusEffect.get(entity = (EntityLivingBase)list1.get(i), Effect.CHOKE)) == null || ((StatusEffect)effect).casterUUID == null || !((StatusEffect)effect).casterUUID.equals(player.func_110124_au())) continue;
                    f = decr * (float)(2 + ((StatusEffect)effect).amplifier * 2) * 5.0f;
                    if (((StatusEffect)effect).duration % 5 == 0) {
                        entity.field_70172_ad = 0;
                        entity.func_70097_a(ALDamageSources.causeForceDamage((Entity)player), f);
                    }
                    entity.field_70159_w = 0.0;
                    entity.field_70181_x = 0.001f * (float)((StatusEffect)effect).duration;
                    entity.field_70179_y = 0.0;
                }
            }
            boolean rightArm = effectLightning != null || !StatusEffect.getTargets((EntityLivingBase)player, Effect.CHOKE).isEmpty();
            boolean bl = leftArm = effectLightning != null || !StatusEffect.getTargets((EntityLivingBase)player, Effect.CHOKE, 2).isEmpty();
            if (rightArm) {
                ALData.RIGHT_ARM_TIMER.incrWithoutNotify((Entity)player, Float.valueOf(0.33f));
            } else {
                ALData.RIGHT_ARM_TIMER.incrWithoutNotify((Entity)player, Float.valueOf(-0.33f));
            }
            if (leftArm) {
                ALData.LEFT_ARM_TIMER.incrWithoutNotify((Entity)player, Float.valueOf(0.33f));
            } else {
                ALData.LEFT_ARM_TIMER.incrWithoutNotify((Entity)player, Float.valueOf(-0.33f));
            }
            boolean flag = ALData.USING_POWER.get((Entity)player);
            boolean flag1 = ALData.PREV_USING_POWER.get((Entity)player);
            if (power != null && power.powerEffect instanceof PowerEffectActive) {
                effect = (PowerEffectActive)power.powerEffect;
                if (flag && !flag1) {
                    ((PowerEffectActive)effect).start(player, event.side);
                }
                if (!flag && flag1) {
                    ((PowerEffectActive)effect).stop(player, event.side);
                }
            }
            if (ALData.PREV_XP.get((Entity)player) < ALHelper.getTotalXp(player)) {
                float f2 = ALHelper.getTotalXp(player) - ALData.PREV_XP.get((Entity)player);
                ALData.FORCE_XP.incrWithoutNotify((Entity)player, Float.valueOf(f2 / 2.0f));
            }
            if (ALData.BASE_POWER.get((Entity)player) < 0) {
                ALData.BASE_POWER.setWithoutNotify((Entity)player, (byte)Math.max(ALHelper.getBasePower(player), 0));
            }
            if (PowerManager.hasPowerUnlocked(player, Power.FORCE_SENSITIVITY)) {
                PowerManager.getPowerData(player, Power.LIGHT_SIDE).setUnlocked((Entity)player, true);
                PowerManager.getPowerData(player, Power.DARK_SIDE).setUnlocked((Entity)player, true);
                PowerManager.getPowerData(player, Power.NEUTRAL).setUnlocked((Entity)player, true);
            }
            ALData.FORCE_POWER.clampWithoutNotify((Entity)player, Float.valueOf(0.0f), Float.valueOf(ALHelper.getForcePowerMax(player)));
            ALData.FORCE_POWER_DIFF.clampWithoutNotify((Entity)player, Float.valueOf(0.0f), Float.valueOf(ALHelper.getForcePowerMax(player)));
            ALData.PREV_XP.setWithoutNotify((Entity)player, ALHelper.getTotalXp(player));
            ALData.PREV_USING_POWER.setWithoutNotify((Entity)player, ALData.USING_POWER.get((Entity)player));
            ALData.RIGHT_ARM_TIMER.clampWithoutNotify((Entity)player, Float.valueOf(0.0f), Float.valueOf(1.0f));
            ALData.LEFT_ARM_TIMER.clampWithoutNotify((Entity)player, Float.valueOf(0.0f), Float.valueOf(1.0f));
        } else {
            ALData.onUpdate((Entity)player);
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.entityLiving;
        ALEntityData data = ALEntityData.getData(entity);
        if (data.forcePushed && entity.field_70132_H && !entity.field_70122_E) {
            data.forcePushed = false;
            entity.field_70172_ad = 0;
            double motX = entity.field_70169_q - entity.field_70165_t;
            double motY = entity.field_70167_r - entity.field_70163_u;
            double motZ = entity.field_70166_s - entity.field_70161_v;
            double vel = MathHelper.func_76133_a((double)(motX * motX + motY * motY + motZ * motZ));
            float damage = (float)Math.max(vel * 5.0 - 3.0, 0.0);
            if (damage > 0.0f) {
                entity.func_70097_a(ALDamageSources.INTO_WALL, damage);
            }
        }
        for (int i = 0; i < data.activeEffects.size(); ++i) {
            StatusEffect status = data.activeEffects.get(i);
            status.duration = (short)(status.duration - 1);
            if (status.duration > 0) continue;
            data.activeEffects.remove(i);
            if (status.effect != Effect.CHOKE) continue;
            StatusEffect.add(entity, Effect.STUN, (int)(PowerEffectChoke.getStunDuration(status.amplifier) * 20.0f), 0);
        }
        IAttributeInstance speedAttribute = entity.func_110148_a(SharedMonsterAttributes.field_111263_d);
        if (speedAttribute != null) {
            UUID stunModifierUUID = UUID.fromString("B2AB4DE3-8276-4B86-A448-230FA6FDC689");
            UUID speedModifierUUID = UUID.fromString("A1AB4DE3-8276-4B86-A448-480FA6DDB389");
            AttributeModifier stunModifier = new AttributeModifier(stunModifierUUID, "Stun speed boost", -1.0, 1).func_111168_a(false);
            AttributeModifier speedModifier = new AttributeModifier(speedModifierUUID, "Force speed boost", 1.0, 1).func_111168_a(false);
            if (speedAttribute.func_111127_a(stunModifierUUID) != null) {
                speedAttribute.func_111124_b(stunModifier);
            }
            if (speedAttribute.func_111127_a(speedModifierUUID) != null) {
                speedAttribute.func_111124_b(speedModifier);
            }
            if (StatusEffect.get(entity, Effect.STUN) != null) {
                speedAttribute.func_111121_a(stunModifier);
                entity.field_70160_al = false;
                entity.field_70181_x = -0.2f;
                entity.func_70637_d(false);
            }
            if (StatusEffect.get(entity, Effect.SPEED) != null) {
                speedAttribute.func_111121_a(speedModifier);
            }
        }
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            if (!player.field_70170_p.field_72995_K && this.playersToSync.size() > 0 && this.playersToSync.contains(player)) {
                ALNetworkManager.wrapper.sendTo((IMessage)new MessagePlayerJoin(player), (EntityPlayerMP)player);
                this.playersToSync.remove(player);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingFall(LivingFallEvent event) {
        EntityPlayer player;
        float force;
        if (event.entity instanceof EntityPlayer && event.distance > 3.0f && (force = ((Float)ALData.FORCE_POWER.get((Entity)(player = (EntityPlayer)event.entity))).floatValue()) > 0.0f && PowerManager.hasPowerUnlocked(player, Power.REBOUND)) {
            float cost = Power.REBOUND.getUseCost(player);
            float amount = Math.min(Math.max(event.distance - 3.0f, 0.0f), (float)MathHelper.func_76141_d((float)(force / cost)));
            if (amount > 0.0f) {
                event.distance -= amount;
                if (!event.entity.field_70170_p.field_72995_K) {
                    ALData.FORCE_POWER.incr(player, Float.valueOf(-cost * amount));
                }
                player.func_85030_a(ALSounds.player_force_cast, Math.min((amount -= 3.0f) / 10.0f + 0.2f, 1.0f), 1.0f);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onLivingAttack(LivingAttackEvent event) {
        EntityLivingBase attacker;
        if (event.source.func_76346_g() instanceof EntityLivingBase && StatusEffect.has(attacker = (EntityLivingBase)event.source.func_76346_g(), Effect.STUN)) {
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        EntityLivingBase attacker;
        StatusEffect effectMeditation;
        EntityLivingBase entity = event.entityLiving;
        StatusEffect effectFortify = StatusEffect.get(entity, Effect.FORTIFY);
        StatusEffect effectEnergyResist = StatusEffect.get(entity, Effect.RESIST);
        if (event.source.func_76346_g() instanceof EntityLivingBase && (effectMeditation = StatusEffect.get(attacker = (EntityLivingBase)event.source.func_76346_g(), Effect.MEDITATION)) != null && FiskServerUtils.isMeleeDamage(event.source)) {
            event.ammount *= PowerEffectMeditation.getModifierAmount(effectMeditation.amplifier);
        }
        if (effectFortify != null && ALDamageTypes.FORCE.isPresent(event.source)) {
            event.ammount /= PowerEffectFortify.getModifierAmount(effectFortify.amplifier);
        }
        if (effectEnergyResist != null && ALDamageTypes.LIGHTSABER.isPresent(event.source)) {
            event.ammount /= PowerEffectResist.getModifierAmount(effectEnergyResist.amplifier);
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        ALEntityData.getData((EntityLivingBase)event.entityLiving).activeEffects.clear();
        if (event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            if (!player.field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
                ALData.FORCE_XP.set(player, Float.valueOf(MathHelper.func_76141_d((float)(ALData.FORCE_XP.get((Entity)player).floatValue() * 0.7f))));
            } else {
                ALData.FORCE_XP.set(player, Float.valueOf(0.0f));
            }
            ALData.onDeath((Entity)player);
        }
    }

    @SubscribeEvent
    public void onEntityItemPickup(EntityItemPickupEvent event) {
        EntityPlayer player = event.entityPlayer;
        ItemStack item = event.item.func_92059_d();
        if (item != null && item.func_77973_b() == Item.func_150898_a((Block)ModBlocks.lightsaberCrystal)) {
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack itemstack = player.field_71071_by.func_70301_a(i);
                if (itemstack == null || itemstack.func_77973_b() != ModItems.crystalPouch) continue;
                InventoryCrystalPouch pouch = new InventoryCrystalPouch(player, i);
                if (player.field_71070_bA instanceof ContainerCrystalPouch) {
                    InventoryCrystalPouch inventory = ((ContainerCrystalPouch)player.field_71070_bA).inventory;
                    if (inventory.itemSlot == i) {
                        pouch = inventory;
                    }
                }
                pouch.addItemStackToInventory(item);
                pouch.func_70296_d();
                if (item.field_77994_a <= 0) break;
            }
        }
    }
}

