/*
 * Decompiled with CFR 0.152.
 */
package com.fiskmods.lightsabers.common.force;

import com.fiskmods.lightsabers.common.force.Power;
import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.util.EnumChatFormatting;

public enum ForceSide {
    NONE(EnumChatFormatting.WHITE),
    LIGHT(EnumChatFormatting.AQUA),
    DARK(EnumChatFormatting.RED),
    NEUTRAL(EnumChatFormatting.YELLOW);

    public final EnumChatFormatting theme;
    public final Set<Power> powers = Sets.newHashSet();

    private ForceSide(EnumChatFormatting formatting) {
        this.theme = formatting;
    }

    public Power getPower() {
        switch (this) {
            case LIGHT: {
                return Power.LIGHT_SIDE;
            }
            case DARK: {
                return Power.DARK_SIDE;
            }
            case NEUTRAL: {
                return Power.NEUTRAL;
            }
        }
        return null;
    }

    public ForceSide getOpposite() {
        switch (this) {
            case LIGHT: {
                return DARK;
            }
            case DARK: {
                return LIGHT;
            }
        }
        return this;
    }

    public boolean isPolar() {
        return this == LIGHT || this == DARK;
    }
}

