/*
 * Decompiled with CFR 0.152.
 */
package com.fiskmods.lightsabers.common.force;

import com.fiskmods.lightsabers.common.data.ALData;
import com.fiskmods.lightsabers.common.force.Power;
import com.fiskmods.lightsabers.common.force.PowerStats;
import cpw.mods.fml.common.network.ByteBufUtils;
import fiskfille.utils.helper.NBTHelper;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class PowerData
implements Comparable<PowerData>,
NBTHelper.ISerializableObject<PowerData> {
    public final Power power;
    public int xpInvested;
    private boolean unlocked;

    public PowerData(Power p) {
        this.power = p;
    }

    public boolean isUnlocked() {
        return this.unlocked;
    }

    public void setUnlocked(Entity entity, boolean b) {
        if (b != this.unlocked) {
            this.unlocked = b;
            ALData.POWERS.get(entity).markDirty(entity);
        }
    }

    public int hashCode() {
        int hashCode = this.power.hashCode();
        hashCode = hashCode * 31 + (this.unlocked ? 1 : 0);
        hashCode = hashCode * 31 + this.xpInvested;
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PowerData) {
            PowerData data = (PowerData)obj;
            return this.power == data.power && this.unlocked == data.unlocked && this.xpInvested == data.xpInvested;
        }
        return false;
    }

    public String toString() {
        return String.format("PowerData[\"%s\",x=%s,xp=%s]", this.power.getName(), this.unlocked, this.xpInvested);
    }

    @Override
    public int compareTo(PowerData o) {
        return this.unlocked && !o.unlocked ? 1 : this.power.compareTo(o.power);
    }

    @Override
    public NBTBase writeToNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("Id", this.power.getName());
        nbt.func_74757_a("Unlocked", this.unlocked);
        nbt.func_74768_a("XpInvested", this.xpInvested);
        return nbt;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.power.getName());
        buf.writeBoolean(this.unlocked);
        buf.writeInt(this.xpInvested);
    }

    public static class Container
    extends HashMap<Power, PowerData>
    implements NBTHelper.ISerializableObject<Container>,
    Iterable<PowerData> {
        private int forceMax;
        private byte basePower;
        private float regen;
        private boolean dirty = true;

        private Container(Map<? extends Power, ? extends PowerData> map) {
            super(map);
        }

        private Container() {
        }

        public int getForceMax() {
            return this.forceMax;
        }

        public byte getBasePower() {
            return this.basePower;
        }

        public float getRegen() {
            return this.regen;
        }

        public void update(Entity entity) {
            if (this.dirty) {
                this.markDirty(entity);
                this.dirty = false;
            }
        }

        public void markDirty(Entity entity) {
            this.forceMax = 0;
            this.basePower = 0;
            this.regen = 0.0f;
            for (PowerData data : this) {
                if (!data.unlocked) continue;
                PowerStats stats = data.power.powerStats;
                this.regen = stats.regenOperation == 0 ? (this.regen += (float)stats.regen) : (this.regen += (float)stats.regen / 100.0f * this.regen);
                this.forceMax += stats.forceBonus;
                this.basePower = (byte)(this.basePower + stats.baseBonus);
                this.basePower = (byte)(this.basePower - stats.baseRequirement);
            }
        }

        public PowerData add(PowerData value) {
            return this.put(value.power, value);
        }

        public Container validate() {
            for (Power power : Power.POWERS) {
                if (this.containsKey(power)) continue;
                this.add(new PowerData(power));
            }
            this.dirty = true;
            return this;
        }

        @Override
        public Iterator<PowerData> iterator() {
            return this.values().iterator();
        }

        @Override
        public NBTBase writeToNBT() {
            NBTTagList list = new NBTTagList();
            for (PowerData data : this) {
                list.func_74742_a(NBTHelper.writeToNBT(data));
            }
            return list;
        }

        @Override
        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.size());
            for (PowerData data : this) {
                NBTHelper.toBytes(buf, data);
            }
        }

        public static ALData.DataFactory<Container> factory() {
            return new ALData.DataFactory<Container>(){

                @Override
                public Container construct() {
                    return new Container().validate();
                }

                @Override
                public boolean canEqual() {
                    return false;
                }
            };
        }

        public static class Adapter
        implements NBTHelper.ISaveAdapter<Container> {
            @Override
            public Container readFromNBT(NBTBase tag) {
                if (tag instanceof NBTTagList) {
                    Container container = new Container(new HashMap());
                    List<NBTBase> tags = NBTHelper.getTags((NBTTagList)tag);
                    for (int i = 0; i < tags.size(); ++i) {
                        PowerData data = NBTHelper.readFromNBT(tags.get(i), PowerData.class);
                        if (data == null) continue;
                        container.add(data);
                    }
                    return container.validate();
                }
                return null;
            }

            @Override
            public Container fromBytes(ByteBuf buf) {
                Container container = new Container(new HashMap());
                int length = buf.readInt();
                for (int i = 0; i < length; ++i) {
                    container.add(NBTHelper.fromBytes(buf, PowerData.class));
                }
                return container.validate();
            }
        }
    }

    public static class Adapter
    implements NBTHelper.ISaveAdapter<PowerData> {
        @Override
        public PowerData readFromNBT(NBTBase tag) {
            if (tag instanceof NBTTagCompound) {
                NBTTagCompound nbt = (NBTTagCompound)tag;
                PowerData data = new PowerData(Power.getPowerFromName(nbt.func_74779_i("Id")));
                data.unlocked = nbt.func_74767_n("Unlocked");
                data.xpInvested = nbt.func_74762_e("XpInvested");
                return data;
            }
            return null;
        }

        @Override
        public PowerData fromBytes(ByteBuf buf) {
            PowerData data = new PowerData(Power.getPowerFromName(ByteBufUtils.readUTF8String((ByteBuf)buf)));
            data.unlocked = buf.readBoolean();
            data.xpInvested = buf.readInt();
            return data;
        }
    }
}

