/*
 * Decompiled with CFR 0.152.
 */
package com.fiskmods.lightsabers.common.force;

import com.fiskmods.lightsabers.common.data.effect.Effect;
import java.util.Locale;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;

public class PowerDesc {
    public static String create(String action, Object arg1, Object arg2) {
        String gray = EnumChatFormatting.GRAY.toString();
        String yellow = EnumChatFormatting.YELLOW.toString();
        return gray + I18n.func_135052_a((String)("forcepower.stat." + action), (Object[])new Object[]{yellow + PowerDesc.formatObj(arg1) + gray, yellow + PowerDesc.formatObj(arg2) + gray});
    }

    public static String translateFormatted(String key, Object ... args) {
        Object[] args1 = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            args1[i] = PowerDesc.formatObj(args[i]);
        }
        return StatCollector.func_74837_a((String)key, (Object[])args1);
    }

    public static String format(String key, Object ... args) {
        Object[] args1 = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            args1[i] = PowerDesc.formatObj(args[i]);
        }
        return String.format(key, args1);
    }

    public static String formatObj(Object obj) {
        if (obj instanceof Float || obj instanceof Double) {
            return String.valueOf(ItemStack.field_111284_a.format(obj));
        }
        if (obj instanceof Effect) {
            return ((Effect)obj).getLocalizedName();
        }
        if (obj instanceof Target) {
            return ((Target)((Object)obj)).getLocalizedName();
        }
        if (obj instanceof Unit) {
            return ((Unit)((Object)obj)).getLocalizedName();
        }
        return String.valueOf(obj);
    }

    public static String list(Object ... args) {
        String s = "";
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                if (i == args.length - 1) {
                    s = s + " " + StatCollector.func_74838_a((String)"forcepower.list") + " ";
                } else if (i > 0) {
                    s = s + ", ";
                }
            }
            s = s + PowerDesc.formatObj(args[i]);
        }
        return s;
    }

    public static enum Target {
        CASTER,
        TARGET,
        ALLIES,
        ENEMIES,
        MOBS,
        PLAYERS,
        INVISIBLE;


        public String getUnlocalizedName() {
            return "forcepower.stat.target." + this.name().toLowerCase(Locale.ROOT);
        }

        public String getLocalizedName() {
            return StatCollector.func_74837_a((String)this.getUnlocalizedName(), (Object[])new Object[0]);
        }
    }

    public static enum Unit {
        HEALTH,
        DAMAGE,
        ATTACK_DAMAGE,
        FORCE_DAMAGE,
        ENERGY_DAMAGE,
        ABSORPTION,
        SPEED,
        INVISIBILITY,
        IMPACT_RADIUS,
        KNOCKBACK,
        FALL_RESISTANCE;


        public String getUnlocalizedName() {
            return "forcepower.stat.unit." + this.name().toLowerCase(Locale.ROOT);
        }

        public String getLocalizedName() {
            return StatCollector.func_74837_a((String)this.getUnlocalizedName(), (Object[])new Object[0]);
        }
    }
}

