/*
 * Decompiled with CFR 0.152.
 */
package com.fiskmods.lightsabers.common.force;

import com.fiskmods.lightsabers.common.data.ALData;
import com.fiskmods.lightsabers.common.force.ForceSide;
import com.fiskmods.lightsabers.common.force.Power;
import com.fiskmods.lightsabers.common.force.PowerData;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;

public class PowerManager {
    private final EntityPlayer thePlayer;

    public PowerManager(EntityPlayer player) {
        this.thePlayer = player;
    }

    public int getHierarchy(Power power) {
        if (this.hasPowerUnlocked(power)) {
            return 0;
        }
        int i = 0;
        Power parent = power.parent;
        while (parent != null && !this.hasPowerUnlocked(parent)) {
            parent = parent.parent;
            ++i;
        }
        return i;
    }

    public boolean hasPowerUnlocked(Power power) {
        return PowerManager.hasPowerUnlocked(this.thePlayer, power);
    }

    public boolean canUnlockPower(Power power) {
        return PowerManager.canUnlockPower(this.thePlayer, power);
    }

    public PowerData getPowerData(Power power) {
        return PowerManager.getPowerData(this.thePlayer, power);
    }

    public static boolean unlockPower(EntityPlayer player, Power power) {
        PowerData data;
        if (!PowerManager.hasPowerUnlocked(player, power) && (data = PowerManager.getPowerData(player, power)) != null) {
            data.setUnlocked((Entity)player, true);
            data.xpInvested = power.getActualXpCost(player);
            ALData.BASE_POWER.incrWithoutNotify((Entity)player, (byte)(power.powerStats.baseBonus - power.powerStats.baseRequirement));
            if (power == Power.FORCE_SENSITIVITY) {
                for (ForceSide side : ForceSide.values()) {
                    PowerManager.unlockPower(player, side.getPower());
                }
            }
            PowerManager.unlockPower(player, power.parent);
            return true;
        }
        return false;
    }

    public static boolean removePower(EntityPlayer player, Power power) {
        PowerData data;
        if (PowerManager.hasPowerUnlocked(player, power) && (data = PowerManager.getPowerData(player, power)) != null) {
            data.setUnlocked((Entity)player, false);
            data.xpInvested = 0;
            ALData.BASE_POWER.incrWithoutNotify((Entity)player, (byte)(power.powerStats.baseRequirement - power.powerStats.baseBonus));
            for (Power child : power.children) {
                PowerManager.removePower(player, child);
            }
            return true;
        }
        return false;
    }

    public static boolean hasPowerUnlocked(EntityPlayer player, Power power) {
        PowerData data = PowerManager.getPowerData(player, power);
        return data != null && data.isUnlocked();
    }

    public static boolean canUnlockPower(EntityPlayer player, Power power) {
        return power.parent == null || PowerManager.hasPowerUnlocked(player, power.parent);
    }

    public static PowerData getPowerData(EntityPlayer player, Power power) {
        return (PowerData)ALData.POWERS.get((Entity)player).get(power);
    }

    public static Power getSelectedPower(EntityPlayer player) {
        byte index;
        List<Power> selectedPowers = ALData.SELECTED_POWERS.get((Entity)player);
        if (!selectedPowers.isEmpty() && (index = ALData.SELECTED_POWER.get((Entity)player).byteValue()) >= 0 && index < selectedPowers.size()) {
            return selectedPowers.get(index);
        }
        return null;
    }
}

