/*
 * Decompiled with CFR 0.152.
 */
package com.fiskmods.lightsabers.common.force.effect;

import com.fiskmods.lightsabers.common.data.effect.Effect;
import com.fiskmods.lightsabers.common.data.effect.StatusEffect;
import com.fiskmods.lightsabers.common.force.PowerDesc;
import com.fiskmods.lightsabers.common.force.effect.PowerEffect;
import cpw.mods.fml.relauncher.Side;
import fiskfille.utils.helper.VectorHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class PowerEffectChoke
extends PowerEffect {
    public PowerEffectChoke(int amplifier) {
        super(amplifier);
    }

    @Override
    public boolean execute(EntityPlayer player, Side side) {
        World world = player.field_70170_p;
        double range = 16.0;
        Vec3 src = VectorHelper.getOffsetCoords((EntityLivingBase)player, 0.0, 0.0, 0.0);
        Vec3 dest = VectorHelper.getOffsetCoords((EntityLivingBase)player, 0.0, 0.0, range);
        Vec3 hitVec = null;
        MovingObjectPosition rayTrace = world.func_72933_a(VectorHelper.copy(src), VectorHelper.copy(dest));
        hitVec = rayTrace == null ? dest : rayTrace.field_72307_f;
        double distance = player.func_70011_f(hitVec.field_72450_a, hitVec.field_72448_b, hitVec.field_72449_c);
        block0: for (double point = 0.0; point <= distance; point += 0.15) {
            Vec3 particleVec = VectorHelper.getOffsetCoords((EntityLivingBase)player, 0.0, 0.0, point);
            for (EntityLivingBase entity : VectorHelper.getEntitiesNear(EntityLivingBase.class, world, particleVec, 0.5)) {
                if (entity == null || entity == player || player.field_70154_o == entity) continue;
                hitVec.field_72450_a = entity.field_70165_t;
                hitVec.field_72448_b = entity.field_70163_u;
                hitVec.field_72449_c = entity.field_70161_v;
                rayTrace = new MovingObjectPosition((Entity)entity, hitVec);
                distance = player.func_70011_f(hitVec.field_72450_a, hitVec.field_72448_b, hitVec.field_72449_c);
                continue block0;
            }
        }
        if (rayTrace != null && rayTrace.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY && rayTrace.field_72308_g instanceof EntityLivingBase) {
            StatusEffect.add((EntityLivingBase)rayTrace.field_72308_g, (EntityLivingBase)player, Effect.CHOKE, 60, this.amplifier);
            return true;
        }
        return false;
    }

    @Override
    public String[] getDesc() {
        return new String[]{PowerDesc.create("effect", PowerDesc.format("%s %s%s", new Object[]{2 + this.amplifier * 2, PowerDesc.Unit.DAMAGE, EnumChatFormatting.GRAY + "/"}), (Object)PowerDesc.Target.TARGET), PowerDesc.create("effect", PowerDesc.format("%s %s%s", Effect.STUN, EnumChatFormatting.GRAY, Float.valueOf(PowerEffectChoke.getStunDuration(this.amplifier))), (Object)PowerDesc.Target.TARGET)};
    }

    public static float getStunDuration(int amplifier) {
        float f = 1.5f;
        if (amplifier > 0) {
            f += 1.0f + (float)(amplifier - 1) * 0.5f;
        }
        return f;
    }
}

