/*
 * Decompiled with CFR 0.152.
 */
package com.fiskmods.lightsabers.common.force.effect;

import com.fiskmods.lightsabers.common.data.ALData;
import com.fiskmods.lightsabers.common.data.effect.Effect;
import com.fiskmods.lightsabers.common.data.effect.StatusEffect;
import com.fiskmods.lightsabers.common.force.Power;
import com.fiskmods.lightsabers.common.force.PowerDesc;
import com.fiskmods.lightsabers.common.force.effect.PowerEffect;
import com.fiskmods.lightsabers.helper.ALHelper;
import com.google.common.collect.Lists;
import cpw.mods.fml.relauncher.Side;
import fiskfille.utils.helper.VectorHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class PowerEffectDrain
extends PowerEffect {
    public PowerEffectDrain(int amplifier) {
        super(amplifier);
    }

    @Override
    public boolean execute(EntityPlayer player, Side side) {
        World world = player.field_70170_p;
        List<EntityLivingBase> list = this.getTargets(player);
        for (EntityLivingBase entity : list) {
            StatusEffect.add(entity, (EntityLivingBase)player, Effect.DRAIN, 30, this.amplifier);
        }
        if (list.size() > 0) {
            ALData.DRAIN_LIFE_TIMER.setWithoutNotify((Entity)player, Float.valueOf(1.0f));
            return true;
        }
        return false;
    }

    @Override
    public String[] getDesc() {
        return new String[]{PowerDesc.create("absorb", PowerDesc.format("%s %s", new Object[]{4 + this.amplifier * 2, PowerDesc.Unit.HEALTH}), (Object)(this.amplifier < 2 ? PowerDesc.Target.TARGET : PowerDesc.Target.ENEMIES))};
    }

    public List<EntityLivingBase> getTargets(EntityPlayer player) {
        double range;
        ArrayList list = Lists.newArrayList();
        World world = player.field_70170_p;
        double d = range = this.amplifier < 2 ? 5.0 : 7.0;
        if (this.amplifier < 2) {
            Vec3 src = VectorHelper.getOffsetCoords((EntityLivingBase)player, 0.0, 0.0, 0.0);
            Vec3 dest = VectorHelper.getOffsetCoords((EntityLivingBase)player, 0.0, 0.0, range);
            Vec3 hitVec = null;
            MovingObjectPosition rayTrace = world.func_72933_a(VectorHelper.copy(src), VectorHelper.copy(dest));
            hitVec = rayTrace == null ? dest : rayTrace.field_72307_f;
            double distance = player.func_70011_f(hitVec.field_72450_a, hitVec.field_72448_b, hitVec.field_72449_c);
            block0: for (double point = 0.0; point <= distance; point += 0.15) {
                Vec3 particleVec = VectorHelper.getOffsetCoords((EntityLivingBase)player, 0.0, 0.0, point);
                for (EntityLivingBase entity : VectorHelper.getEntitiesNear(EntityLivingBase.class, world, particleVec, 0.5)) {
                    if (entity == null || entity == player || player.field_70154_o == entity) continue;
                    hitVec.field_72450_a = entity.field_70165_t;
                    hitVec.field_72448_b = entity.field_70163_u;
                    hitVec.field_72449_c = entity.field_70161_v;
                    rayTrace = new MovingObjectPosition((Entity)entity, hitVec);
                    distance = player.func_70011_f(hitVec.field_72450_a, hitVec.field_72448_b, hitVec.field_72449_c);
                    continue block0;
                }
            }
            if (rayTrace != null && rayTrace.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY && rayTrace.field_72308_g instanceof EntityLivingBase) {
                EntityLivingBase entity = (EntityLivingBase)rayTrace.field_72308_g;
                list.add(entity);
            }
        } else {
            AxisAlignedBB aabb = player.field_70121_D.func_72329_c().func_72314_b(range, range, range);
            List list1 = world.func_82733_a(EntityLivingBase.class, aabb, IEntitySelector.field_94557_a);
            float force = ((Float)ALData.FORCE_POWER.get((Entity)player)).floatValue() + 15.0f;
            float cost = super.getUseCost(player, Effect.DRAIN.getPower(this.amplifier));
            for (EntityLivingBase entity : list1) {
                if (ALHelper.isAlly((EntityLivingBase)player, entity) || entity == player) continue;
                if (!(force >= cost + (float)(list.size() * 15) + 15.0f)) break;
                list.add(entity);
            }
        }
        return list;
    }

    @Override
    public float getUseCost(EntityPlayer player, Power power) {
        float force;
        float cost = super.getUseCost(player, power);
        if (this.amplifier >= 2 && (force = ((Float)ALData.FORCE_POWER.get((Entity)player)).floatValue()) >= cost) {
            cost += (float)((this.getTargets(player).size() - 1) * 15);
        }
        return cost;
    }
}

