/*
 * Decompiled with CFR 0.152.
 */
package com.fiskmods.lightsabers.common.force.effect;

import com.fiskmods.lightsabers.Lightsabers;
import com.fiskmods.lightsabers.client.sound.ALSounds;
import com.fiskmods.lightsabers.client.sound.MovingSoundStatusEffect;
import com.fiskmods.lightsabers.common.data.effect.Effect;
import com.fiskmods.lightsabers.common.force.PowerDesc;
import com.fiskmods.lightsabers.common.force.effect.PowerEffectStatus;
import com.fiskmods.lightsabers.helper.ALRenderHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import org.lwjgl.opengl.GL11;

public class PowerEffectFortify
extends PowerEffectStatus {
    public PowerEffectFortify(int amplifier) {
        super(Effect.FORTIFY, amplifier);
    }

    @Override
    public String[] getDesc() {
        return new String[]{PowerDesc.create("divide", (Object)PowerDesc.Unit.FORCE_DAMAGE, Float.valueOf(PowerEffectFortify.getModifierAmount(this.amplifier)))};
    }

    @Override
    public void start(EntityPlayer player, Side side) {
        if (side.isClient() && Lightsabers.proxy.isClientPlayer((EntityLivingBase)player)) {
            this.playSound(player);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void playSound(EntityPlayer player) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new MovingSoundStatusEffect((EntityLivingBase)player, Effect.FORTIFY, ALSounds.ambient_fortify));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(EntityPlayer player, float partialTicks) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("lightsabers", "textures/misc/force_shield.png"));
        GL11.glPushMatrix();
        Tessellator tessellator = Tessellator.field_78398_a;
        boolean prevLighting = GL11.glGetBoolean((int)2896);
        float prevWidth = GL11.glGetFloat((int)2849);
        ALRenderHelper.setLighting(61680);
        GL11.glLineWidth((float)5.0f);
        GL11.glDepthMask((boolean)false);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glAlphaFunc((int)516, (float)0.99f);
        GL11.glDisable((int)3008);
        GL11.glBlendFunc((int)770, (int)32772);
        float f = 0.25f * (float)this.amplifier;
        float f1 = (float)player.field_70173_aa + partialTicks;
        float range = Math.max(player.field_70130_N, player.field_70131_O) * 0.75f;
        float angleIncr = 1.0f;
        float coverage = 45.0f;
        int amount = 360;
        float spread = 360.0f / (float)amount;
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(-range * 0.75f + range * MathHelper.func_76134_b((float)(f1 / 10.0f)) * 0.05f));
        GL11.glRotatef((float)(MathHelper.func_76126_a((float)(f1 / 10.0f)) * 5.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)(MathHelper.func_76126_a((float)(f1 / 10.0f + 10.0f)) * 5.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(MathHelper.func_76126_a((float)(f1 / 10.0f + 20.0f)) * 5.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)range);
        for (int i = 0; i < amount; ++i) {
            GL11.glPushMatrix();
            tessellator.func_78371_b(3);
            tessellator.func_78370_a(54 + (int)(146.0f * f), 84 + (int)(-84.0f * f), 181 + (int)(19.0f * f), 50);
            int j = 0;
            while ((float)j < coverage / angleIncr) {
                Vec3 vec3 = Vec3.func_72443_a((double)0.0, (double)range, (double)0.0);
                float pitch = 90.0f + (float)j * angleIncr;
                float yaw = 180.0f;
                float roll = (float)i * spread;
                vec3.func_72440_a(-pitch * (float)Math.PI / 180.0f);
                vec3.func_72442_b(-yaw * (float)Math.PI / 180.0f);
                vec3.func_72446_c(-roll * (float)Math.PI / 180.0f);
                tessellator.func_78374_a(vec3.field_72450_a, vec3.field_72448_b, vec3.field_72449_c, 0.0, (double)((float)j / (coverage / angleIncr)));
                ++j;
            }
            tessellator.func_78381_a();
            GL11.glPopMatrix();
        }
        GL11.glLineWidth((float)prevWidth);
        GL11.glDisable((int)3042);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        GL11.glEnable((int)3008);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDepthMask((boolean)true);
        if (prevLighting) {
            GL11.glEnable((int)2896);
        }
        ALRenderHelper.resetLighting();
        GL11.glPopMatrix();
    }

    public static float getModifierAmount(int amplifier) {
        float f = 0.25f;
        for (int i = 0; i < amplifier; ++i) {
            f *= 2.0f;
        }
        return 1.0f + f;
    }
}

