/*
 * Decompiled with CFR 0.152.
 */
package com.fiskmods.lightsabers.common.force.effect;

import com.fiskmods.lightsabers.client.particle.ALParticleType;
import com.fiskmods.lightsabers.client.particle.ALParticles;
import com.fiskmods.lightsabers.client.sound.ALSounds;
import com.fiskmods.lightsabers.common.force.ForceSide;
import com.fiskmods.lightsabers.common.force.PowerDesc;
import com.fiskmods.lightsabers.common.force.effect.PowerEffect;
import com.fiskmods.lightsabers.helper.ALHelper;
import com.google.common.collect.Lists;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;

public class PowerEffectHeal
extends PowerEffect {
    public final float heal;
    public final float aoeHeal;

    public PowerEffectHeal(float heal, float aoeHeal) {
        super(0);
        this.heal = heal;
        this.aoeHeal = aoeHeal;
    }

    @Override
    public boolean execute(EntityPlayer player, Side side) {
        player.func_70691_i((float)this.amplifier);
        if (this.aoeHeal > 0.0f) {
            AxisAlignedBB aabb = player.field_70121_D.func_72329_c().func_72314_b(6.0, 6.0, 6.0);
            List list = player.field_70170_p.func_82733_a(EntityLivingBase.class, aabb, IEntitySelector.field_94557_a);
            for (EntityLivingBase entity : list) {
                if (!ALHelper.isAlly((EntityLivingBase)player, entity) && entity != player) continue;
                if (entity != player) {
                    entity.func_70691_i(this.aoeHeal);
                }
                if (!side.isClient()) continue;
                this.doParticles(entity);
            }
        } else if (side.isClient()) {
            this.doParticles((EntityLivingBase)player);
        }
        return true;
    }

    @Override
    public String[] getDesc() {
        ArrayList list = Lists.newArrayList();
        list.add(PowerDesc.create("to", PowerDesc.format("+%s %s", new Object[]{Float.valueOf(this.heal), PowerDesc.Unit.HEALTH}), (Object)PowerDesc.Target.CASTER));
        if (this.aoeHeal > 0.0f) {
            list.add(PowerDesc.create("to", PowerDesc.format("+%s %s", new Object[]{Float.valueOf(this.aoeHeal), PowerDesc.Unit.HEALTH}), (Object)PowerDesc.Target.ALLIES));
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    public String getCastSound(ForceSide side) {
        return ALSounds.player_force_heal;
    }

    @Override
    public float getCastSoundPitch(ForceSide side) {
        return 1.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public void doParticles(EntityLivingBase entity) {
        for (int i = 0; i < 16; ++i) {
            ALParticles.spawnParticle(ALParticleType.FORCE_HEAL, entity.field_70165_t + (double)((this.rand.nextFloat() * 2.0f - 1.0f) * entity.field_70130_N), entity.field_70121_D.field_72338_b + (double)(entity.field_70131_O / 3.0f) + (double)(entity.field_70131_O / 3.0f * 2.0f * this.rand.nextFloat()), entity.field_70161_v + (double)((this.rand.nextFloat() * 2.0f - 1.0f) * entity.field_70130_N), 0.0, 0.0, 0.0);
        }
    }
}

