/*
 * Decompiled with CFR 0.152.
 */
package com.fiskmods.lightsabers.common.force.effect;

import com.fiskmods.lightsabers.client.sound.MovingSoundLightning;
import com.fiskmods.lightsabers.common.damage.ALDamageSources;
import com.fiskmods.lightsabers.common.data.effect.Effect;
import com.fiskmods.lightsabers.common.force.PowerDesc;
import com.fiskmods.lightsabers.common.force.effect.PowerEffectStatus;
import com.fiskmods.lightsabers.helper.ALHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;

public class PowerEffectLightning
extends PowerEffectStatus {
    public PowerEffectLightning(int amplifier) {
        super(Effect.LIGHTNING, amplifier);
    }

    @Override
    public String[] getDesc() {
        return new String[]{PowerDesc.create("effect", PowerDesc.format("%s %s%s", new Object[]{4 + this.amplifier * 2, PowerDesc.Unit.DAMAGE, EnumChatFormatting.GRAY + "/"}), (Object)PowerDesc.Target.TARGET)};
    }

    @Override
    public void start(EntityPlayer player, Side side) {
        if (side.isClient()) {
            this.playSound(player);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void playSound(EntityPlayer player) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new MovingSoundLightning((EntityLivingBase)player));
    }

    @Override
    public boolean execute(EntityPlayer player, Side side) {
        EntityLivingBase entity;
        World world = player.field_70170_p;
        boolean flag = super.execute(player, side);
        if (flag && (entity = ALHelper.getForceLightningTarget((EntityLivingBase)player)) != null) {
            entity.func_70097_a(ALDamageSources.causeForceLightningDamage((Entity)player), (float)(4 + this.amplifier * 2));
            entity.field_70159_w = 0.0;
            entity.field_70181_x = Math.min(entity.field_70181_x, 0.0);
            entity.field_70179_y = 0.0;
        }
        return flag;
    }
}

