/*
 * Decompiled with CFR 0.152.
 */
package com.fiskmods.lightsabers.common.force.effect;

import com.fiskmods.lightsabers.common.damage.ALDamageSources;
import com.fiskmods.lightsabers.common.data.ALData;
import com.fiskmods.lightsabers.common.data.ALEntityData;
import com.fiskmods.lightsabers.common.force.PowerDesc;
import com.fiskmods.lightsabers.common.force.effect.PowerEffect;
import cpw.mods.fml.relauncher.Side;
import fiskfille.utils.helper.VectorHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class PowerEffectPush
extends PowerEffect {
    public PowerEffectPush(int amplifier) {
        super(amplifier);
    }

    @Override
    public boolean execute(EntityPlayer player, Side side) {
        World world = player.field_70170_p;
        double range = 16.0;
        Vec3 src = VectorHelper.getOffsetCoords((EntityLivingBase)player, 0.0, 0.0, 0.0);
        Vec3 dest = VectorHelper.getOffsetCoords((EntityLivingBase)player, 0.0, 0.0, range);
        Vec3 hitVec = null;
        MovingObjectPosition rayTrace = world.func_72933_a(VectorHelper.copy(src), VectorHelper.copy(dest));
        hitVec = rayTrace == null ? dest : rayTrace.field_72307_f;
        double distance = player.func_70011_f(hitVec.field_72450_a, hitVec.field_72448_b, hitVec.field_72449_c);
        block0: for (double point = 0.0; point <= distance; point += 0.15) {
            Vec3 particleVec = VectorHelper.getOffsetCoords((EntityLivingBase)player, 0.0, 0.0, point);
            for (EntityLivingBase entity : VectorHelper.getEntitiesNear(EntityLivingBase.class, world, particleVec, 0.5)) {
                if (entity == null || entity == player || player.field_70154_o == entity) continue;
                hitVec.field_72450_a = entity.field_70165_t;
                hitVec.field_72448_b = entity.field_70163_u;
                hitVec.field_72449_c = entity.field_70161_v;
                rayTrace = new MovingObjectPosition((Entity)entity, hitVec);
                distance = player.func_70011_f(hitVec.field_72450_a, hitVec.field_72448_b, hitVec.field_72449_c);
                continue block0;
            }
        }
        if (rayTrace != null && rayTrace.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY && rayTrace.field_72308_g instanceof EntityLivingBase) {
            EntityLivingBase entity = (EntityLivingBase)rayTrace.field_72308_g;
            if (!entity.field_70170_p.field_72995_K) {
                entity.func_70097_a(ALDamageSources.causeForceDamage((Entity)player), PowerEffectPush.getDamage(this.amplifier));
                ALEntityData.getData((EntityLivingBase)entity).forcePushed = true;
            }
            Vec3 vec3 = VectorHelper.getOffsetCoords((EntityLivingBase)player, 0.0, 0.0, 0.5f * PowerEffectPush.getKnockback(this.amplifier));
            entity.field_70159_w += vec3.field_72450_a - src.field_72450_a;
            entity.field_70181_x += vec3.field_72448_b - src.field_72448_b;
            entity.field_70179_y += vec3.field_72449_c - src.field_72449_c;
            ALData.FORCE_PUSHING_TIMER.setWithoutNotify((Entity)player, Float.valueOf(1.0f));
            return true;
        }
        return false;
    }

    @Override
    public String[] getDesc() {
        return new String[]{PowerDesc.create("effect2", PowerDesc.format("+%s %s", new Object[]{Float.valueOf(PowerEffectPush.getKnockback(this.amplifier)), PowerDesc.Unit.KNOCKBACK}), (Object)PowerDesc.Target.TARGET), PowerDesc.create("effect2", PowerDesc.format("%s %s", new Object[]{Float.valueOf(PowerEffectPush.getDamage(this.amplifier)), PowerDesc.Unit.DAMAGE}), (Object)PowerDesc.Target.TARGET)};
    }

    public static float getKnockback(int amplifier) {
        int i = 1;
        for (int j = 0; j < amplifier; ++j) {
            i *= 2;
        }
        return 3 + i;
    }

    public static float getDamage(int amplifier) {
        float f = 1.0f;
        for (int j = 0; j < amplifier; ++j) {
            f *= f + 0.5f;
        }
        return f;
    }
}

