/*
 * Decompiled with CFR 0.152.
 */
package com.fiskmods.lightsabers.common.force.effect;

import com.fiskmods.lightsabers.common.data.effect.Effect;
import com.fiskmods.lightsabers.common.data.effect.StatusEffect;
import com.fiskmods.lightsabers.common.force.PowerDesc;
import com.fiskmods.lightsabers.common.force.effect.PowerEffect;
import com.fiskmods.lightsabers.helper.ALHelper;
import cpw.mods.fml.relauncher.Side;
import fiskfille.utils.helper.VectorHelper;
import java.util.List;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class PowerEffectStun
extends PowerEffect {
    public final float duration;
    public final int durationInt;
    public final boolean aoe;

    public PowerEffectStun(int amplifier, float duration, boolean aoe) {
        super(amplifier);
        this.duration = duration;
        this.durationInt = (int)duration * 20;
        this.aoe = aoe;
    }

    @Override
    public boolean execute(EntityPlayer player, Side side) {
        World world = player.field_70170_p;
        double range = 16.0;
        if (this.aoe) {
            AxisAlignedBB aabb = player.field_70121_D.func_72329_c().func_72314_b(10.0, 10.0, 10.0);
            List list = player.field_70170_p.func_82733_a(EntityLivingBase.class, aabb, IEntitySelector.field_94557_a);
            for (EntityLivingBase entity : list) {
                if (ALHelper.isAlly((EntityLivingBase)player, entity) || entity == player) continue;
                StatusEffect.add(entity, Effect.STUN, this.durationInt, this.amplifier);
            }
            return true;
        }
        Vec3 src = VectorHelper.getOffsetCoords((EntityLivingBase)player, 0.0, 0.0, 0.0);
        Vec3 dest = VectorHelper.getOffsetCoords((EntityLivingBase)player, 0.0, 0.0, range);
        Vec3 hitVec = null;
        MovingObjectPosition rayTrace = world.func_72933_a(VectorHelper.copy(src), VectorHelper.copy(dest));
        hitVec = rayTrace == null ? dest : rayTrace.field_72307_f;
        double distance = player.func_70011_f(hitVec.field_72450_a, hitVec.field_72448_b, hitVec.field_72449_c);
        block1: for (double point = 0.0; point <= distance; point += 0.15) {
            Vec3 particleVec = VectorHelper.getOffsetCoords((EntityLivingBase)player, 0.0, 0.0, point);
            for (EntityLivingBase entity : VectorHelper.getEntitiesNear(EntityLivingBase.class, world, particleVec, 0.5)) {
                if (entity == null || entity == player || player.field_70154_o == entity) continue;
                hitVec.field_72450_a = entity.field_70165_t;
                hitVec.field_72448_b = entity.field_70163_u;
                hitVec.field_72449_c = entity.field_70161_v;
                rayTrace = new MovingObjectPosition((Entity)entity, hitVec);
                distance = player.func_70011_f(hitVec.field_72450_a, hitVec.field_72448_b, hitVec.field_72449_c);
                continue block1;
            }
        }
        if (rayTrace != null && rayTrace.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY && rayTrace.field_72308_g instanceof EntityLivingBase) {
            EntityLivingBase entity = (EntityLivingBase)rayTrace.field_72308_g;
            StatusEffect.add(entity, Effect.STUN, this.durationInt, this.amplifier);
            return true;
        }
        return false;
    }

    @Override
    public String[] getDesc() {
        return new String[]{PowerDesc.create("effect", PowerDesc.format("%s %s%s", Effect.STUN, EnumChatFormatting.GRAY, Float.valueOf(this.duration)), (Object)(this.aoe ? PowerDesc.Target.ENEMIES : PowerDesc.Target.TARGET))};
    }
}

